/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.util.Duration;
import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.CleanupExpiredEvents;
import com.tridium.cloudLink.schedule.plugin.DefaultOutput;
import com.tridium.cloudLink.schedule.plugin.Facets;
import com.tridium.cloudLink.schedule.plugin.ScanLimit;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.Union;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;

public class ControlScheduleConverter
extends DefaultScheduleConverter {
    public ControlScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BControlSchedule;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("ControlScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        TagUtil.getCloudId((BComponent)schedule).ifPresent(id -> ical.setUid(id.toString()));
        super.convert(schedule, ical);
        BControlSchedule controlSchedule = (BControlSchedule)schedule;
        BAbsTime lastModified = controlSchedule.getLastModified();
        if (lastModified != BAbsTime.NULL) {
            ical.setLastModified(Date.from(Instant.ofEpochMilli(lastModified.getMillis())));
        }
        ical.setCleanupExpiredEvents(new CleanupExpiredEvents(controlSchedule.getCleanupExpiredEvents()));
        BStatusValue defaultOutput = controlSchedule.getDefaultOutput();
        ical.setDefaultOutput(new DefaultOutput(defaultOutput.getValueValue()));
        ical.setFacets(new Facets(controlSchedule.getFacets().encodeToString()));
        Duration duration = Duration.fromMillis(controlSchedule.getScanLimit().getMillis());
        ical.setScanLimit(new ScanLimit(duration));
        ical.setUnion(new Union(controlSchedule.getUnion()));
        return ical;
    }
}

