/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

public class CompositeScheduleConverter
extends DefaultScheduleConverter {
    public CompositeScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BCompositeSchedule;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("CompositeScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        BAbstractSchedule[] kids = ((BCompositeSchedule)schedule).getSchedules();
        for (int i = 0; i < kids.length; ++i) {
            ScheduleVCalendar ci = this.master.convert(kids[i], new ScheduleVCalendar());
            for (ScheduleVEvent e : ci.getScheduleEvents()) {
                e.setSummary(schedule.getDisplayName((Context)new BasicContext()));
                ical.addEvent(e);
            }
        }
        return ical;
    }
}

