/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.channel.BScheduleChannel;
import com.tridium.cloudLink.objectIdentity.BCloudIdManager;
import com.tridium.cloudLink.schedule.BCloudScheduleExportPolicy;
import com.tridium.cloudLink.schedule.BCloudScheduleImportPolicy;
import com.tridium.cloudLink.schedule.BCloudSchedulePolicyContainer;
import com.tridium.cloudLink.util.BCompletableFutureWrapper;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnknownSchemeException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="scheduleReference", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"schedule:ControlSchedule\")")}), @NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeMinutes(5)))", override=true)})
@NiagaraAction(name="cloudIdsUpdated", returnType="BCompletableFutureWrapper", flags=20)
public abstract class BCloudSchedulePolicy
extends BAbstractDescriptor
implements BIAlarmSource,
IPropertyValidator {
    public static final Property scheduleReference = BCloudSchedulePolicy.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"schedule:ControlSchedule")));
    public static final Property executionTime = BCloudSchedulePolicy.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)5))), null);
    public static final Action cloudIdsUpdated = BCloudSchedulePolicy.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BCloudSchedulePolicy.class);
    private boolean scheduleRefValid = true;
    protected static final Lexicon lex = Lexicon.make(BCloudScheduleExportPolicy.class);
    protected static final Logger log = Logger.getLogger("cloudLink.channel.schedule");

    public BOrd getScheduleReference() {
        return (BOrd)this.get(scheduleReference);
    }

    public void setScheduleReference(BOrd v) {
        this.set(scheduleReference, (BValue)v, null);
    }

    public BCompletableFutureWrapper cloudIdsUpdated() {
        return (BCompletableFutureWrapper)this.invoke(cloudIdsUpdated, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BCloudSchedulePolicyContainer;
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        BScheduleChannel channel = this.getChannel();
        if (channel != null) {
            channel.getConnectionService().ifPresent(ccs -> this.linkTo((BComponent)ccs.getCloudIdManager(), (Slot)BCloudIdManager.newCloudIdsAssigned, (Slot)cloudIdsUpdated));
        }
        this.validateScheduleReference();
    }

    public void started() throws Exception {
        super.started();
        if (Sys.isStationStarted()) {
            BScheduleChannel channel = this.getChannel();
            if (channel != null) {
                channel.getConnectionService().ifPresent(ccs -> this.linkTo((BComponent)ccs.getCloudIdManager(), (Slot)BCloudIdManager.newCloudIdsAssigned, (Slot)cloudIdsUpdated));
            }
            this.validateScheduleReference();
        }
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return null;
    }

    public void updateStatus() {
        int newStatus = this.getStatus().getBits();
        BScheduleChannel channel = this.getChannel();
        newStatus = !this.getEnabled() || channel != null && channel.getStatus().isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = !this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess()) ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.getStatus().getBits()) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    protected IFuture postExecute(Action action, BValue bValue, Context context) {
        ((BCloudSchedulePolicyContainer)this.getParent().as(BCloudSchedulePolicyContainer.class)).asyncWorkQueue.enqueue((Object)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    public BCompletableFutureWrapper doCloudIdsUpdated() {
        this.validateScheduleReference();
        return BCompletableFutureWrapper.make(CompletableFuture.completedFuture(null));
    }

    public BAbstractSchedule getSchedule() {
        return (BAbstractSchedule)this.getScheduleReference().get();
    }

    protected BScheduleChannel getChannel() {
        BComplex parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof BScheduleChannel); parent = parent.getParent()) {
        }
        return (BScheduleChannel)parent;
    }

    Optional<BCloudSchedulePolicyContainer> getContainer() {
        return Optional.ofNullable((BCloudSchedulePolicyContainer)this.getParent());
    }

    protected BControlSchedule validateScheduleReference() {
        String faultCause = "";
        BControlSchedule schedule = null;
        try {
            BObject target = this.getScheduleReference().get();
            if (target instanceof BControlSchedule) {
                schedule = (BControlSchedule)target;
                if (!TagUtil.getCloudIdString((BIObject)target).isPresent()) {
                    faultCause = lex.getText("schedule.policy.reference.noCloudId");
                }
                if (this instanceof BCloudScheduleImportPolicy) {
                    BComplex parent = schedule.getParent();
                    if (parent == null) {
                        faultCause = lex.getText("schedule.policy.notMounted");
                    } else {
                        Property scheduleProp = schedule.getPropertyInParent();
                        if (!Flags.isReadonly((BComplex)parent, (Slot)scheduleProp)) {
                            parent.setFlags((Slot)scheduleProp, parent.getFlags((Slot)scheduleProp) | 1);
                        }
                    }
                }
            } else {
                faultCause = lex.getText("schedule.policy.reference.classType");
            }
        }
        catch (BajaRuntimeException bajaRuntimeExcept) {
            faultCause = lex.getText("schedule.policy.reference.unresolved");
        }
        this.setFault(faultCause, !faultCause.isEmpty());
        return faultCause.isEmpty() ? schedule : null;
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (property.equals(scheduleReference)) {
            log.finest(() -> "Validating single property " + property.getDefaultDisplayName(context));
            BComponentSpace compSpace = this.getParentComponent().getComponentSpace();
            if (compSpace == null || !compSpace.isProxyComponentSpace()) {
                return this;
            }
        }
        return null;
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        if (Arrays.asList(properties).contains(scheduleReference)) {
            log.finest(() -> {
                StringBuilder logMsgBuilder = new StringBuilder();
                logMsgBuilder.append("Validating multiple properties: ");
                for (Property p : properties) {
                    logMsgBuilder.append(" property: ");
                    logMsgBuilder.append(p.getDefaultDisplayName(context));
                }
                return logMsgBuilder.toString();
            });
            BComponentSpace compSpace = this.getParentComponent().getComponentSpace();
            if (compSpace == null || !compSpace.isProxyComponentSpace()) {
                return this;
            }
        }
        return null;
    }

    public void validateSet(Validatable validatable, Context context) {
        BOrd proposedScheduleRef = (BOrd)validatable.getProposedValue(scheduleReference);
        if (proposedScheduleRef != null) {
            log.finest(() -> {
                BOrd existingScheduleRef = (BOrd)validatable.getExistingValue(scheduleReference);
                return "Context: " + (context == null ? "null" : context) + " Existing Ord: " + existingScheduleRef.toString(context) + " Proposed Ord: " + proposedScheduleRef.toString(context);
            });
            try {
                BObject target = proposedScheduleRef.get();
                if (!(target instanceof BControlSchedule)) {
                    throw new LocalizableRuntimeException("cloudLink", "schedule.policy.reference.classType");
                }
            }
            catch (NullOrdException | SyntaxException | UnknownSchemeException | UnresolvedException ordExcept) {
                log.log(Level.INFO, "Schedule reference was not resolved due to exception " + ordExcept.getMessage(), log.isLoggable(Level.FINE) ? ordExcept : null);
                throw new LocalizableRuntimeException("cloudLink", "schedule.policy.reference.unresolved");
            }
        }
    }

    private void setFault(String cause, boolean state) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)state));
        this.setFaultCause(cause);
    }
}

