/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.history;

import com.tridium.cloudLink.history.HistoryItemWrapper;
import com.tridium.cloudLink.msg.HistoryItem;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.baja.collection.BITable;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;

public class HistoryItemIterator
implements Iterator<HistoryItemWrapper> {
    private final String systemId;
    private final Map<BHistoryId, BITable<BHistoryRecord>> historyMap;
    private final Map<BHistoryId, String> cloudIdMap;
    private final Iterator<Map.Entry<BHistoryId, BITable<BHistoryRecord>>> entryIter;
    private Iterator<BHistoryRecord> recIter;
    private boolean recIterHasNext;
    private Map.Entry<BHistoryId, BITable<BHistoryRecord>> curEntry;

    public HistoryItemIterator(String systemId, Map<BHistoryId, BITable<BHistoryRecord>> historyMap, Map<BHistoryId, String> cloudIdMap) {
        Objects.requireNonNull(systemId, "systemId must not be null");
        Objects.requireNonNull(historyMap, "historyMap must not be null");
        Objects.requireNonNull(cloudIdMap, "cloudIdMap must not be null");
        this.systemId = systemId;
        this.historyMap = Collections.unmodifiableMap(historyMap);
        this.cloudIdMap = Collections.unmodifiableMap(cloudIdMap);
        this.entryIter = this.historyMap.entrySet().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.recIter != null && this.recIterHasNext) {
            return true;
        }
        while (this.entryIter.hasNext()) {
            this.curEntry = this.entryIter.next();
            this.recIter = this.curEntry.getValue().cursor().iterator();
            this.recIterHasNext = this.recIter.hasNext();
            if (!this.recIterHasNext) continue;
            return true;
        }
        return false;
    }

    @Override
    public HistoryItemWrapper next() {
        if (this.recIter != null && this.recIterHasNext) {
            HistoryItem item = new HistoryItem(this.systemId, this.curEntry.getKey(), (BHistoryRecord)this.recIter.next().newCopy());
            this.recIterHasNext = this.recIter.hasNext();
            return new HistoryItemWrapper(item, this.cloudIdMap.get(item.getHistoryId()));
        }
        throw new NoSuchElementException();
    }
}

