/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.history;

import com.tridium.cloudLink.history.HistoryBatchWrapper;
import com.tridium.cloudLink.history.HistoryItemWrapper;
import com.tridium.cloudLink.msg.IAddMessageData;
import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.util.ICloudLinkBatchContainer;
import java.util.HashMap;
import java.util.Map;
import javax.baja.sys.BAbsTime;

public class HistoryItemBatchContainer
implements ICloudLinkBatchContainer<HistoryBatchWrapper, HistoryItemWrapper> {
    private Map<String, BAbsTime> messageLastTimes;
    private final int sizeThreshold;
    private final IMessageBuilder encoder;
    private final IAddMessageData<HistoryItemWrapper> builder;
    private int size;

    public HistoryItemBatchContainer(int sizeThreshold, IMessageBuilder encoder, IAddMessageData<HistoryItemWrapper> builder) {
        this.sizeThreshold = sizeThreshold;
        this.encoder = encoder;
        this.builder = builder;
        this.messageLastTimes = new HashMap<String, BAbsTime>();
    }

    @Override
    public boolean isFull() {
        return this.size >= this.sizeThreshold;
    }

    @Override
    public void add(HistoryItemWrapper item) {
        if (this.isFull()) {
            throw new IllegalStateException("The batch has reached or exceeded its size threshold");
        }
        this.size = this.builder.add(item);
        this.messageLastTimes.put(item.getHistoryItem().getHistoryId().encodeToString(), item.getHistoryItem().getRecord().getTimestamp());
    }

    @Override
    public HistoryBatchWrapper get() {
        this.size = 0;
        HistoryBatchWrapper wrapper = new HistoryBatchWrapper(this.encoder.toMessage(), this.messageLastTimes);
        this.messageLastTimes = new HashMap<String, BAbsTime>();
        return wrapper;
    }
}

