/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.history;

import com.tridium.cloudLink.msg.GetHistoriesResult;
import com.tridium.cloudLink.util.MergedListsView;
import com.tridium.collection.BListTable;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryCursor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;

public final class HistoryArchiveCacheEntry {
    private final BHistoryId id;
    private final BAbsTime start;
    private final BAbsTime end;
    private final boolean descending;
    private final int limit;
    private final BAbsTime firstAccessed;
    private BAbsTime lastAccessed;
    private final List<BHistoryRecord> records;
    private final Context cursorContext;

    public HistoryArchiveCacheEntry(BHistoryId id, BAbsTime start, BAbsTime end, boolean descending, int limit, MergedListsView<BHistoryRecord> records, BAbsTime firstAccessed, BAbsTime lastAccessed) {
        this.id = id;
        this.start = start;
        this.end = end;
        this.descending = descending;
        this.limit = limit;
        this.records = new LinkedList<BHistoryRecord>();
        for (List<BHistoryRecord> subRecords : records.getLists()) {
            this.records.addAll(subRecords);
        }
        this.firstAccessed = firstAccessed;
        this.lastAccessed = lastAccessed;
        this.cursorContext = new BasicContext(records.getCursor().getContext());
    }

    public static HistoryArchiveCacheEntry makeModifiedEntry(HistoryArchiveCacheEntry entry, boolean descending, int limit) {
        LinkedList<BHistoryRecord> records;
        BHistoryId id = entry.getHistoryId();
        BAbsTime start = entry.getStartTime();
        BAbsTime end = entry.getEndTime();
        int recordLimit = Math.min(limit, entry.getRecordLimit());
        BAbsTime firstAccessed = entry.getFirstAccessedTime();
        BAbsTime lastAccessed = entry.getLastAccessedTime();
        Context cursorContext = entry.cursorContext;
        int numRecordsToCopy = Math.min(limit, entry.getRecordCount());
        if (descending == entry.getDescending()) {
            records = new LinkedList<BHistoryRecord>(entry.records.subList(0, numRecordsToCopy));
            try {
                if (cursorContext != null && numRecordsToCopy < entry.getRecordCount()) {
                    BHistoryRecord preRecord = HistoryCursor.extractPreRecord((BFacets)cursorContext.getFacets());
                    BHistoryRecord newPostRecord = entry.records.get(numRecordsToCopy);
                    cursorContext = new BasicContext(cursorContext, HistoryCursor.makeBoundaryRecordFacets((BHistoryRecord)preRecord, (BHistoryRecord)newPostRecord));
                }
            }
            catch (IOException e) {
                cursorContext = new BasicContext(cursorContext, BFacets.NULL);
            }
        } else {
            records = new LinkedList<BHistoryRecord>(entry.records.subList(entry.getRecordCount() - numRecordsToCopy, entry.records.size()));
            Collections.reverse(records);
            try {
                if (cursorContext != null && numRecordsToCopy < entry.getRecordCount()) {
                    BHistoryRecord newPreRecord = HistoryCursor.extractPostRecord((BFacets)cursorContext.getFacets());
                    BHistoryRecord newPostRecord = entry.records.get(entry.getRecordCount() - numRecordsToCopy - 1);
                    cursorContext = new BasicContext(cursorContext, HistoryCursor.makeBoundaryRecordFacets((BHistoryRecord)newPreRecord, (BHistoryRecord)newPostRecord));
                } else if (cursorContext != null && numRecordsToCopy == entry.getRecordCount()) {
                    BHistoryRecord newPreRecord = HistoryCursor.extractPostRecord((BFacets)cursorContext.getFacets());
                    BHistoryRecord newPostRecord = HistoryCursor.extractPreRecord((BFacets)cursorContext.getFacets());
                    cursorContext = new BasicContext(cursorContext, HistoryCursor.makeBoundaryRecordFacets((BHistoryRecord)newPreRecord, (BHistoryRecord)newPostRecord));
                }
            }
            catch (IOException e) {
                cursorContext = new BasicContext(cursorContext, BFacets.NULL);
            }
        }
        cursorContext = GetHistoriesResult.makeHistoryQueryResultCountContext(cursorContext, numRecordsToCopy);
        return new HistoryArchiveCacheEntry(id, start, end, descending, recordLimit, new MergedListsView<BHistoryRecord>(records, cursorContext), firstAccessed, lastAccessed);
    }

    public BHistoryId getHistoryId() {
        return this.id;
    }

    public BAbsTime getStartTime() {
        return this.start;
    }

    public BAbsTime getEndTime() {
        return this.end;
    }

    public boolean getDescending() {
        return this.descending;
    }

    public int getRecordLimit() {
        return this.limit;
    }

    public BAbsTime getFirstAccessedTime() {
        return this.firstAccessed;
    }

    public synchronized BAbsTime getLastAccessedTime() {
        return this.lastAccessed;
    }

    public synchronized void setLastAccessedTime(BAbsTime time) {
        if (!time.isAfter(BAbsTime.now())) {
            this.lastAccessed = time;
        }
    }

    public int getRecordCount() {
        return this.records.size();
    }

    public Cursor<BHistoryRecord> getCursor() {
        return new BListTable(this.records, this.cursorContext).cursor();
    }

    public List<BHistoryRecord> getRecords() {
        return Collections.unmodifiableList(this.records);
    }
}

