/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.history;

import com.tridium.cloudLink.history.HistoryArchiveCacheEntry;
import com.tridium.cloudLink.msg.GetHistoriesResult;
import com.tridium.cloudLink.util.MergedListsView;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryCursor;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ExecutorUtil;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="currentRecordCount", type="int", defaultValue="0", flags=7), @NiagaraProperty(name="maxRecordCount", type="int", defaultValue="12000", facets={@Facet(name="BFacets.MIN", value="1")}), @NiagaraProperty(name="timeToLive", type="BRelTime", defaultValue="BRelTime.makeMinutes(60)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeMinutes(15)")})})
@NiagaraAction(name="clearCache", flags=256)
public class BHistoryArchiveCache
extends BComponent {
    public static final Property currentRecordCount = BHistoryArchiveCache.newProperty((int)7, (int)0, null);
    public static final Property maxRecordCount = BHistoryArchiveCache.newProperty((int)0, (int)12000, (BFacets)BFacets.make((String)"min", (int)1));
    public static final Property timeToLive = BHistoryArchiveCache.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)60), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)15)));
    public static final Action clearCache = BHistoryArchiveCache.newAction((int)256, null);
    public static final Type TYPE = Sys.loadType(BHistoryArchiveCache.class);
    private final Map<HistoryArchiveCacheKey, HistoryArchiveCacheEntry> cache = new LinkedHashMap<HistoryArchiveCacheKey, HistoryArchiveCacheEntry>();
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> removeStaleEntriesSchedule;
    private static final Logger log = Logger.getLogger("cloudLink.channel.history");
    private final Object syncObject = new Object();

    public int getCurrentRecordCount() {
        return this.getInt(currentRecordCount);
    }

    public void setCurrentRecordCount(int v) {
        this.setInt(currentRecordCount, v, null);
    }

    public int getMaxRecordCount() {
        return this.getInt(maxRecordCount);
    }

    public void setMaxRecordCount(int v) {
        this.setInt(maxRecordCount, v, null);
    }

    public BRelTime getTimeToLive() {
        return (BRelTime)this.get(timeToLive);
    }

    public void setTimeToLive(BRelTime v) {
        this.set(timeToLive, (BValue)v, null);
    }

    public void clearCache() {
        this.invoke(clearCache, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.executor = ExecutorUtil.newSingleThreadBackgroundScheduledExecutor((String)"cloudLink.history.historyArchiveCache.removeStaleCacheEntries", (long)2L, (TimeUnit)TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p.equals(timeToLive)) {
            Object object = this.syncObject;
            synchronized (object) {
                if (this.removeStaleEntriesSchedule != null) {
                    this.removeStaleEntriesSchedule.cancel(false);
                    this.removeStaleEntriesSchedule = this.executor.schedule(this::removeStaleEntries, 0L, TimeUnit.MILLISECONDS);
                }
            }
        }
        if (p.equals(maxRecordCount)) {
            Object object = this.syncObject;
            synchronized (object) {
                while (this.getCurrentRecordCount() > this.getMaxRecordCount()) {
                    this.removeLRUEntry();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        super.stopped();
        Object object = this.syncObject;
        synchronized (object) {
            if (this.removeStaleEntriesSchedule != null) {
                this.removeStaleEntriesSchedule.cancel(true);
            }
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public Object getSyncObject() {
        return this.syncObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPartialEntry(BHistoryId id, BAbsTime start, BAbsTime end, boolean descending) {
        HistoryArchiveCacheKey key = new HistoryArchiveCacheKey(id, start, end);
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.cache.containsKey(key)) {
                log.finest(() -> String.format("History archive cache did not find partial entry for parameters (id=%s, start=%s, end=%s, descending=%b)", id.toString(), start.encodeToString(), end.encodeToString(), descending));
                return false;
            }
            HistoryArchiveCacheEntry entry = this.cache.get(key);
            if (entry.getRecordCount() < entry.getRecordLimit()) {
                log.finest(() -> String.format("History archive cache found partial entry containing %d records for parameters (id=%s, start=%s, end=%s, descending=%b)", entry.getRecordCount(), id.toString(), start.encodeToString(), end.encodeToString(), descending));
                return true;
            }
            if (descending == entry.getDescending()) {
                log.finest(() -> String.format("History archive cache found partial entry containing %d records for parameters (id=%s, start=%s, end=%s, descending=%b)", entry.getRecordCount(), id.toString(), start.encodeToString(), end.encodeToString(), descending));
                return true;
            }
            log.finest(() -> String.format("History archive cache did not find partial entry for parameters (id=%s, start=%s, end=%s, descending=%b)", id.toString(), start.encodeToString(), end.encodeToString(), descending));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEntry(BHistoryId id, BAbsTime start, BAbsTime end, boolean descending, int limit) {
        HistoryArchiveCacheKey key = new HistoryArchiveCacheKey(id, start, end);
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.cache.containsKey(key)) {
                log.finest(() -> String.format("History archive cache did not find entry for parameters (id=%s, start=%s, end=%s, descending=%b, limit=%d)", id.toString(), start.encodeToString(), end.encodeToString(), descending, limit));
                return false;
            }
            HistoryArchiveCacheEntry entry = this.cache.get(key);
            if (entry.getRecordCount() < entry.getRecordLimit()) {
                log.finest(() -> String.format("History archive cache found entry containing %d records for parameters (id=%s, start=%s, end=%s, descending=%b, limit=%d)", entry.getRecordCount(), id.toString(), start.encodeToString(), end.encodeToString(), descending, limit));
                return true;
            }
            if (descending == entry.getDescending() && entry.getRecordLimit() >= limit) {
                log.finest(() -> String.format("History archive cache found entry containing %d records for parameters (id=%s, start=%s, end=%s, descending=%b, limit=%d)", entry.getRecordCount(), id.toString(), start.encodeToString(), end.encodeToString(), descending, limit));
                return true;
            }
            log.finest(() -> String.format("History archive cache did not find entry for parameters (id=%s, start=%s, end=%s, descending=%b, limit=%d)", id.toString(), start.encodeToString(), end.encodeToString(), descending, limit));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<HistoryArchiveCacheEntry> getEntry(BHistoryId id, BAbsTime start, BAbsTime end, boolean descending, int limit) {
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.hasPartialEntry(id, start, end, descending)) {
                return Optional.empty();
            }
            HistoryArchiveCacheKey key = new HistoryArchiveCacheKey(id, start, end);
            HistoryArchiveCacheEntry entry = this.cache.get(key);
            HistoryArchiveCacheEntry modifiedEntry = HistoryArchiveCacheEntry.makeModifiedEntry(entry, descending, limit);
            entry.setLastAccessedTime(BAbsTime.now());
            this.cache.remove(key);
            this.cache.put(key, entry);
            log.finest(() -> String.format("History archive cache retrieved entry containing %d records for parameters (id=%s, start=%s, end=%s, descending=%b, limit=%d)", entry.getRecordCount(), id.toString(), start.encodeToString(), end.encodeToString(), descending, limit));
            return Optional.of(modifiedEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(BHistoryId id, BAbsTime start, BAbsTime end, boolean descending, int limit, MergedListsView<BHistoryRecord> records) {
        Object object = this.syncObject;
        synchronized (object) {
            HistoryArchiveCacheEntry entry;
            if (this.getCurrentRecordCount() == 0) {
                long delay = Math.round((double)this.getTimeToLive().getMillis() / 10.0);
                log.finest(() -> String.format("Scheduling history archive cache stale entry check in %d ms", delay));
                this.removeStaleEntriesSchedule = this.executor.schedule(this::removeStaleEntries, delay, TimeUnit.MILLISECONDS);
            }
            HistoryArchiveCacheKey key = new HistoryArchiveCacheKey(id, start, end);
            if (records.size() > this.getMaxRecordCount()) {
                Context cursorContext = records.getCursor().getContext();
                Context limitedContext = Context.NULL;
                try {
                    BHistoryRecord preRecord = HistoryCursor.extractPreRecord((BFacets)cursorContext.getFacets());
                    BHistoryRecord newPostRecord = records.get(this.getMaxRecordCount());
                    limitedContext = new BasicContext(cursorContext, HistoryCursor.makeBoundaryRecordFacets((BHistoryRecord)preRecord, (BHistoryRecord)newPostRecord));
                }
                catch (IOException preRecord) {
                    // empty catch block
                }
                limitedContext = GetHistoriesResult.makeHistoryQueryResultCountContext(limitedContext, this.getMaxRecordCount());
                records.setCursorContext(limitedContext);
                MergedListsView<BHistoryRecord> subview = records.subView(0, this.getMaxRecordCount());
                if (subview == null || subview.size() == 0) {
                    log.config("subview contains no records.");
                    return;
                }
                entry = new HistoryArchiveCacheEntry(id, start, end, descending, this.getMaxRecordCount(), subview, BAbsTime.now(), BAbsTime.now());
            } else {
                entry = new HistoryArchiveCacheEntry(id, start, end, descending, limit, records, BAbsTime.now(), BAbsTime.now());
            }
            while (!this.entryWillFit(entry)) {
                this.removeLRUEntry();
            }
            this.setCurrentRecordCount(this.getCurrentRecordCount() + entry.getRecordCount());
            this.cache.put(key, entry);
            log.finest(() -> String.format("History archive cache added entry containing %d records for parameters (id=%s, start=%s, end=%s, descending=%b, limit=%d)", entry.getRecordCount(), id.toString(), start.encodeToString(), end.encodeToString(), descending, limit));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClearCache() {
        Object object = this.syncObject;
        synchronized (object) {
            this.setCurrentRecordCount(0);
            this.cache.clear();
            if (this.removeStaleEntriesSchedule != null) {
                this.removeStaleEntriesSchedule.cancel(false);
                this.removeStaleEntriesSchedule = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean entryWillFit(HistoryArchiveCacheEntry entry) {
        Object object = this.syncObject;
        synchronized (object) {
            return this.getCurrentRecordCount() + entry.getRecordCount() <= this.getMaxRecordCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLRUEntry() {
        Object object = this.syncObject;
        synchronized (object) {
            Iterator<Map.Entry<HistoryArchiveCacheKey, HistoryArchiveCacheEntry>> it = this.cache.entrySet().iterator();
            Map.Entry<HistoryArchiveCacheKey, HistoryArchiveCacheEntry> mapEntry = it.next();
            this.setCurrentRecordCount(this.getCurrentRecordCount() - mapEntry.getValue().getRecordCount());
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStaleEntries() {
        Object object = this.syncObject;
        synchronized (object) {
            try {
                Iterator<Map.Entry<HistoryArchiveCacheKey, HistoryArchiveCacheEntry>> it = this.cache.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<HistoryArchiveCacheKey, HistoryArchiveCacheEntry> mapEntry = it.next();
                    BAbsTime lastAccessed = mapEntry.getValue().getLastAccessedTime();
                    BAbsTime expiration = lastAccessed.add(this.getTimeToLive());
                    if (!BAbsTime.now().isAfter(expiration)) continue;
                    this.setCurrentRecordCount(this.getCurrentRecordCount() - mapEntry.getValue().getRecordCount());
                    it.remove();
                }
            }
            catch (Exception e) {
                log.log(Level.INFO, "Error occurred while looking for stale history archive cache entries", log.isLoggable(Level.FINE) ? e : null);
            }
            finally {
                if (this.getCurrentRecordCount() > 0) {
                    if (this.removeStaleEntriesSchedule != null) {
                        this.removeStaleEntriesSchedule.cancel(false);
                        this.removeStaleEntriesSchedule = null;
                    }
                    long delay = Math.round((double)this.getTimeToLive().getMillis() / 10.0);
                    log.finest(() -> String.format("Scheduling history archive cache stale entry check in %d ms", delay));
                    this.removeStaleEntriesSchedule = this.executor.schedule(this::removeStaleEntries, delay, TimeUnit.MILLISECONDS);
                } else {
                    this.removeStaleEntriesSchedule = null;
                }
            }
        }
    }

    private static class HistoryArchiveCacheKey {
        private final BHistoryId id;
        private final BAbsTime start;
        private final BAbsTime end;

        public HistoryArchiveCacheKey(BHistoryId id, BAbsTime start, BAbsTime end) {
            this.id = id;
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            HistoryArchiveCacheKey otherKey = (HistoryArchiveCacheKey)other;
            return this.id.equals((Object)otherKey.id) && this.start.equals((Object)otherKey.start) && this.end.equals((Object)otherKey.end);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.start, this.end);
        }
    }
}

