/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.file;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.file.FileUploadRequest;
import com.tridium.cloudLink.file.IFileUploadInfo;
import com.tridium.cloudLink.file.IFileUploadStatus;
import com.tridium.cloudLink.msg.IEndFileUploadHandler;
import com.tridium.cloudLink.msg.ISensitiveMessageBuilder;
import com.tridium.cloudLink.msg.IStartFileUploadHandler;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.MessageWrapper;
import java.io.IOException;
import java.security.AccessController;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;

public abstract class FileUploader {
    protected final BAbstractClientChannel channel;
    protected Class<? extends IStartFileUploadHandler> startUploadClass;
    protected Class<? extends IEndFileUploadHandler> endUploadClass;
    protected static final Logger log = Logger.getLogger("cloudLink.file.upload");

    protected FileUploader(BAbstractClientChannel channel) {
        this.channel = channel;
        this.startUploadClass = IStartFileUploadHandler.class;
        this.endUploadClass = IEndFileUploadHandler.class;
    }

    public CompletableFuture<Void> upload(FileUploadRequest request) {
        CompletableFuture<Void> uploadFuture = new CompletableFuture<Void>();
        this.initializeTransfer(request).whenCompleteAsync((resp, err) -> {
            if (err != null) {
                uploadFuture.completeExceptionally((Throwable)err);
            } else {
                this.doUpload(request, (IFileUploadInfo)resp).whenComplete((statusResp, statusErr) -> {
                    IFileUploadStatus status = statusErr != null ? new IFileUploadStatus((IFileUploadInfo)resp, (Throwable)statusErr){
                        final /* synthetic */ IFileUploadInfo val$resp;
                        final /* synthetic */ Throwable val$statusErr;
                        {
                            this.val$resp = iFileUploadInfo;
                            this.val$statusErr = throwable;
                        }

                        @Override
                        public IFileUploadInfo getInfo() {
                            return this.val$resp;
                        }

                        @Override
                        public Throwable getError() {
                            return this.val$statusErr;
                        }
                    } : statusResp;
                    this.finalizeTransfer(status).whenComplete((notifyResp, notifyErr) -> {
                        if (status.getError() != null) {
                            uploadFuture.completeExceptionally(status.getError());
                        } else if (notifyErr != null) {
                            uploadFuture.completeExceptionally((Throwable)notifyErr);
                        } else {
                            uploadFuture.complete(null);
                        }
                    });
                });
            }
        });
        return uploadFuture;
    }

    protected CompletableFuture<IFileUploadInfo> initializeTransfer(FileUploadRequest request) {
        CompletableFuture<IFileUploadInfo> future = new CompletableFuture<IFileUploadInfo>();
        BChannelConfig config = this.channel.getChannelConfig();
        BAbstractTransport transport = config.getTransport(IStartFileUploadHandler.getOperationId());
        if (!transport.canSend()) {
            log.warning("Could not initialize file upload because the transport cannot send messages");
            future.completeExceptionally(new IOException("Transport unavailable"));
            return future;
        }
        BAbstractCloudLinkHandlerFactory msgFactory = this.channel.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service.")).getMessageHandlerFactory(this.channel.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        IStartFileUploadHandler messageHandler = msgFactory.getMessageHandler(this.startUploadClass, config);
        messageHandler.add(request);
        if (messageHandler instanceof ISensitiveMessageBuilder) {
            AccessController.doPrivileged(() -> {
                ((ISensitiveMessageBuilder)((Object)messageHandler)).loadSensitives();
                return null;
            });
        }
        MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(messageHandler.toMessage(), messageHandler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            config.blockingEnqueueMessage(IStartFileUploadHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return future;
    }

    protected abstract CompletableFuture<IFileUploadStatus> doUpload(FileUploadRequest var1, IFileUploadInfo var2);

    protected CompletableFuture<Void> finalizeTransfer(IFileUploadStatus status) {
        IMessage message;
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (status.getError() != null && !this.shouldFinalizeWhenUploadError(status)) {
            future.completeExceptionally(status.getError());
            return future;
        }
        BChannelConfig config = this.channel.getChannelConfig();
        BAbstractTransport transport = config.getTransport(IEndFileUploadHandler.getOperationId());
        if (!transport.canSend()) {
            log.warning("Could not send upload notification because the transport cannot send messages");
            future.completeExceptionally(new IOException("Transport unavailable"));
            return future;
        }
        BAbstractCloudLinkHandlerFactory msgFactory = this.channel.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service.")).getMessageHandlerFactory(this.channel.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        IEndFileUploadHandler messageHandler = msgFactory.getMessageHandler(this.endUploadClass, config);
        messageHandler.add(status);
        if (messageHandler instanceof ISensitiveMessageBuilder) {
            AccessController.doPrivileged(() -> {
                ((ISensitiveMessageBuilder)((Object)messageHandler)).loadSensitives();
                return null;
            });
        }
        if ((message = messageHandler.toMessage()) == null) {
            future.complete(null);
            return future;
        }
        MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(message, messageHandler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            config.blockingEnqueueMessage(IEndFileUploadHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return future;
    }

    protected boolean shouldFinalizeWhenUploadError(IFileUploadStatus status) {
        return false;
    }
}

