/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.command.BCloudWriteInfo;
import com.tridium.cloudLink.command.BCommand;
import com.tridium.cloudLink.command.BCommandablePriorityLevel;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.control.util.BBooleanOverride;
import javax.baja.control.util.BEnumOverride;
import javax.baja.control.util.BNumericOverride;
import javax.baja.control.util.BOverride;
import javax.baja.control.util.BStringOverride;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BIStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BConversionLink;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="defaultPriority", type="BPriorityLevel", defaultValue="BPriorityLevel.level_16", flags=7), @NiagaraProperty(name="defaultPriorityLevel", type="BCommandablePriorityLevel", defaultValue="BCommandablePriorityLevel.level_16"), @NiagaraProperty(name="defaultDuration", type="BRelTime", defaultValue="BRelTime.makeMinutes(15)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeMinutes(1)")}), @NiagaraProperty(name="acceptWritesOutsideFacetsRange", type="boolean", defaultValue="false")})
public abstract class BWritePointCommand
extends BCommand {
    public static final Property defaultPriority = BWritePointCommand.newProperty((int)7, (BValue)BPriorityLevel.level_16, null);
    public static final Property defaultPriorityLevel = BWritePointCommand.newProperty((int)0, (BValue)BCommandablePriorityLevel.level_16, null);
    public static final Property defaultDuration = BWritePointCommand.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)1)));
    public static final Property acceptWritesOutsideFacetsRange = BWritePointCommand.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BWritePointCommand.class);
    private static final String OVERRIDE_ACTION = "override";
    private static final String ACTIVE_ACTION = "active";
    private static final String INACTIVE_ACTION = "inactive";
    public static final String MSG_TEMPLATE = "WritePointCommand: %s [cloud id %s], %s command [msg id %s]";

    public BPriorityLevel getDefaultPriority() {
        return (BPriorityLevel)this.get(defaultPriority);
    }

    public void setDefaultPriority(BPriorityLevel v) {
        this.set(defaultPriority, (BValue)v, null);
    }

    public BCommandablePriorityLevel getDefaultPriorityLevel() {
        return (BCommandablePriorityLevel)this.get(defaultPriorityLevel);
    }

    public void setDefaultPriorityLevel(BCommandablePriorityLevel v) {
        this.set(defaultPriorityLevel, (BValue)v, null);
    }

    public BRelTime getDefaultDuration() {
        return (BRelTime)this.get(defaultDuration);
    }

    public void setDefaultDuration(BRelTime v) {
        this.set(defaultDuration, (BValue)v, null);
    }

    public boolean getAcceptWritesOutsideFacetsRange() {
        return this.getBoolean(acceptWritesOutsideFacetsRange);
    }

    public void setAcceptWritesOutsideFacetsRange(boolean v) {
        this.setBoolean(acceptWritesOutsideFacetsRange, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        int level = this.getDefaultPriority().getOrdinal();
        if (level > 1 && level < 16) {
            this.setDefaultPriorityLevel(BCommandablePriorityLevel.make(level));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean writePoint(String messageId, String pointId, Object objValue, int priority, BRelTime duration, String source, Context cx) {
        void var25_42;
        BCloudWriteInfo writeInfo;
        boolean result;
        BRelTime cmdDuration;
        String cmdPriority;
        BControlPoint point;
        block46: {
            BFacets facets;
            block48: {
                block47: {
                    if (source == null) {
                        log.info(() -> String.format(MSG_TEMPLATE, "Source not provided for point", pointId, "aborting", messageId));
                        return false;
                    }
                    point = CloudLinkUtils.findPoint(messageId, pointId);
                    if (point == null) {
                        return false;
                    }
                    if (!this.isLicensed(point)) {
                        liclog.warning(() -> String.format("WritePointCommand: point %s not licensed", pointId));
                        return false;
                    }
                    if (!CloudLinkUtils.isPointWriteAllowed(point, cx)) {
                        log.info(() -> String.format(MSG_TEMPLATE, "Insufficient permissions for point", pointId, "aborting", messageId));
                        return false;
                    }
                    if (!(point instanceof BIWritablePoint)) {
                        Action action;
                        if (priority != 8) {
                            log.info(() -> {
                                String msg = String.format("Not permitted at priority %s for point", priority);
                                return String.format(MSG_TEMPLATE, msg, pointId, "aborting", messageId);
                            });
                            return false;
                        }
                        String actionName = OVERRIDE_ACTION;
                        if (point instanceof BBooleanPoint) {
                            boolean value = Boolean.parseBoolean(String.valueOf(objValue));
                            String string = actionName = value ? ACTIVE_ACTION : INACTIVE_ACTION;
                        }
                        if ((action = point.getAction(actionName)) == null) {
                            log.info(() -> String.format(MSG_TEMPLATE, "Not permitted for read-only point", pointId, "aborting", messageId));
                            return false;
                        }
                    }
                    if (priority == 0) {
                        cmdPriority = Integer.toString(this.getDefaultPriorityLevel().getOrdinal());
                    } else {
                        if (priority < 2 || priority > 16) {
                            log.info(() -> String.format(MSG_TEMPLATE, "Requested priority " + priority + " is out of range", pointId, "aborting", messageId));
                            return false;
                        }
                        cmdPriority = Integer.toString(priority);
                    }
                    Optional levelsDvOpt = point.tags().get(CloudLinkConstants.WRITABLE_LEVELS);
                    if (!levelsDvOpt.isPresent() || !(levelsDvOpt.get() instanceof BString)) {
                        log.info(() -> {
                            String msg = String.format("Not permitted, missing %s tag or it's not a string type for point", "nc:writableLevels");
                            return String.format(MSG_TEMPLATE, msg, pointId, "aborting", messageId);
                        });
                        return false;
                    }
                    String levels = ((BString)((BIDataValue)levelsDvOpt.get()).as(BString.class)).getString().trim();
                    String[] levelValues = levels.split(",");
                    if (!Stream.of(levelValues).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.toList()).contains(cmdPriority)) {
                        log.info(() -> {
                            String msg = String.format("Not permitted at priority %s as it's not in tag %s for point", cmdPriority, "nc:writableLevels");
                            return String.format(MSG_TEMPLATE, msg, pointId, "aborting", messageId);
                        });
                        return false;
                    }
                    if (duration == null || duration.getMillis() <= 0L) {
                        cmdDuration = this.getDefaultDuration();
                        log.info(() -> {
                            String msg = String.format("Duration was not provided or invalid, using default duration %s for point", cmdDuration);
                            return String.format(MSG_TEMPLATE, msg, pointId, "for", messageId);
                        });
                    } else {
                        cmdDuration = duration;
                    }
                    result = true;
                    writeInfo = new BCloudWriteInfo();
                    facets = point.getFacets();
                    if (!(objValue instanceof Number)) break block47;
                    double dval = ((Number)objValue).doubleValue();
                    if (!this.checkValueAgainstMinMaxFacets(dval, facets)) {
                        log.info(() -> String.format("Write value %s rejected as outside allowed facets range for point %s", dval, point.getSlotPath()));
                        return false;
                    }
                    writeInfo.setValue((BValue)BDouble.make((double)dval));
                    break block46;
                }
                if (!(objValue instanceof String)) break block48;
                if (point instanceof BEnumPoint) {
                    Double numVal = null;
                    try {
                        numVal = Double.parseDouble((String)objValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (numVal != null) {
                        if (!this.checkValueAgainstMinMaxFacets(numVal, facets)) {
                            Double finalNumVal = numVal;
                            log.info(() -> String.format("Write value %s rejected as outside allowed facets range for point %s", finalNumVal, point.getSlotPath()));
                            return false;
                        }
                        writeInfo.setValue((BValue)BDouble.make((double)numVal));
                        break block46;
                    } else {
                        try {
                            int ival = ((BEnumPoint)point).getEnum().getRange().get((String)objValue).getOrdinal();
                            if (!this.checkValueAgainstMinMaxFacets(ival, facets)) {
                                log.info(() -> String.format("Write value %s rejected as outside allowed facets range for point %s", ival, point.getSlotPath()));
                                return false;
                            }
                            writeInfo.setValue((BValue)BDouble.make((double)ival));
                        }
                        catch (InvalidEnumException ex) {
                            writeInfo.setValue((BValue)BString.make((String)((String)objValue)));
                            log.log(Level.CONFIG, String.format(MSG_TEMPLATE, "Unable to convert string to enum for point", pointId, "for", messageId), log.isLoggable(Level.FINE) ? ex.getMessage() : null);
                            return false;
                        }
                    }
                } else if (point instanceof BNumericPoint) {
                    try {
                        double dval = Double.parseDouble((String)objValue);
                        if (!this.checkValueAgainstMinMaxFacets(dval, facets)) {
                            log.info(() -> String.format("Write value %s rejected as outside allowed facets range for point %s", dval, point.getSlotPath()));
                            return false;
                        }
                        writeInfo.setValue((BValue)BDouble.make((double)dval));
                    }
                    catch (NumberFormatException e) {
                        log.log(Level.CONFIG, String.format(MSG_TEMPLATE, "Unable to convert string to number for point", pointId, "for", messageId), log.isLoggable(Level.FINE) ? e.getMessage() : null);
                        return false;
                    }
                } else {
                    String sval = (String)objValue;
                    if (!this.checkValueAgainstMinMaxFacets(sval.length(), facets)) {
                        log.info(() -> String.format("Write value %s rejected as outside allowed facets range for point %s", sval, point.getSlotPath()));
                        return false;
                    }
                    writeInfo.setValue((BValue)BString.make((String)sval));
                }
                break block46;
            }
            if (objValue instanceof Boolean) {
                writeInfo.setValue((BValue)BBoolean.make((boolean)((Boolean)objValue)));
            } else if (objValue instanceof BValue) {
                writeInfo.setValue((BValue)objValue);
            } else {
                String sval = objValue.toString();
                if (!this.checkValueAgainstMinMaxFacets(sval.length(), facets)) {
                    log.info(() -> String.format("Write value %s rejected as outside allowed facets range for point %s", sval, point.getSlotPath()));
                    return false;
                }
                writeInfo.setValue((BValue)BString.make((String)sval));
            }
        }
        writeInfo.setSource(source);
        writeInfo.setExpiration(BAbsTime.now().add(cmdDuration));
        String targetName = BWritePointCommand.getTargetName(cmdPriority);
        Type writeType = writeInfo.getValue().getType();
        Type targetType = point instanceof BIWritablePoint ? point.getProperty(targetName).getType() : point.getOutProperty().getType();
        Registry registry = Sys.getRegistry();
        TypeInfo[] adapters = registry.getAdapters(writeType.getTypeInfo(), targetType.getTypeInfo());
        BConverter converter = null;
        for (int i = adapters.length - 1; i >= 0; --i) {
            if (!registry.isAgent(adapters[i], BConversionLink.TYPE.getTypeInfo())) continue;
            converter = (BConverter)adapters[i].getInstance();
            break;
        }
        if (Integer.parseInt(cmdPriority) == 8) {
            BValue writeValue = writeInfo.getValue();
            BValue convertedObject = converter != null ? converter.convert((BObject)writeInfo.getValue().asValue(), targetType.getInstance()) : writeValue;
            BValue bValue = ((BIStatusValue)convertedObject).getStatusValue().getValueValue();
            BOverride override = this.makeOverride(point, (BObject)bValue);
            String actionName = OVERRIDE_ACTION;
            if (point instanceof BBooleanPoint) {
                actionName = ((BBooleanOverride)override).getValue() ? ACTIVE_ACTION : INACTIVE_ACTION;
            }
            Action action = point.getAction(actionName);
            override.setDuration(cmdDuration);
            try {
                point.invoke(action, (BValue)override, cx);
                actionLog.config(() -> String.format("Message id %s: point id %s override set to %s by %s", messageId, pointId, writeInfo.getValue().toString(), cx.getUser().getUsername()));
                return result;
            }
            catch (ActionInvokeException | LocalizableRuntimeException exception) {
                log.fine(() -> BWritePointCommand.lambda$writePoint$17((BajaRuntimeException)exception, pointId, messageId));
                return false;
            }
        }
        String name = BWritePointCommand.getCloudWriteNameForTarget(targetName);
        Property property = point.getProperty(name);
        if (property == null) {
            point.add(name, (BValue)writeInfo, 3);
        } else {
            point.set(property, (BValue)writeInfo);
        }
        if (converter != null) {
            BConversionLink bConversionLink = new BConversionLink(writeInfo.getHandleOrd(), "value", targetName, true, converter);
        } else {
            BLink bLink = new BLink(writeInfo.getHandleOrd(), "value", targetName, true);
        }
        point.add("writeLink" + BWritePointCommand.capitalize(targetName), (BValue)var25_42, 2);
        actionLog.config(() -> String.format("WritePointCommand message id %s: point id %s is being set to %s at %s by %s", messageId, pointId, writeInfo.getValue().toString(), targetName, cx.getUser().getUsername()));
        if (cmdDuration.getMillis() <= 0L) return result;
        writeInfo.makeTicket();
        return result;
    }

    protected BOverride makeOverride(BControlPoint point, BObject writeValue) {
        if (point instanceof BNumericPoint) {
            if (writeValue instanceof BNumber) {
                return new BNumericOverride(((BNumber)writeValue).getDouble());
            }
            return new BNumericOverride(BDouble.make((String)writeValue.toString()).getDouble());
        }
        if (point instanceof BBooleanPoint) {
            return new BBooleanOverride(BBoolean.decode((String)writeValue.toString()));
        }
        if (point instanceof BEnumPoint) {
            BEnumOverride override = new BEnumOverride();
            if (writeValue instanceof BDynamicEnum) {
                override.setValue((BDynamicEnum)writeValue);
                return override;
            }
            throw new IllegalArgumentException("Cannot parse enum from value " + writeValue.toString());
        }
        return new BStringOverride(writeValue.toString());
    }

    private boolean checkValueAgainstMinMaxFacets(double dval, BFacets facets) {
        return this.getAcceptWritesOutsideFacetsRange() || !(dval > facets.getd("max", Double.MAX_VALUE)) && !(dval < facets.getd("min", -1.7976931348623157E308));
    }

    private boolean checkValueAgainstMinMaxFacets(int ival, BFacets facets) {
        return this.getAcceptWritesOutsideFacetsRange() || ival <= facets.geti("max", Integer.MAX_VALUE) && ival >= facets.geti("min", Integer.MIN_VALUE);
    }

    private static String capitalize(String name) {
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private static String getTargetName(String priority) {
        return "in" + priority;
    }

    private static String getCloudWriteNameForTarget(String targetName) {
        return "cloudWrite" + BWritePointCommand.capitalize(targetName);
    }

    public static String getCloudWriteNameForPriority(String priority) {
        return BWritePointCommand.getCloudWriteNameForTarget(BWritePointCommand.getTargetName(priority));
    }

    private static /* synthetic */ String lambda$writePoint$17(BajaRuntimeException exception, String pointId, String messageId) {
        return String.format(MSG_TEMPLATE, "Override action failed: " + exception.getMessage(), pointId, "aborting", messageId);
    }
}

