/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.command.BCommand;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BReadPointCommand
extends BCommand {
    public static final Type TYPE = Sys.loadType(BReadPointCommand.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected StatusWrapper readPoint(String messageId, String pointId, Context cx) {
        BControlPoint point = CloudLinkUtils.findPoint(messageId, pointId);
        if (point == null) {
            return null;
        }
        if (!this.isLicensed(point)) {
            liclog.warning(() -> String.format("ReadPointCommand: point %s not licensed", pointId));
            return null;
        }
        if (CloudLinkUtils.isPointReadAllowed(point, cx)) {
            return new StatusWrapper(point.getStatusValue(), (BInteger)point.getFacets().get("precision"));
        }
        return null;
    }

    public static class StatusWrapper {
        private final BStatusValue value;
        private final BInteger precision;

        public StatusWrapper(BStatusValue value, BInteger precision) {
            this.value = value;
            this.precision = precision != null ? precision : BInteger.DEFAULT;
        }

        public BStatusValue getValue() {
            return this.value;
        }

        public BInteger getPrecision() {
            return this.precision;
        }
    }
}

