/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.command.BBaseTagCommand;
import java.util.Optional;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;

@NiagaraType
public class BDeleteTagCommand
extends BBaseTagCommand {
    public static final Type TYPE = Sys.loadType(BDeleteTagCommand.class);
    public static final String MSG_TEMPLATE = "DeleteTagCommand: %s [cloud id %s], %s command [msg id %s]";

    @Override
    public Type getType() {
        return TYPE;
    }

    protected boolean deleteTag(String messageId, String cloudId, String namespace, String tag, Context cx) {
        BIObject entity = CloudLinkUtils.findEntity(messageId, cloudId);
        if (!(entity instanceof Entity) || !BDeleteTagCommand.isWriteAllowed(entity, cx)) {
            log.info(() -> String.format(MSG_TEMPLATE, "Insufficient permissions for entity", cloudId, "aborting", messageId));
            return false;
        }
        if (this.excludedNamespaceSet.contains(namespace)) {
            log.info(() -> String.format(MSG_TEMPLATE, "Delete of tags contained in " + namespace + " are not allowed.", cloudId, "aborting", messageId));
            return false;
        }
        BTagDictionaryService dictionaryService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
        Optional optDictionary = dictionaryService.getTagDictionary(namespace);
        if (!optDictionary.isPresent()) {
            log.info(() -> String.format(MSG_TEMPLATE, "Unable to locate tag dictionary with namespace " + namespace, cloudId, "aborting", messageId));
            return false;
        }
        BTagDictionary dictionary = (BTagDictionary)optDictionary.get();
        Id tagId = Id.newId((String)namespace, (String)tag);
        Optional optTagInfo = dictionary.getTagDefinitions().getTag(tagId);
        if (!optTagInfo.isPresent()) {
            log.info(() -> String.format(MSG_TEMPLATE, "Unable to locate tag with name " + tag + " in namespace " + namespace, cloudId, "aborting", messageId));
            return false;
        }
        return TagUtil.deleteTag((BIEntity)((BIEntity)entity), (Id)tagId);
    }
}

