/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import com.tridium.cloudLink.command.BCommand;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="excludedTagDictionaries", type="BString", defaultValue="nc")
public class BBaseTagCommand
extends BCommand {
    public static final Property excludedTagDictionaries = BBaseTagCommand.newProperty((int)0, (String)"nc", null);
    public static final Type TYPE = Sys.loadType(BBaseTagCommand.class);
    protected Set<String> excludedNamespaceSet;

    public String getExcludedTagDictionaries() {
        return this.getString(excludedTagDictionaries);
    }

    public void setExcludedTagDictionaries(String v) {
        this.setString(excludedTagDictionaries, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        this.fwChanged(excludedTagDictionaries);
    }

    private void fwChanged(Property property) {
        if (property.equals(excludedTagDictionaries)) {
            String excludedDictionaries = this.getExcludedTagDictionaries();
            if (excludedDictionaries.isEmpty()) {
                this.setExcludedTagDictionaries("nc");
                log.info("Adding Niagara Cloud tag dictionary to excluded tag dictionaries for write tag command");
            } else {
                String[] namespaces = excludedDictionaries.split(",");
                if (Arrays.stream(namespaces).map(String::trim).anyMatch("nc"::equals)) {
                    this.excludedNamespaceSet = Arrays.stream(namespaces).map(String::trim).filter(n -> !n.isEmpty()).collect(Collectors.toSet());
                } else {
                    this.setExcludedTagDictionaries("nc," + excludedDictionaries);
                    log.info("Adding Niagara Cloud tag dictionary to excluded tag dictionaries for write tag command");
                }
            }
        }
    }

    protected static boolean isWriteAllowed(BIObject entity, Context cx) {
        if (entity instanceof BComponent) {
            return ((BComponent)entity).getPermissions(cx).hasAdminWrite();
        }
        return false;
    }
}

