/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.authn.BAuthenticationService;
import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.command.BCommandContainer;
import com.tridium.cloudLink.command.BCommandStatus;
import com.tridium.cloudLink.command.BNullCommandContainer;
import com.tridium.cloudLink.command.CommandRequest;
import com.tridium.cloudLink.msg.IRegisterCommandsHandler;
import com.tridium.cloudLink.queue.BAbstractCommandQueue;
import com.tridium.cloudLink.queue.BInMemoryCommandQueue;
import com.tridium.cloudLink.security.BCloudAuthenticationScheme;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.MessageWrapper;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ExecutorUtil;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="channelType", type="BString", defaultValue="BString.make(CLOUD_LINK_CHANNEL_COMMAND)", flags=1, override=true), @NiagaraProperty(name="commands", type="BCommandContainer", defaultValue="new BNullCommandContainer()"), @NiagaraProperty(name="commandTimeout", type="BRelTime", defaultValue="BRelTime.makeMinutes(1)"), @NiagaraProperty(name="defaultCommandQueue", type="BAbstractCommandQueue", defaultValue="new BInMemoryCommandQueue()")})
public class BCommandsChannel
extends BAbstractClientChannel {
    public static final Property channelType = BCommandsChannel.newProperty((int)1, (BValue)BString.make((String)"Command"), null);
    public static final Property commands = BCommandsChannel.newProperty((int)0, (BValue)new BNullCommandContainer(), null);
    public static final Property commandTimeout = BCommandsChannel.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)1), null);
    public static final Property defaultCommandQueue = BCommandsChannel.newProperty((int)0, (BValue)new BInMemoryCommandQueue(), null);
    public static final Type TYPE = Sys.loadType(BCommandsChannel.class);
    private boolean commandsRegistered;
    private ExecutorService executor;
    private ExecutorService manager;
    private BAbstractCommandQueue[] orderedQueues;
    private static final Logger log = Logger.getLogger("cloudLink.channel.command");
    private static final String COMMAND_ERROR = "Command channel configuration";

    public BCommandContainer getCommands() {
        return (BCommandContainer)this.get(commands);
    }

    public void setCommands(BCommandContainer v) {
        this.set(commands, (BValue)v, null);
    }

    public BRelTime getCommandTimeout() {
        return (BRelTime)this.get(commandTimeout);
    }

    public void setCommandTimeout(BRelTime v) {
        this.set(commandTimeout, (BValue)v, null);
    }

    public BAbstractCommandQueue getDefaultCommandQueue() {
        return (BAbstractCommandQueue)this.get(defaultCommandQueue);
    }

    public void setDefaultCommandQueue(BAbstractCommandQueue v) {
        this.set(defaultCommandQueue, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    protected final void channelStarted() {
        if (this.getConnectionService().map(BAbstractService::isFatalFault).orElse(true).booleanValue()) {
            return;
        }
        BCommandsChannel.ensureCommandAuthenticationInfrastructure();
        this.updatePriorityQueues();
        this.manager = ExecutorUtil.newSingleThreadBackgroundExecutor((String)"cloudLink.commandManager", (long)1L, (TimeUnit)TimeUnit.MINUTES);
        this.executor = ExecutorUtil.newSingleThreadBackgroundExecutor((String)"cloudLink.commandExecutor", (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    @Override
    protected void fwStopped() {
        super.fwStopped();
        if (this.manager != null) {
            this.manager.shutdown();
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public void changed(Property prop, Context context) {
        this.handleChange(prop);
    }

    public void added(Property prop, Context context) {
        this.handleChange(prop);
    }

    public void removed(Property prop, BValue oldValue, Context context) {
        this.handleChange(prop);
    }

    @Override
    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("CommandsChannel.icon"));
    }

    private void handleChange(Property prop) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.isDynamic() && prop.getType().is(BAbstractCommandQueue.TYPE)) {
            this.updatePriorityQueues();
        }
    }

    private static void ensureCommandAuthenticationInfrastructure() {
        BAuthenticationService authService = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE).as(BAuthenticationService.class);
        BAuthenticationScheme[] schemes = (BAuthenticationScheme[])authService.getAuthenticationSchemes().getChildren(BCloudAuthenticationScheme.class);
        if (schemes.length == 0) {
            authService.getAuthenticationSchemes().add("cloudAuthenticationScheme", (BValue)new BCloudAuthenticationScheme());
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        if (this.getConnectionService().map(ccs -> ccs.isFatalFault()).orElse(true).booleanValue()) {
            return;
        }
        this.getCommands().setupRoutes();
        this.getConnectionService().ifPresent(ccs -> ccs.registerForConnectionServiceReady(() -> this.registerCommands()));
    }

    public void updatePriorityQueues() {
        this.orderedQueues = (BAbstractCommandQueue[])this.getChildren(BAbstractCommandQueue.class);
        Arrays.sort(this.orderedQueues, Comparator.comparingInt(BAbstractCommandQueue::getPriority));
    }

    public Future<?> enqueue(CommandRequest request) {
        int priority = request.getPriority();
        BAbstractCommandQueue targetQueue = null;
        for (int lcv = this.orderedQueues.length - 1; lcv >= 0; --lcv) {
            if (this.orderedQueues[lcv].getPriority() > priority) continue;
            targetQueue = this.orderedQueues[lcv];
            break;
        }
        if (targetQueue == null && this.orderedQueues.length > 0) {
            targetQueue = this.orderedQueues[0];
        }
        if (targetQueue == null || !targetQueue.enqueue(request)) {
            this.getCommands().sendEnqueueResponse(request, 140);
            log.warning(() -> String.format("Unable to enqueue command: commandName=[%s], priority=[%d], commandId=[%s]", request.getCommand().getName(), priority, request.getCommandId()));
            CompletableFuture result = new CompletableFuture();
            result.completeExceptionally(new Exception("Unable to enqueue command, queue unavailable. " + request.getCommandId()));
            return result;
        }
        log.finer(String.format("CommandChannel enqueued command: commandId=[%s], priority=[%d]", request.getCommandId(), targetQueue.getPriority()));
        if (!request.getSuppressStatusResponse()) {
            log.finer(() -> String.format("CommandChannel sending enqueued response for command: commandId=[%s], timestamp=[%d]", request.getCommandId(), BAbsTime.now().getMillis()));
            this.getCommands().sendEnqueueResponse(request, 100);
        }
        log.finer(() -> String.format("CommandChannel enqueue notifying manager: commandId=[%s]", request.getCommandId()));
        Future<?> task = this.manager.submit(this::executeCommand);
        log.finer(() -> String.format("CommandChannel enqueue exiting: commandId=[%s]", request.getCommandId()));
        return task;
    }

    public boolean isCommandsRegistered() {
        return this.commandsRegistered;
    }

    private void executeCommand() {
        CommandRequest req = null;
        BAbstractCommandQueue comQ = null;
        for (BAbstractCommandQueue queue : this.orderedQueues) {
            req = queue.getNextToExecute();
            if (req == null) continue;
            comQ = queue;
            break;
        }
        if (req == null) {
            log.info("executeCommand was invoked but no pending commands were found.");
            return;
        }
        CommandRequest request = req;
        BAbstractCommandQueue commandQueue = comQ;
        log.finer(() -> String.format("CommandChannel executing command: commandId=[%s], priority=[%d]", request.getCommandId(), commandQueue.getPriority()));
        this.getConnectionService().ifPresent(ccs -> ccs.getCloudAuditHistorySource().audit(request));
        Future<?> future = this.executor.submit(request::execute);
        request.setStatus(BCommandStatus.Executing);
        CompletableFuture<Boolean> responseFuture = null;
        try {
            log.finer(() -> String.format("CommandExecutor waiting for command to finish: commandId=[%s]", request.getCommandId()));
            future.get(this.getCommandTimeout().getMillis(), TimeUnit.MILLISECONDS);
            log.finer(() -> String.format("CommandExecutor command finished: commandId=[%s]", request.getCommandId()));
            if (!request.getSuppressStatusResponse()) {
                responseFuture = this.getCommands().sendStatusEvent(request, 110);
            }
        }
        catch (TimeoutException ex) {
            log.info(() -> String.format("Cloud command timeout occurred: commandId=[%s]", request.getCommandId()));
            future.cancel(true);
            responseFuture = this.getCommands().sendStatusEvent(request, 130);
        }
        catch (InterruptedException ex) {
            log.warning(() -> String.format("Cloud command control thread interrupted while command was executing: commandId=[%s]", request.getCommandId()));
            future.cancel(true);
            responseFuture = this.getCommands().sendStatusEvent(request, 140);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            log.log(Level.WARNING, String.format("Cloud command threw an exception: commandId=[%s], messageId=[%s], exception=[%s]", request.getCommandId(), request.getMessageId(), ex), log.isLoggable(Level.FINE) ? ex : null);
            responseFuture = this.getCommands().sendStatusEvent(request, 120);
        }
        request.setStatus(BCommandStatus.Done);
        if (responseFuture != null) {
            responseFuture.whenComplete((resp, err) -> {
                if (err != null) {
                    log.warning(() -> "Failed to send command completion message: commandId=[" + request.getCommandId() + ']');
                } else {
                    if (!commandQueue.dequeue(request)) {
                        log.info(() -> "Unable to find command request in expected queue: commandId=[" + request.getCommandId() + ']');
                    }
                    log.fine(() -> String.format("Command completion message sent successfully: commandId=[%s], timestamp=[%d]", request.getCommandId(), BAbsTime.now().getMillis()));
                }
            });
        } else {
            commandQueue.dequeue(request);
            log.finer(() -> "CommandExecutor command dequeued: commandId=[" + request.getCommandId() + ']');
        }
        log.finer(() -> String.format("CommandExecutor executeCommand exiting: commandId=[%s]", request.getCommandId()));
    }

    public void registerCommands() {
        Set<String> commands = this.getCommands().getCommandIds();
        if (commands.isEmpty()) {
            log.config("no commands found to register");
            return;
        }
        Optional<String> errMsg = this.checkChannelConfig();
        if (errMsg.isPresent()) {
            log.info("unable to register commands: " + errMsg.get());
            return;
        }
        BAbstractTransport transport = this.getChannelConfig().getTransport(IRegisterCommandsHandler.getOperationId());
        BAbstractCloudLinkHandlerFactory msgFactory = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service.")).getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        IRegisterCommandsHandler commandHandler = msgFactory.getMessageHandler(IRegisterCommandsHandler.class, this.getChannelConfig());
        for (String command : commands) {
            commandHandler.add(command);
        }
        CompletableFuture future = new CompletableFuture();
        future.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.INFO, "unable to register commands: ", log.isLoggable(Level.FINE) ? err : null);
            } else {
                this.commandsRegistered = resp;
            }
        });
        MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(commandHandler.toMessage(true), commandHandler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            this.getChannelConfig().enqueueMessage(IRegisterCommandsHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
    }

    private Optional<String> checkChannelConfig() {
        StringBuilder err = this.checkChannelConfigCommon(COMMAND_ERROR);
        return err.length() > 0 ? Optional.of(err.substring(0, err.length() - 1)) : Optional.empty();
    }
}

