/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.alarm.AlarmCountEvent;
import com.tridium.cloudLink.alarm.AlarmCounter;
import com.tridium.cloudLink.alarm.BCloudLinkAlarmRecipient;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.channel.BICountingAlarmChannelConfig;
import com.tridium.cloudLink.msg.ISendAlarmHandler;
import com.tridium.cloudLink.msg.ISendBatchAlarmHandler;
import com.tridium.cloudLink.msg.ISendEventHandler;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IConnectionCallback;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.MessageWrapper;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="channelType", type="BString", defaultValue="BString.make(CLOUD_LINK_CHANNEL_ALARM)", flags=1, override=true)
public class BAlarmsChannel
extends BAbstractClientChannel
implements IConnectionCallback {
    public static final Property channelType = BAlarmsChannel.newProperty((int)1, (BValue)BString.make((String)"Alarm"), null);
    public static final Type TYPE = Sys.loadType(BAlarmsChannel.class);
    private final AlarmCounter alarmCounter = new AlarmCounter();
    private static final String SEND_ALARM_ERROR = "Could not send alarm";
    private static final Logger log = Logger.getLogger("cloudLink.channel.alarm");

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("AlarmsChannel.icon"));
    }

    @Override
    protected final void channelStarted() {
        if (this.getConnectionService().map(BAbstractService::isFatalFault).orElse(true).booleanValue()) {
            return;
        }
        this.ensureAlarmRecipient();
    }

    @Override
    protected void fwDescendantsStarted() {
        super.fwDescendantsStarted();
        this.getConnectionService().ifPresent(ccs -> {
            if (!ccs.isFatalFault()) {
                ccs.registerForConnectionServiceReady(() -> this.registerCallbacks());
            }
        });
    }

    private void ensureAlarmRecipient() {
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE).as(BAlarmService.class);
        BCloudConnectionService ccs = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service."));
        if (Arrays.stream(alarmService.getChildren(BCloudLinkAlarmRecipient.class)).noneMatch(recipient -> {
            try {
                return recipient.getCloudConnectionService().get() == ccs;
            }
            catch (UnresolvedException ex) {
                log.info(() -> "Unable to resolve cloudConnectionService for " + recipient.getName());
                return false;
            }
        })) {
            BCloudLinkAlarmRecipient recipient2 = new BCloudLinkAlarmRecipient();
            recipient2.setCloudConnectionService(ccs.getOrdInSession());
            alarmService.add(lex.get("alarms.recipient.name") + '?', (BValue)recipient2);
        }
    }

    private void registerCallbacks() {
        BAbstractTransport transport = this.getChannelConfig().getTransport(ISendAlarmHandler.getOperationId());
        if (transport instanceof BAbstractConnectedTransport) {
            BAbstractConnectedTransport connectedTransport = (BAbstractConnectedTransport)transport;
            connectedTransport.addConnectionCallback(this);
        } else {
            BAlarmsChannel.handleAlarms();
        }
    }

    public List<CompletableFuture<Boolean>> sendBatchAlarms(BAlarmRecord[] alarms) {
        Optional<String> errMsg = this.checkChannelConfig();
        ArrayList<CompletableFuture<Boolean>> rv = new ArrayList<CompletableFuture<Boolean>>();
        if (errMsg.isPresent()) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new IllegalStateException(errMsg.get()));
            rv.add(future);
            return rv;
        }
        BChannelConfig config = this.getChannelConfig();
        BAbstractTransport transport = config.getTransport(ISendBatchAlarmHandler.getOperationId());
        if (!transport.canSend()) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new IllegalStateException("Transport is unable to send any messages"));
            rv.add(future);
            return rv;
        }
        BAbstractCloudLinkHandlerFactory msgFactory = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service.")).getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        ISendBatchAlarmHandler alarmHandler = msgFactory.getMessageHandler(ISendBatchAlarmHandler.class, config);
        for (BAlarmRecord alarm : alarms) {
            if (alarmHandler.add(alarm) < config.getMaxMessageSize(ISendBatchAlarmHandler.getOperationId())) continue;
            rv.add(this.sendMessage(alarmHandler, transport, false));
        }
        if (alarmHandler.hasData()) {
            rv.add(this.sendMessage(alarmHandler, transport, true));
        }
        this.handleAlarmCounts(config, msgFactory, transport);
        return rv;
    }

    public CompletableFuture<Boolean> sendAlarm(BAlarmRecord alarm) {
        Optional<String> errMsg = this.checkChannelConfig();
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        if (errMsg.isPresent()) {
            future.completeExceptionally(new IllegalStateException(errMsg.get()));
            return future;
        }
        BChannelConfig config = this.getChannelConfig();
        BAbstractTransport transport = config.getTransport(ISendAlarmHandler.getOperationId());
        if (!transport.canSend()) {
            future.completeExceptionally(new IllegalStateException("Transport is unable to send any messages"));
            return future;
        }
        BAbstractCloudLinkHandlerFactory msgFactory = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service.")).getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        ISendAlarmHandler alarmHandler = msgFactory.getMessageHandler(ISendAlarmHandler.class, config);
        alarmHandler.add(alarm);
        MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(alarmHandler.toMessage(), alarmHandler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            this.getChannelConfig().enqueueMessage(ISendAlarmHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        this.handleAlarmCounts(config, msgFactory, transport);
        return future;
    }

    public boolean canSend() {
        Optional<String> errMsg = this.checkChannelConfig();
        BAbstractTransport transport = this.getChannelConfig().getTransport(ISendAlarmHandler.getOperationId());
        if (errMsg.isPresent() || !transport.isOperational()) {
            return false;
        }
        if (transport instanceof BAbstractConnectedTransport) {
            return ((BAbstractConnectedTransport)transport).isConnected();
        }
        return true;
    }

    private CompletableFuture<Boolean> sendMessage(ISendBatchAlarmHandler alarmHandler, BAbstractTransport transport, boolean isFinal) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(alarmHandler.toMessage(isFinal), alarmHandler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            this.getChannelConfig().enqueueMessage(ISendBatchAlarmHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return future;
    }

    private CompletableFuture<Boolean> handleAlarmCounts(BChannelConfig config, BAbstractCloudLinkHandlerFactory msgFactory, BAbstractTransport transport) {
        BICountingAlarmChannelConfig countingConfig;
        if (config instanceof BICountingAlarmChannelConfig && (countingConfig = (BICountingAlarmChannelConfig)((Object)config)).getLastAlarmCountTimestamp().add(countingConfig.getAlarmCountPeriod()).isBefore(BAbsTime.now())) {
            AlarmCountEvent alarmCountEvent = this.alarmCounter.countAlarms();
            ISendEventHandler eventHandler = msgFactory.getMessageHandler(ISendEventHandler.class, config);
            eventHandler.add(alarmCountEvent);
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(eventHandler.toMessage(), eventHandler.getFuture(future), transport.getMessageRetries());
            AccessController.doPrivileged(() -> {
                config.enqueueMessage(ISendEventHandler.getOperationId(), wrapper);
                return null;
            });
            transport.notifyPending();
            countingConfig.setLastAlarmCountTimestamp(BAbsTime.now());
            return future;
        }
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public void onConnect() {
        BAlarmsChannel.handleAlarms();
    }

    @Override
    public void onDisconnect() {
    }

    private static void handleAlarms() {
        log.fine("Handling pending alarms....");
        BAbsTime currentTime = BAbsTime.now();
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        try (AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);){
            BCloudLinkAlarmRecipient[] cloudAlarmRecipients = (BCloudLinkAlarmRecipient[])alarmService.getChildren(BCloudLinkAlarmRecipient.class);
            HashMap alarmClassMap = new HashMap();
            for (BCloudLinkAlarmRecipient cloudAlarmRecipient : cloudAlarmRecipients) {
                ArrayList<String> alarmClassList = new ArrayList<String>();
                for (BLink link : cloudAlarmRecipient.getLinks()) {
                    if (!(link.getSourceComponent() instanceof BAlarmClass)) continue;
                    alarmClassList.add(link.getSourceComponent().getName());
                }
                alarmClassMap.put(cloudAlarmRecipient, alarmClassList);
            }
            for (Map.Entry entry : alarmClassMap.entrySet()) {
                Cursor alarms = conn.timeQuery(((BCloudLinkAlarmRecipient)((Object)entry.getKey())).getLastSentToCloud().add(BRelTime.make((long)1L)), currentTime);
                while (alarms.next()) {
                    BAlarmRecord record = (BAlarmRecord)((BAlarmRecord)alarms.get()).newCopy();
                    if (!((List)entry.getValue()).contains(record.getAlarmClass())) continue;
                    ((BCloudLinkAlarmRecipient)((Object)entry.getKey())).handleAlarm(record);
                }
            }
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "Not able to send alarms on connect", log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    private Optional<String> checkChannelConfig() {
        StringBuilder err = this.checkChannelConfigCommon(SEND_ALARM_ERROR);
        return err.length() > 0 ? Optional.of(err.substring(0, err.length() - 1)) : Optional.empty();
    }
}

