/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.channel.BClientChannelsFolder;
import com.tridium.cloudLink.channel.BNullChannelConfig;
import java.util.Optional;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="channelType", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="channelConfig", type="BChannelConfig", defaultValue="new BNullChannelConfig()")})
public abstract class BAbstractClientChannel
extends BAbstractService
implements BIRestrictedComponent {
    public static final Property channelType = BAbstractClientChannel.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Property channelConfig = BAbstractClientChannel.newProperty((int)0, (BValue)new BNullChannelConfig(), null);
    public static final Type TYPE = Sys.loadType(BAbstractClientChannel.class);
    private static final Logger log = Logger.getLogger("cloudLink.channel.base");
    protected static final Lexicon lex = Lexicon.make((String)"cloudLink");
    private static final String CHANNEL_DISABLED = "Channel disabled";
    private static final String CHANNEL_FAULT = "Channel in fault";
    private int oldStatus = 0;
    private boolean fatalFault;
    private boolean configFault;
    protected boolean doLogDisabledInfo = true;
    protected boolean doLogFaultInfo = true;
    protected BCloudConnectionService cloudConnectionService;

    public String getChannelType() {
        return this.getString(channelType);
    }

    public void setChannelType(String v) {
        this.setString(channelType, v, null);
    }

    public BChannelConfig getChannelConfig() {
        return (BChannelConfig)this.get(channelConfig);
    }

    public void setChannelConfig(BChannelConfig v) {
        this.set(channelConfig, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 15: {
                this.fwServiceStarted();
                break;
            }
            case 13: {
                this.fwDescendantsStarted();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
                break;
            }
            case 12: {
                this.fwStopped();
                break;
            }
            case 16: {
                this.fwServiceStopped();
                break;
            }
            case 14: {
                this.fwDescendantsStopped();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    protected void fwStarted() {
        this.checkConfigMigration();
        this.initializeChannelConfig();
        this.channelStarted();
    }

    protected void fwServiceStarted() {
    }

    protected void fwDescendantsStarted() {
    }

    protected void fwChanged(Property prop) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(channelType)) {
            this.updateChannelConfig();
        }
        this.channelChanged(prop);
    }

    protected void fwStopped() {
        this.cloudConnectionService = null;
    }

    protected void fwServiceStopped() {
    }

    protected void fwDescendantsStopped() {
    }

    protected void channelStarted() {
    }

    protected void channelChanged(Property prop) {
    }

    private void checkConfigMigration() {
        BChannelConfig migrateTo = this.getChannelConfig().checkMigration();
        if (!this.getChannelConfig().equals((Object)migrateTo)) {
            log.fine(() -> String.format("Migrating channel %s config from %s to %s", new Object[]{this.getName(), this.getChannelConfig(), migrateTo}));
            this.setChannelConfig(migrateTo);
        }
    }

    protected void initializeChannelConfig() {
        if (this.getChannelConfig() instanceof BNullChannelConfig) {
            this.getConnectionService().flatMap(srv -> srv.getChannelConfigFactory(this.getPlatformType())).ifPresent(fac -> this.setChannelConfig(fac.getChannelConfig(this.getChannelType())));
            this.clearConfigFault();
        }
        if (this.getChannelConfig() instanceof BNullChannelConfig) {
            this.setConfigFault(lex.get("channel.noConfig"));
        }
    }

    public void updateChannelConfig() {
        Optional newConfig = this.getConnectionService().flatMap(srv -> srv.getChannelConfigFactory(this.getPlatformType())).flatMap(fac -> Optional.of(fac.getChannelConfig(this.getChannelType())));
        newConfig.ifPresent(c -> {
            if (((Object)c).getClass() != ((Object)((Object)this.getChannelConfig())).getClass()) {
                this.setChannelConfig((BChannelConfig)((Object)c));
                if (c instanceof BNullChannelConfig) {
                    this.setConfigFault(lex.get("channel.noConfig"));
                } else {
                    this.clearConfigFault();
                }
            } else {
                log.config("new channel config is same type as old config, preserving settings.");
            }
        });
    }

    public final void updateStatus() {
        BStatus parentStatus;
        int newStatus = this.getStatus().getBits();
        Optional<BCloudConnectionService> cloudConnectionService = this.getConnectionService();
        BStatus bStatus = parentStatus = cloudConnectionService.isPresent() ? cloudConnectionService.get().getStatus() : BStatus.ok;
        newStatus = !this.getEnabled() || parentStatus.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = this.fatalFault || this.configFault || parentStatus.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (this.oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.propagateStatus();
        this.oldStatus = newStatus;
    }

    protected void propagateStatus() {
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        CloudLinkUtils.checkParentForDuplicates(parent, (BComponent)this, BClientChannelsFolder.TYPE, false, cx);
    }

    public Optional<BCloudConnectionService> getConnectionService() {
        if (this.cloudConnectionService == null) {
            BComplex parent;
            for (parent = this.getParent(); parent != null && !(parent instanceof BCloudConnectionService); parent = parent.getParent()) {
            }
            this.cloudConnectionService = (BCloudConnectionService)parent;
        }
        return Optional.ofNullable(this.cloudConnectionService);
    }

    protected StringBuilder checkChannelConfigCommon(String prefix) {
        StringBuilder err = new StringBuilder();
        this.validateChannelStatus(err, prefix);
        this.validateChannelFaults(err, prefix);
        BChannelConfig channelConfig = this.getChannelConfig();
        channelConfig.validateConfiguration(prefix, err);
        return err;
    }

    protected void validateChannelFaults(StringBuilder err, String prefix) {
        if (this.getStatus().isFault() || this.isFatalFault()) {
            if (this.doLogFaultInfo) {
                log.info(() -> String.format("%s: %s", prefix, CHANNEL_FAULT));
            }
            err.append(CHANNEL_FAULT).append(';');
            this.doLogFaultInfo = false;
        } else {
            this.doLogFaultInfo = true;
        }
    }

    private void validateChannelStatus(StringBuilder err, String prefix) {
        if (this.getStatus().isDisabled()) {
            if (this.doLogDisabledInfo) {
                log.info(() -> String.format("%s: %s", prefix, CHANNEL_DISABLED));
            }
            err.append(CHANNEL_DISABLED).append(';');
            this.doLogDisabledInfo = false;
        } else {
            this.doLogDisabledInfo = true;
        }
    }

    public String getPlatformType() {
        Optional<BCloudConnectionService> optCCS = this.getConnectionService();
        if (optCCS.isPresent()) {
            return optCCS.get().getPlatformType();
        }
        return "";
    }

    public final void setConfigFault(String faultCause) {
        this.configFault = true;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause(faultCause);
        this.updateStatus();
    }

    public final void setConfigFatal(String fatalCause) {
        this.fatalFault = true;
        this.setFaultCause(fatalCause);
        this.updateStatus();
    }

    public final void clearConfigFault() {
        this.configFault = false;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause("");
        this.updateStatus();
    }

    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("AbstractClientChannel.icon"));
    }
}

