/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.security.BCertificateAliasAndPassword;

public class FederatedIdentityCsrRequest
implements IMessageBuilder {
    private final String federatedIdentityHost;
    private final String deviceCode;
    private final NPKCS10CertificationRequest csr;
    private final BCertificateAliasAndPassword certAliasAndPass;
    private final boolean isRolling;
    private static final Logger log = Logger.getLogger("cloudLink.auth.federated");
    private static final String DEVICE_CODE = "deviceCode";
    private static final String CSR = "certificateSigningRequest";
    private static final String BOOTSTRAP_API_PATH = "/api/v1/certificate/bootstrap";
    private static final String BOOTSTRAP_RENEW_API_PATH = "/api/v1/certificate/bootstrap-renew";
    private static final String ROLLING_API_PATH = "/api/v1/certificate/rolling";

    protected FederatedIdentityCsrRequest(FederatedIdentityCsrRequestBuilder builder) {
        this.federatedIdentityHost = builder.server;
        this.csr = builder.request;
        this.deviceCode = builder.deviceCode;
        this.certAliasAndPass = builder.certAliasAndPass;
        this.isRolling = builder.isRolling;
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        URL url;
        StringWriter stringWriter = new StringWriter();
        JSONWriter jsonSerializer = QuickJSONWriter.make((Appendable)stringWriter);
        jsonSerializer.object();
        try {
            jsonSerializer.key(CSR).value((Object)this.csr.encodeToString());
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Unable to serialize csr request", log.isLoggable(Level.FINE) ? ex : null);
            return null;
        }
        jsonSerializer.endObject();
        stringWriter.flush();
        String apiPath = this.isRolling ? ROLLING_API_PATH : (this.deviceCode != null ? BOOTSTRAP_API_PATH : BOOTSTRAP_RENEW_API_PATH);
        String urlString = "https://" + this.federatedIdentityHost + apiPath;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for federated identity csr request url = [" + urlString + ']', log.isLoggable(Level.FINE) ? ex : null);
            return null;
        }
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending csr request message with correlation " + correlationId);
        HashMap<String, Object> requestHeaders = new HashMap<String, Object>();
        requestHeaders.put("x-activity-id", correlationId);
        if (!this.isRolling && this.deviceCode != null) {
            requestHeaders.put(DEVICE_CODE, this.deviceCode);
        }
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, url, requestHeaders).mimeType("application/json").certificateAliasAndPassword(this.certAliasAndPass).body(stringWriter.getBuffer().toString()).build();
    }

    public static class FederatedIdentityCsrRequestBuilder {
        private final String server;
        private final NPKCS10CertificationRequest request;
        private String deviceCode;
        private BCertificateAliasAndPassword certAliasAndPass;
        private boolean isRolling;

        public FederatedIdentityCsrRequestBuilder(String server, NPKCS10CertificationRequest request) {
            Objects.requireNonNull(server, "FederatedIdentityCsrRequest: server must not be null");
            Objects.requireNonNull(request, "FederatedIdentityCsrRequest: request must not be null");
            this.server = server;
            this.request = request;
        }

        public FederatedIdentityCsrRequestBuilder deviceCode(String deviceCode) {
            this.deviceCode = deviceCode;
            this.certAliasAndPass = null;
            this.isRolling = false;
            return this;
        }

        public FederatedIdentityCsrRequestBuilder certificateAliasAndPassword(BCertificateAliasAndPassword certAliasAndPass) {
            this.certAliasAndPass = certAliasAndPass;
            this.deviceCode = null;
            return this;
        }

        public FederatedIdentityCsrRequestBuilder isRolling(boolean isRolling) {
            this.isRolling = isRolling;
            return this;
        }

        public FederatedIdentityCsrRequest build() {
            return new FederatedIdentityCsrRequest(this);
        }
    }
}

