/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.nre.security.SecurityInitializer;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.util.function.Supplier;

public class EcdsaKeyPairGeneratorSupplier
implements Supplier<KeyPairGenerator> {
    public static final String EC_KEY_PAIR_ALGORITHM = "EC";
    protected static final String ECDSA_CURVE_SPEC = "P-256";

    @Override
    public KeyPairGenerator get() {
        try {
            Provider provider = SecurityInitializer.getInstance().getCryptoProvider().getProvider();
            KeyPairGenerator keyPairGen = this.makeKeyPairGenerator(EC_KEY_PAIR_ALGORITHM, provider);
            ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec(ECDSA_CURVE_SPEC);
            this.initializeKeyPairGenerator(keyPairGen, ecGenParameterSpec, this.makeSecureRandom());
            return keyPairGen;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected KeyPairGenerator makeKeyPairGenerator(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance(algorithm, provider);
    }

    protected void initializeKeyPairGenerator(KeyPairGenerator kpGen, ECGenParameterSpec spec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        kpGen.initialize(spec, secureRandom);
    }

    protected SecureRandom makeSecureRandom() {
        SecureRandom secureRandom;
        try {
            secureRandom = this.getStrongSecureRandom();
        }
        catch (NoSuchAlgorithmException e) {
            secureRandom = this.getSecureRandom();
        }
        return secureRandom;
    }

    protected SecureRandom getStrongSecureRandom() throws NoSuchAlgorithmException {
        return SecureRandom.getInstanceStrong();
    }

    protected SecureRandom getSecureRandom() {
        return new SecureRandom();
    }
}

