/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.auth.BClientAuthenticatorsFolder;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.util.IValueWrapper;
import java.util.Map;
import java.util.Optional;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="authenticatorId", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="systemId", type="BString", defaultValue="BString.DEFAULT", flags=257)})
public abstract class BAbstractClientAuthenticator
extends BAbstractService {
    public static final Property authenticatorId = BAbstractClientAuthenticator.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Property systemId = BAbstractClientAuthenticator.newProperty((int)257, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BAbstractClientAuthenticator.class);
    protected boolean configFault;
    private static final Lexicon lex = Lexicon.make((String)"cloudLink");
    private int oldStatus;

    public String getAuthenticatorId() {
        return this.getString(authenticatorId);
    }

    public void setAuthenticatorId(String v) {
        this.setString(authenticatorId, v, null);
    }

    public String getSystemId() {
        return this.getString(systemId);
    }

    public void setSystemId(String v) {
        this.setString(systemId, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public abstract void addMessageHandlerProperties(BAbstractTransport var1, String var2, Map<String, Object> var3);

    public abstract Map<String, Object> getPlatformProperties();

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BClientAuthenticatorsFolder;
    }

    public abstract boolean canAuthenticate();

    public abstract boolean isRegistered();

    public Map<String, IValueWrapper<?>> getConnectionInfo(String id) {
        throw new UnsupportedOperationException("Cannot get connection information");
    }

    public String getCertificate(String id) {
        throw new UnsupportedOperationException("Cannot get certificate");
    }

    public final void updateStatus() {
        int newStatus = this.getStatus().getBits();
        BStatus parentStatus = this.getConnectionService().map(ccs -> ccs.getStatus()).orElse(BStatus.ok);
        newStatus = !this.getEnabled() || parentStatus.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = this.isFatalFault() || this.configFault || parentStatus.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (this.oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
    }

    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("AbstractClientAuthenticator.icon"));
    }

    protected Optional<BCloudConnectionService> getConnectionService() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BCloudConnectionService)) continue;
            return Optional.of((BCloudConnectionService)parent);
        }
        return Optional.empty();
    }
}

