/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.alarm;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.channel.BAlarmsChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClassFolder;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="cloudConnectionService", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"baja:Component\")")}), @NiagaraProperty(name="enableBatchAlarms", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.TRUE_TEXT", value="\"%lexicon(cloudLink:alarms.batch.enabled)%\""), @Facet(name="BFacets.FALSE_TEXT", value="\"%lexicon(cloudLink:alarms.batch.disabled)%\"")}), @NiagaraProperty(name="alarmBatchDelay", type="BRelTime", defaultValue="BRelTime.make(30000)"), @NiagaraProperty(name="alarmBatchSize", type="int", defaultValue="100", facets={@Facet(name="BFacets.MIN", value="2"), @Facet(name="BFacets.MAX", value="512")}), @NiagaraProperty(name="sendFailWarnInterval", type="BRelTime", defaultValue="BRelTime.makeHours(1)", flags=5), @NiagaraProperty(name="lastSentToCloud", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=257)})
@NiagaraAction(name="sendBatchAlarms", flags=4)
public class BCloudLinkAlarmRecipient
extends BAlarmRecipient {
    public static final Property cloudConnectionService = BCloudLinkAlarmRecipient.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:Component")));
    public static final Property enableBatchAlarms = BCloudLinkAlarmRecipient.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"%lexicon(cloudLink:alarms.batch.enabled)%"), (BFacets)BFacets.make((String)"falseText", (String)"%lexicon(cloudLink:alarms.batch.disabled)%")));
    public static final Property alarmBatchDelay = BCloudLinkAlarmRecipient.newProperty((int)0, (BValue)BRelTime.make((long)30000L), null);
    public static final Property alarmBatchSize = BCloudLinkAlarmRecipient.newProperty((int)0, (int)100, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)2), (BFacets)BFacets.make((String)"max", (int)512)));
    public static final Property sendFailWarnInterval = BCloudLinkAlarmRecipient.newProperty((int)5, (BValue)BRelTime.makeHours((int)1), null);
    public static final Property lastSentToCloud = BCloudLinkAlarmRecipient.newProperty((int)257, (BValue)BAbsTime.NULL, null);
    public static final Action sendBatchAlarms = BCloudLinkAlarmRecipient.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BCloudLinkAlarmRecipient.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"alarm.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    private static final Logger log = Logger.getLogger("cloudLink.channel.alarm");
    private static final ReentrantLock alarmBatchLock = new ReentrantLock();
    private BAlarmsChannel alarmsChannel;
    private BCloudConnectionService connectionService;
    private Clock.Ticket alarmSendTicket;
    private int pendingAlarmCount;
    private BAlarmRecord[] pendingAlarms;
    private boolean alarmSendFailLogFlag;

    public BOrd getCloudConnectionService() {
        return (BOrd)this.get(cloudConnectionService);
    }

    public void setCloudConnectionService(BOrd v) {
        this.set(cloudConnectionService, (BValue)v, null);
    }

    public boolean getEnableBatchAlarms() {
        return this.getBoolean(enableBatchAlarms);
    }

    public void setEnableBatchAlarms(boolean v) {
        this.setBoolean(enableBatchAlarms, v, null);
    }

    public BRelTime getAlarmBatchDelay() {
        return (BRelTime)this.get(alarmBatchDelay);
    }

    public void setAlarmBatchDelay(BRelTime v) {
        this.set(alarmBatchDelay, (BValue)v, null);
    }

    public int getAlarmBatchSize() {
        return this.getInt(alarmBatchSize);
    }

    public void setAlarmBatchSize(int v) {
        this.setInt(alarmBatchSize, v, null);
    }

    public BRelTime getSendFailWarnInterval() {
        return (BRelTime)this.get(sendFailWarnInterval);
    }

    public void setSendFailWarnInterval(BRelTime v) {
        this.set(sendFailWarnInterval, (BValue)v, null);
    }

    public BAbsTime getLastSentToCloud() {
        return (BAbsTime)this.get(lastSentToCloud);
    }

    public void setLastSentToCloud(BAbsTime v) {
        this.set(lastSentToCloud, (BValue)v, null);
    }

    public void sendBatchAlarms() {
        this.invoke(sendBatchAlarms, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.resolveChannel();
        if (this.connectionService == null || this.connectionService.isFatalFault()) {
            log.severe("The Cloud Connection Service is missing or is in fatal fault. Check the host license.");
        }
        if (this.getLastSentToCloud() == BAbsTime.NULL) {
            this.setLastSentToCloud(BAbsTime.now());
        }
        if (this.getEnableBatchAlarms()) {
            this.pendingAlarms = new BAlarmRecord[this.getAlarmBatchSize()];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property prop, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(cloudConnectionService)) {
            this.resolveChannel();
        }
        if (enableBatchAlarms.equals(prop)) {
            if (this.getEnableBatchAlarms()) {
                this.pendingAlarms = new BAlarmRecord[this.getAlarmBatchSize()];
                this.pendingAlarmCount = 0;
            } else if (this.pendingAlarmCount > 0) {
                this.doSendBatchAlarms();
                this.pendingAlarms = null;
            }
        } else if (alarmBatchSize.equals(prop)) {
            if (this.pendingAlarmCount > this.getAlarmBatchSize()) {
                this.doSendBatchAlarms();
            }
            BAlarmRecord[] tmpAlarms = new BAlarmRecord[this.getAlarmBatchSize()];
            alarmBatchLock.lock();
            try {
                System.arraycopy(this.pendingAlarms, 0, tmpAlarms, 0, this.pendingAlarmCount);
                this.pendingAlarms = tmpAlarms;
            }
            finally {
                alarmBatchLock.unlock();
            }
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAlarmService || parent instanceof BAlarmClassFolder;
    }

    protected void resolveChannel() {
        BOrd serviceOrd = this.getCloudConnectionService();
        if (serviceOrd == BOrd.NULL) {
            BComponent[] services = Sys.getServices((Type)BCloudConnectionService.TYPE);
            if (services != null && services.length == 1) {
                serviceOrd = services[0].getNavOrd();
                this.setCloudConnectionService(serviceOrd);
            } else {
                return;
            }
        }
        try {
            this.connectionService = (BCloudConnectionService)serviceOrd.resolve().get();
            this.alarmsChannel = (BAlarmsChannel)this.connectionService.getChannel("Alarm");
        }
        catch (UnresolvedException ex) {
            log.warning("Unable to resolve cloudConnectionService for alarm recipient, will be unable to route alarms to cloud platform.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleAlarm(BAlarmRecord alarm) {
        if (this.alarmsChannel == null) {
            this.resolveChannel();
        }
        if (this.alarmsChannel == null) {
            log.warning(() -> String.format("No alarms channel configured for Cloud Link Alarm Recipient %s.", this.getDisplayName(null)));
            this.clearPendingAlarms();
            this.alarmSendFailLogFlag = true;
            return;
        }
        if (this.connectionService.isFatalFault()) return;
        if (!this.alarmsChannel.canSend()) {
            if (!this.alarmSendFailLogFlag) {
                log.warning("Cannot send alarms while the channel transport is disconnected.");
            }
            this.clearPendingAlarms();
            this.alarmSendFailLogFlag = true;
            return;
        }
        if (this.getEnableBatchAlarms()) {
            alarmBatchLock.lock();
            try {
                if (this.alarmSendTicket == null) {
                    this.alarmSendTicket = Clock.schedule((BComponent)this, (BRelTime)this.getAlarmBatchDelay(), (Action)sendBatchAlarms, null);
                }
                this.pendingAlarms[this.pendingAlarmCount++] = alarm;
                if (this.pendingAlarmCount < this.getAlarmBatchSize()) return;
                this.doSendBatchAlarms();
                return;
            }
            finally {
                if (alarmBatchLock.isHeldByCurrentThread()) {
                    alarmBatchLock.unlock();
                }
            }
        } else {
            BAbsTime updateTime = alarm.getLastUpdate();
            this.alarmsChannel.sendAlarm(alarm).whenComplete((result, err) -> {
                if (result.booleanValue() && this.getLastSentToCloud().isBefore(updateTime)) {
                    this.setLastSentToCloud(updateTime);
                }
            });
        }
    }

    private void clearPendingAlarms() {
        if (this.alarmSendTicket != null) {
            this.alarmSendTicket.cancel();
            this.alarmSendTicket = null;
        }
        for (int lcv = 0; lcv < this.pendingAlarmCount; ++lcv) {
            this.pendingAlarms[lcv] = null;
        }
        this.pendingAlarmCount = 0;
    }

    public void doSendBatchAlarms() {
        BAlarmRecord[] alarms;
        if (this.alarmsChannel == null || this.connectionService == null) {
            this.resolveChannel();
        }
        if (this.alarmsChannel == null || !this.alarmsChannel.canSend()) {
            log.warning("Cannot send alarms while the channel transport is disconnected.");
            this.clearPendingAlarms();
            return;
        }
        if (!alarmBatchLock.isHeldByCurrentThread()) {
            alarmBatchLock.lock();
        }
        try {
            alarms = new BAlarmRecord[this.pendingAlarmCount];
            System.arraycopy(this.pendingAlarms, 0, alarms, 0, this.pendingAlarmCount);
            this.clearPendingAlarms();
        }
        finally {
            alarmBatchLock.unlock();
        }
        BAbsTime lat = alarms[alarms.length - 1].getLastUpdate();
        for (int lcv = alarms.length - 2; lcv >= 0; --lcv) {
            if (!alarms[lcv].getLastUpdate().isAfter(lat)) continue;
            lat = alarms[lcv].getLastUpdate();
        }
        BAbsTime lastAlarmTime = lat;
        CompletableFuture.allOf(this.alarmsChannel.sendBatchAlarms(alarms).toArray(CloudLinkConstants.EMPTY_COMP_FUTURE_ARRAY)).whenComplete((result, err) -> {
            if (err == null && this.getLastSentToCloud().isBefore(lastAlarmTime)) {
                this.setLastSentToCloud(lastAlarmTime);
            }
        });
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps("BCloudLinkAlarmRecipient");
        out.prop((Object)"connectionService", (Object)this.connectionService);
        out.prop((Object)"alarmsChannel", (Object)this.alarmsChannel);
        out.prop((Object)"pendingAlarmCount", this.pendingAlarmCount);
        out.prop((Object)"alarmSendTicket", (Object)this.alarmSendTicket);
        out.prop((Object)"alarmSendFailLogFlag", this.alarmSendFailLogFlag);
        out.endProps();
    }

    public BIcon getIcon() {
        return icon;
    }
}

