/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.Conference;
import biweekly.util.DataUri;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;

public class ConferenceScribe
extends ICalPropertyScribe<Conference> {
    public ConferenceScribe() {
        super(Conference.class, "CONFERENCE", ICalDataType.URI);
    }

    @Override
    protected String _writeText(Conference property, WriteContext context) {
        return ConferenceScribe.write(property);
    }

    @Override
    protected Conference _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        value = VObjectPropertyValues.unescape(value);
        return ConferenceScribe.parse(value);
    }

    @Override
    protected void _writeXml(Conference property, XCalElement element, WriteContext context) {
        element.append(ICalDataType.URI, ConferenceScribe.write(property));
    }

    @Override
    protected Conference _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        String uri = element.first(ICalDataType.URI);
        if (uri != null) {
            return ConferenceScribe.parse(uri);
        }
        throw ConferenceScribe.missingXmlElements(ICalDataType.URI);
    }

    @Override
    protected JCalValue _writeJson(Conference property, WriteContext context) {
        return JCalValue.single(ConferenceScribe.write(property));
    }

    @Override
    protected Conference _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String uri = value.asSingle();
        return ConferenceScribe.parse(uri);
    }

    private static String write(Conference property) {
        String uri = property.getUri();
        if (uri != null) {
            return uri;
        }
        String text = property.getText();
        if (text != null) {
            return new DataUri(text).toString();
        }
        return "";
    }

    private static Conference parse(String value) {
        try {
            DataUri uri = DataUri.parse(value);
            String text = uri.getText();
            if (text != null) {
                Conference property = new Conference((String)null);
                property.setText(text);
                return property;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new Conference(value);
    }
}

