/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.DataModelConversionException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.parameter.ICalParameters;
import biweekly.parameter.ParticipationLevel;
import biweekly.parameter.ParticipationStatus;
import biweekly.parameter.Role;
import biweekly.property.Attendee;
import biweekly.property.Organizer;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import java.util.Iterator;

public class AttendeeScribe
extends ICalPropertyScribe<Attendee> {
    public AttendeeScribe() {
        super(Attendee.class, "ATTENDEE");
    }

    @Override
    protected ICalDataType _defaultDataType(ICalVersion version) {
        switch (version) {
            case V1_0: {
                return null;
            }
        }
        return ICalDataType.CAL_ADDRESS;
    }

    @Override
    protected ICalDataType _dataType(Attendee property, ICalVersion version) {
        if (version == ICalVersion.V1_0 && property.getUri() != null) {
            return ICalDataType.URL;
        }
        return this.defaultDataType(version);
    }

    @Override
    protected ICalParameters _prepareParameters(Attendee property, WriteContext context) {
        ICalParameters copy = new ICalParameters(property.getParameters());
        this.prepareRsvpParameter(property, copy, context);
        this.prepareRoleAndExpectParameters(property, copy, context);
        this.prepareParticipationStatusParameter(property, copy, context);
        this.prepareCommonNameParameter(property, copy, context);
        this.prepareEmailParameter(property, copy, context);
        return copy;
    }

    private void prepareRsvpParameter(Attendee property, ICalParameters copy, WriteContext context) {
        String value;
        Boolean rsvp = property.getRsvp();
        if (rsvp == null) {
            return;
        }
        switch (context.getVersion()) {
            case V1_0: {
                value = rsvp != false ? "YES" : "NO";
                break;
            }
            default: {
                value = rsvp != false ? "TRUE" : "FALSE";
            }
        }
        copy.put("RSVP", value);
    }

    private void prepareRoleAndExpectParameters(Attendee property, ICalParameters copy, WriteContext context) {
        Role role = property.getRole();
        ParticipationLevel level = property.getParticipationLevel();
        switch (context.getVersion()) {
            case V1_0: {
                if (role != null) {
                    copy.put("ROLE", role.getValue());
                }
                if (level != null) {
                    copy.put("EXPECT", level.getValue(context.getVersion()));
                }
                return;
            }
        }
        String value = null;
        if (role == Role.CHAIR) {
            value = role.getValue();
        } else if (level != null) {
            value = level.getValue(context.getVersion());
        } else if (role != null) {
            value = role.getValue();
        }
        if (value != null) {
            copy.put("ROLE", value);
        }
    }

    private void prepareParticipationStatusParameter(Attendee property, ICalParameters copy, WriteContext context) {
        String value;
        String name;
        ParticipationStatus partStat = property.getParticipationStatus();
        if (partStat == null) {
            return;
        }
        switch (context.getVersion()) {
            case V1_0: {
                name = "STATUS";
                value = partStat == ParticipationStatus.NEEDS_ACTION ? "NEEDS ACTION" : partStat.getValue();
                break;
            }
            default: {
                name = "PARTSTAT";
                value = partStat.getValue();
            }
        }
        copy.put(name, value);
    }

    private void prepareCommonNameParameter(Attendee property, ICalParameters copy, WriteContext context) {
        if (context.getVersion() == ICalVersion.V1_0) {
            return;
        }
        String name = property.getCommonName();
        if (name == null) {
            return;
        }
        copy.put("CN", name);
    }

    private void prepareEmailParameter(Attendee property, ICalParameters copy, WriteContext context) {
        if (context.getVersion() == ICalVersion.V1_0) {
            return;
        }
        String uri = property.getUri();
        String email = property.getEmail();
        if (uri == null || email == null) {
            return;
        }
        copy.put("EMAIL", email);
    }

    @Override
    protected Attendee _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        switch (context.getVersion()) {
            case V1_0: {
                return this.parseTextV1(value, dataType, parameters);
            }
        }
        return this.parseTextV2(value, parameters);
    }

    private Attendee parseTextV1(String value, ICalDataType dataType, ICalParameters parameters) {
        String statusStr;
        String expectStr;
        Attendee attendee = this.parseValueV1(value, dataType);
        Boolean rsvp = this.parseAndRemoveRsvpParameter(parameters, "YES", "NO");
        attendee.setRsvp(rsvp);
        String roleStr = (String)parameters.first("ROLE");
        if (roleStr != null) {
            attendee.setRole(Role.get(roleStr));
            parameters.remove("ROLE", roleStr);
        }
        if ((expectStr = parameters.getExpect()) != null) {
            attendee.setParticipationLevel(ParticipationLevel.get(expectStr));
            parameters.remove("EXPECT", expectStr);
        }
        if ((statusStr = parameters.getStatus()) != null) {
            attendee.setParticipationStatus(ParticipationStatus.get(statusStr));
            parameters.remove("STATUS", statusStr);
        }
        if (attendee.getRole() == Role.ORGANIZER) {
            Organizer organizer = new Organizer(attendee.getCommonName(), attendee.getEmail());
            organizer.setUri(attendee.getUri());
            organizer.setParameters(parameters);
            attendee.setParameters(parameters);
            DataModelConversionException conversionException = new DataModelConversionException(attendee);
            conversionException.getProperties().add(organizer);
            throw conversionException;
        }
        return attendee;
    }

    private Attendee parseValueV1(String value, ICalDataType dataType) {
        int bracketStart = value.lastIndexOf(60);
        int bracketEnd = value.lastIndexOf(62);
        if (bracketStart >= 0 && bracketEnd >= 0 && bracketStart < bracketEnd) {
            String name = value.substring(0, bracketStart).trim();
            String email = value.substring(bracketStart + 1, bracketEnd).trim();
            return new Attendee(name, email);
        }
        if (dataType == ICalDataType.URL) {
            return new Attendee(null, null, value);
        }
        return new Attendee(null, value);
    }

    private Attendee parseTextV2(String value, ICalParameters parameters) {
        String participationStatusStr;
        String email;
        String name = parameters.getCommonName();
        if (name != null) {
            parameters.remove("CN", name);
        }
        if ((email = parameters.getEmail()) != null) {
            parameters.remove("EMAIL", email);
        }
        String uri = value;
        if (email == null && (email = this.parseEmailFromMailtoUri(value)) != null) {
            uri = null;
        }
        Attendee attendee = new Attendee(name, email, uri);
        Boolean rsvp = this.parseAndRemoveRsvpParameter(parameters, "TRUE", "FALSE");
        attendee.setRsvp(rsvp);
        String roleStr = (String)parameters.first("ROLE");
        if (roleStr != null) {
            if (roleStr.equalsIgnoreCase(Role.CHAIR.getValue())) {
                attendee.setRole(Role.CHAIR);
            } else {
                ParticipationLevel participationLevel = ParticipationLevel.find(roleStr);
                if (participationLevel == null) {
                    attendee.setRole(Role.get(roleStr));
                } else {
                    attendee.setParticipationLevel(participationLevel);
                }
            }
            parameters.remove("ROLE", roleStr);
        }
        if ((participationStatusStr = parameters.getParticipationStatus()) != null) {
            attendee.setParticipationStatus(ParticipationStatus.get(participationStatusStr));
            parameters.remove("PARTSTAT", participationStatusStr);
        }
        return attendee;
    }

    private String parseEmailFromMailtoUri(String value) {
        String scheme;
        String mailtoScheme = "mailto";
        int colon = value.indexOf(58);
        if (colon == mailtoScheme.length() && mailtoScheme.equalsIgnoreCase(scheme = value.substring(0, colon))) {
            return value.substring(colon + 1);
        }
        return null;
    }

    private Boolean parseAndRemoveRsvpParameter(ICalParameters parameters, String trueValue, String falseValue) {
        Iterator it = parameters.get("RSVP").iterator();
        while (it.hasNext()) {
            String rsvpStr = (String)it.next();
            if (trueValue.equalsIgnoreCase(rsvpStr)) {
                it.remove();
                return true;
            }
            if (!falseValue.equalsIgnoreCase(rsvpStr)) continue;
            it.remove();
            return false;
        }
        return null;
    }

    @Override
    protected String _writeText(Attendee property, WriteContext context) {
        String uri = property.getUri();
        if (uri != null) {
            return uri;
        }
        String name = property.getCommonName();
        String email = property.getEmail();
        switch (context.getVersion()) {
            case V1_0: {
                if (email == null) break;
                String value = name == null ? email : name + " <" + email + ">";
                return VObjectPropertyValues.escape(value);
            }
            default: {
                if (email == null) break;
                return "mailto:" + email;
            }
        }
        return "";
    }
}

