/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtilsNiagara;

import com.tridium.clUtils.BModelDiscoverer;
import com.tridium.clUtils.DiscoveryUtils;
import com.tridium.clUtils.idm.HistoryInfo;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.fox.sys.data.BIPostQueryFilter;
import com.tridium.fox.sys.data.BIPreQueryValidator;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.util.BNiagaraRemoteQueryFilter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.job.BJob;
import javax.baja.job.JobLog;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraNetwork", "niagaraDriver:NiagaraStation"})})
public class BNiagaraModelDiscoverer
extends BModelDiscoverer
implements BFoxClientConnection.Interest {
    public static final Type TYPE = Sys.loadType(BNiagaraModelDiscoverer.class);
    private List<String> facetQueryColumns;
    private List<String> historyQueryColumns = Arrays.asList("id", "sourceHandle", "source", "systemTags", "historyName", "recordType", "valueFacets");
    public static String HISTORY_BQL_QUERY = "station:|history:|bql:select %s";
    public static String FACET_BQL_QUERY = "station:|slot:/|bql:select %s from control:ControlPoint";
    private static final String POINT_NEQL_QUERY = "station:|slot:/|neql:n:point";
    protected static final Lexicon lex = Lexicon.make((String)"clUtilsNiagara");
    private static final String lexWriteErrorKey = "modelDiscovererNiagara.device.writePoint.error";
    private static final String lexWriteHistoryErrorKey = "modelDiscovererNiagara.device.writeHistory.error";

    public Type getType() {
        return TYPE;
    }

    public BNiagaraModelDiscoverer() {
        this.facetQueryColumns = Arrays.asList("toPathString", "facets");
        this.historyToCloudIdMap = new HashMap();
    }

    public boolean discoverModelInfo(ZipOutputStream out, BDeviceNetwork network, BJob job) throws Exception {
        job.log().message("clUtilsNiagara", "modelDiscovererNiagara.network.discoverModelInfo.notSupported");
        return false;
    }

    public boolean discoverModelInfo(ZipOutputStream out, BDevice device, BJob job) throws Exception {
        JobLog log = job.log();
        BNiagaraStation station = (BNiagaraStation)device;
        log.message("clUtilsNiagara", "modelDiscovererNiagara.device.start", BNiagaraModelDiscoverer.getDeviceName(station));
        String basePath = this.getDevicePathOnNetwork(device);
        this.historyToCloudIdMap = new HashMap();
        this.historiesMap = this.discoverNiagaraHistories(station, log);
        this.writeHistoryInfo(this.historiesMap, basePath, out, log, lex, lexWriteHistoryErrorKey);
        this.historiesMap.clear();
        this.pointsMap = this.discoverNiagaraPoints(station, log);
        this.facetsMap = this.discoverNiagaraFacets(station, log);
        this.writePointInfo(this.pointsMap, this.facetsMap, basePath, out, log, lex, lexWriteErrorKey);
        this.releaseMaps();
        return true;
    }

    protected BDataChannel connectToRemoteStation(BNiagaraStation station) throws Exception {
        BFoxClientConnection connection = station.getClientConnection();
        connection.engageNoRetry((BFoxClientConnection.Interest)this);
        BDataChannel channel = (BDataChannel)connection.getChannels().get("data", BDataChannel.TYPE);
        return channel;
    }

    protected BITable<?> queryRemoteStationIntoTable(BDataChannel channel, String query, List<String> columnsToExtract) throws Exception {
        BOrd ord = BOrd.make((String)String.format(query, String.join((CharSequence)",", columnsToExtract)));
        BITable table = (BITable)channel.resolve(ord, new String[0]);
        return table;
    }

    protected List<Entity> findRemoteNiagaraPoints(BNiagaraStation station, String query) throws Exception {
        BDataChannel channel = this.connectToRemoteStation(station);
        BOrd ord = BOrd.make((String)query);
        BNiagaraRemoteQueryFilter[] queryFilters = new BNiagaraRemoteQueryFilter[]{BNiagaraRemoteQueryFilter.make((boolean)true, (boolean)false)};
        List pointEntities = channel.resolveEntitiesToList(BOrdList.make((BOrd)ord), 0, -1, (BIPreQueryValidator[])queryFilters, (BIPostQueryFilter[])queryFilters);
        return pointEntities;
    }

    protected Map<String, Entity> discoverNiagaraPoints(BNiagaraStation station, JobLog log) throws Exception {
        logger.fine("Discovering points in " + BNiagaraModelDiscoverer.getDeviceName(station));
        HashMap<String, Entity> entityMap = new HashMap<String, Entity>();
        this.findRemoteNiagaraPoints(station, POINT_NEQL_QUERY).forEach(e -> {
            entityMap.put(BNiagaraModelDiscoverer.removePrefixOrd((BOrd)e.getOrdToEntity().orElse(BOrd.DEFAULT), (String)"nspace"), (Entity)e);
            logger.finest(() -> String.format("Found point: ord=%s", e.getOrdToEntity().orElse(BOrd.NULL)));
        });
        log.message("modelDiscoveryNiagara", "modelDiscovererNiagara.device.foundPoints", new String[]{String.valueOf(entityMap.size()), entityMap.size() == 1 ? lex.getText("point") : lex.getText("points"), BNiagaraModelDiscoverer.getDeviceName(station)});
        return entityMap;
    }

    protected Map<String, BFacets> discoverNiagaraFacets(BNiagaraStation station, JobLog log) throws Exception {
        logger.fine("Discovering point facets in " + BNiagaraModelDiscoverer.getDeviceName(station));
        BDataChannel channel = this.connectToRemoteStation(station);
        BITable<?> table = this.queryRemoteStationIntoTable(channel, FACET_BQL_QUERY, this.facetQueryColumns);
        ColumnList columns = table.getColumns();
        HashMap<String, BFacets> facetsMap = new HashMap<String, BFacets>();
        try (TableCursor cursor = table.cursor();){
            while (cursor.next()) {
                String path = cursor.cell(columns.get("toPathString")).toDataValue().encodeToString();
                String facets = cursor.cell(columns.get("facets")).toDataValue().encodeToString();
                facetsMap.put(path, BFacets.make((String)facets));
                logger.finest(() -> String.format("Found facets for point: slotpath=%s, facets=%s", path, facets));
            }
        }
        log.message("modelDiscoveryNiagara", "modelDiscovererNiagara.device.foundFacets", new String[]{String.valueOf(facetsMap.size()), facetsMap.size() == 1 ? lex.getText("entry") : lex.getText("entries"), BNiagaraModelDiscoverer.getDeviceName(station)});
        return facetsMap;
    }

    protected Map<String, HistoryInfo> discoverNiagaraHistories(BNiagaraStation station, JobLog log) throws Exception {
        logger.fine("Discovering histories in " + BNiagaraModelDiscoverer.getDeviceName(station));
        BDataChannel channel = this.connectToRemoteStation(station);
        BITable<?> table = this.queryRemoteStationIntoTable(channel, HISTORY_BQL_QUERY, this.historyQueryColumns);
        ColumnList columns = table.getColumns();
        HashMap<String, HistoryInfo> historiesMap = new HashMap<String, HistoryInfo>();
        try (TableCursor cursor = table.cursor();){
            while (cursor.next()) {
                HistoryInfo info = new HistoryInfo(cursor.cell(columns.get("id")).toDataValue().encodeToString(), cursor.cell(columns.get("sourceHandle")).toDataValue().encodeToString(), cursor.cell(columns.get("source")).toDataValue().encodeToString(), cursor.cell(columns.get("systemTags")).toDataValue().encodeToString(), cursor.cell(columns.get("historyName")).toDataValue().encodeToString(), cursor.cell(columns.get("recordType")).toDataValue().encodeToString(), cursor.cell(columns.get("valueFacets")).toDataValue().encodeToString());
                logger.finest(() -> String.format("Found history: id=%s, source=%s, name=%s", info.hId, info.source, info.historyName));
                historiesMap.put(cursor.cell(columns.get("id")).toDataValue().encodeToString(), info);
            }
        }
        log.message("modelDiscoveryNiagara", "modelDiscovererNiagara.device.foundHistories", new String[]{String.valueOf(historiesMap.size()), historiesMap.size() == 1 ? lex.getText("history") : lex.getText("histories"), BNiagaraModelDiscoverer.getDeviceName(station)});
        return historiesMap;
    }

    protected static String getDeviceName(BNiagaraStation device) {
        return device.isMounted() ? device.getName() : "NiagaraStation";
    }

    protected String getDevicePathOnNetwork(BDevice dev) {
        return DiscoveryUtils.getDevicePathFromNetwork((BDevice)dev);
    }
}

