function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/**
 * @copyright  2019 Tridium, Inc. All Rights Reserved.
 * @author Ashutosh Chaturvedi
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/cloudLink/rc/history/util/IconDisplayNameColumn
 */
define(['jquery', 'Promise', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/fe/fe', 'bajaux/icon/iconUtils', 'nmodule/webEditors/rc/wb/table/model/Column'], function ($, Promise, IconEditor, fe, iconUtils, Column) {
  'use strict';
  /**
   * IconDisplayNameColumn type used to show an icon and display text in a
   * specific column in the table. This column type will not, by default,
   * be available in the show/hide menu, and will not have the sorting
   * functionality available.
   *
   * @class
   * @alias module:nmodule/cloudLink/rc/history/model/IconDisplayNameColumn
   * @extends module:nmodule/webEditors/rc/wb/table/model/Column
   */

  var IconDisplayNameColumn = function IconDisplayNameColumn(name, params) {
    name = name || 'icon';
    params = params || {};
    params.flags = Column.flags.READONLY;

    if (!params.displayName) {
      params.displayName = ' '; // a single space for an empty column heading
    }

    Column.call(this, name, params);
    this.setSortable(false);
    this.setHidable(false);
    this.setExportable(false);
  };

  IconDisplayNameColumn.prototype = Object.create(Column.prototype);
  /**
   * Get the display value for the given row.
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row A table row
   * @returns {String|*} the display text of the row.
   */

  IconDisplayNameColumn.prototype.getValueFor = function (row) {
    return row.getSubject().getNavDisplayName();
  };
  /**
   * Gets the icon URI for the given row. By default, this will delegate to
   * the `Row`'s getIcon() function. This function can be overridden to allow
   * the source of the icon to be more flexible. This method may return a single
   * icon, or an array of icons.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row A table row
   * @returns {baja.Icon|Array.<baja.Icon>} the icon(s) for the row, or null if the row does not
   * specify any.
   */


  IconDisplayNameColumn.prototype.getIcon = function (row) {
    return row.getSubject().getNavIcon();
  };
  /**
   * Build the dom for the cell. This will build an `IconEditor` for each
   * icon returned by the `getIcon` function. To which it will append the display text
   * returned by the `getValueFor` function.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @param {JQuery} dom
   * @returns {Promise} A promise resolved with the img element added to the dom.
   */


  IconDisplayNameColumn.prototype.buildCell = function (row, dom) {
    var name = this.getValueFor(row);
    var icon = this.getIcon(row);
    var span = document.createElement('span');
    var nameSpan = document.createElement('span');
    nameSpan.textContent = name;
    return iconUtils.toElements(icon).then(function (elements) {
      var _dom$;

      (_dom$ = dom[0]).append.apply(_dom$, _toConsumableArray(elements).concat([span, nameSpan]));
    });
  };
  /**
   * Destroy the IconEditor that was created for this cell.
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @param {JQuery} dom
   * @returns {Promise}
   */


  IconDisplayNameColumn.prototype.destroyCell = function (row, dom) {
    var promises = [];
    dom.find('.IconEditor').each(function () {
      var fe = $(this).data('widget');

      if (fe) {
        promises.push(fe.destroy());
      }
    });
    return Promise.all(promises);
  };

  return IconDisplayNameColumn;
});
