/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.util;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.util.BSMAExpirationMonitorMode;
import com.tridium.cloudLink.util.LicenseLimit;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BFormat;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="exempt", type="boolean", defaultValue="false", flags=7), @NiagaraProperty(name="mode", type="BSMAExpirationMonitorMode", defaultValue="BSMAExpirationMonitorMode.DEFAULT", flags=264), @NiagaraProperty(name="warnBelow", type="int", defaultValue="30", flags=264, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"day\")"), @Facet(name="BFacets.MIN", value="BInteger.make(1)"), @Facet(name="BFacets.MAX", value="BInteger.make(180)")}), @NiagaraProperty(name="checkInterval", type="BRelTime", defaultValue="BRelTime.DAY", flags=261), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="remaining", type="BStatusNumeric", defaultValue="new BStatusNumeric(-1, BStatus.stale)", flags=9, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"day\")"), @Facet(name="BFacets.PRECISION", value="BInteger.make(0)")})})
@NiagaraActions(value={@NiagaraAction(name="checkMaintenanceExpiration", flags=16), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
public class BSMAExpirationMonitor
extends BComponent
implements BIAlarmSource {
    public static final Property exempt = BSMAExpirationMonitor.newProperty((int)7, (boolean)false, null);
    public static final Property mode = BSMAExpirationMonitor.newProperty((int)264, (BValue)BSMAExpirationMonitorMode.DEFAULT, null);
    public static final Property warnBelow = BSMAExpirationMonitor.newProperty((int)264, (int)30, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"day")), (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1))), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)180))));
    public static final Property checkInterval = BSMAExpirationMonitor.newProperty((int)261, (BValue)BRelTime.DAY, null);
    public static final Property alarmSourceInfo = BSMAExpirationMonitor.newProperty((int)0, (BValue)BSMAExpirationMonitor.initAlarmSourceInfo(), null);
    public static final Property remaining = BSMAExpirationMonitor.newProperty((int)9, (BValue)new BStatusNumeric(-1.0, BStatus.stale), (BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"day")), (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0))));
    public static final Action checkMaintenanceExpiration = BSMAExpirationMonitor.newAction((int)16, null);
    public static final Action ackAlarm = BSMAExpirationMonitor.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BSMAExpirationMonitor.class);
    private static final BIcon icon = BIcon.std((String)"monitor.png");
    private Clock.Ticket smaSchedule = Clock.expiredTicket;
    private AlarmSupport alarmSupport;
    private ExecutorService executorService;
    static final Logger log = Logger.getLogger("cloudLink.smaMonitor");
    static final Lexicon lex = Lexicon.make(BSMAExpirationMonitor.class);
    private static final String LOG_WARNING = "CloudLink requires active Software Maintenance. Remaining days: ";
    private static final String LOG_NO_SMA = "CloudLink requires active Software Maintenance.  No active maintenance found in license";
    private final Object checkLock = new Object();

    public boolean getExempt() {
        return this.getBoolean(exempt);
    }

    public void setExempt(boolean v) {
        this.setBoolean(exempt, v, null);
    }

    public BSMAExpirationMonitorMode getMode() {
        return (BSMAExpirationMonitorMode)this.get(mode);
    }

    public void setMode(BSMAExpirationMonitorMode v) {
        this.set(mode, (BValue)v, null);
    }

    public int getWarnBelow() {
        return this.getInt(warnBelow);
    }

    public void setWarnBelow(int v) {
        this.setInt(warnBelow, v, null);
    }

    public BRelTime getCheckInterval() {
        return (BRelTime)this.get(checkInterval);
    }

    public void setCheckInterval(BRelTime v) {
        this.set(checkInterval, (BValue)v, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    public BStatusNumeric getRemaining() {
        return (BStatusNumeric)this.get(remaining);
    }

    public void setRemaining(BStatusNumeric v) {
        this.set(remaining, (BValue)v, null);
    }

    public void checkMaintenanceExpiration() {
        this.invoke(checkMaintenanceExpiration, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (this.service().isFatalFault()) {
            return;
        }
        this.executorService = ExecutorUtil.newSingleThreadBackgroundExecutor((String)"cloudLinkSmaExpirationMonitor", (long)1L, (TimeUnit)TimeUnit.MINUTES);
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.setExempt(LicenseLimit.isSmaExempt());
        this.checkMaintenanceExpiration();
    }

    public void stopped() throws Exception {
        this.cancelTicket();
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && (property.equals(mode) || property.equals(warnBelow))) {
            this.checkMaintenanceExpiration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckMaintenanceExpiration() {
        Object object = this.checkLock;
        synchronized (object) {
            this.logCurrentValues();
            if (this.getMode() == BSMAExpirationMonitorMode.disabled) {
                this.reportDisabled();
            } else {
                if (LicenseLimit.isSmaExempt()) {
                    this.reportOk();
                    return;
                }
                Optional<Long> optSmaExpirationTsMillis = this.getSmaExpiration();
                if (!optSmaExpirationTsMillis.isPresent()) {
                    this.reportNoSma();
                    return;
                }
                long expiration = optSmaExpirationTsMillis.get();
                long now = BAbsTime.now().getMillis();
                log.finest(() -> "SMA Expiration: " + BAbsTime.make((long)expiration));
                if (now >= expiration) {
                    this.reportExpired();
                } else {
                    this.updateDaysRemaining(now, expiration);
                    long nowPlusWarning = now + (long)this.getWarnBelow() * 86400000L;
                    if (nowPlusWarning >= expiration) {
                        this.reportWarning();
                    } else {
                        this.reportOk();
                    }
                    this.scheduleNextCheck();
                }
            }
            this.logCurrentValues();
        }
    }

    private void reportDisabled() {
        this.cancelTicket();
        this.getRemaining().setStatusDisabled(true);
        this.getRemaining().setStatusInAlarm(false);
        this.getRemaining().setStatusFault(false);
        if (!this.getExempt()) {
            log.info("SMA Expiration Monitor Disabled");
        }
    }

    private void reportOk() {
        log.fine(() -> "Expiration check passed ok");
        if (this.getRemaining().getStatus().isAlarm()) {
            try {
                this.alarmSupport.toNormal(Context.NULL);
                this.getRemaining().setStatusInAlarm(false);
                this.getRemaining().setStatusFault(false);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Cannot process normal alarm: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            }
        }
    }

    private void reportWarning() {
        log.info(LOG_WARNING + this.getRemaining());
        if (this.getRemaining().getStatus().isFault()) {
            this.getRemaining().setStatusFault(false);
            this.service().initLicenseProperty();
        }
        if (!this.getRemaining().getStatus().isAlarm() && BSMAExpirationMonitorMode.warning == this.getMode()) {
            try {
                BAlarmRecord rec = this.alarmSupport.newOffnormalAlarm();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Raising offNormal SMA Warning:" + rec);
                }
                this.getRemaining().setStatusInAlarm(true);
                this.getRemaining().setStatusUnackedAlarm(true);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Cannot process off normal alarm: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            }
        }
    }

    private void reportNoSma() {
        log.warning(LOG_NO_SMA);
        try {
            if (!this.service().isFatalFault()) {
                this.service().configFatal(lex.getText("noSma"));
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Could not update Cloud Connection Service fault cause", log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    private void reportExpired() {
        log.warning("CloudLink requires active Software Maintenance. Remaining days: 0");
        try {
            this.service().setStatus(BStatus.fault);
            this.service().setFaultCause(lex.getText("smaExpired"));
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Could not update Cloud Connection Service fault cause", log.isLoggable(Level.FINE) ? ex : null);
        }
        if (!this.getRemaining().getStatus().isFault()) {
            try {
                BAlarmRecord fault = this.alarmSupport.newFaultAlarm();
                this.getRemaining().setStatusFault(true);
                this.getRemaining().setStatusInAlarm(true);
                this.getRemaining().setStatusUnackedAlarm(true);
                this.getRemaining().setValue(0.0);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Raising Fault for expired SMA: " + fault);
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Cannot process fault alarm for expired SMA", log.isLoggable(Level.FINE) ? ex : null);
            }
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord alarmRecord) {
        log.fine(() -> "Entering doAckAlarm");
        log.fine(() -> "Entering AckAlarm " + alarmRecord);
        try {
            BBoolean result = BBoolean.make((boolean)this.alarmSupport.ackAlarm(alarmRecord));
            if (!alarmRecord.getAckRequired()) {
                log.finest(() -> "Removing unack status");
                this.getRemaining().setStatusUnackedAlarm(false);
            }
            return result;
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Cannot process alarm ack: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            return BBoolean.FALSE;
        }
    }

    private Optional<Long> getSmaExpiration() {
        Optional<Long> expirationOp = LicenseLimit.getSmaExpiration();
        if (!expirationOp.isPresent() && !this.getExempt()) {
            log.info("SMA expiration date unavailable.");
        }
        return expirationOp;
    }

    private void updateDaysRemaining(long now, long expiration) {
        int remain = BSMAExpirationMonitor.getDaysRemaining(now, expiration);
        this.getRemaining().setStatus(BStatus.make((BStatus)this.getRemaining().getStatus(), (int)16, (boolean)false));
        this.getRemaining().setValue((double)remain);
    }

    private void logCurrentValues() {
        log.finest(() -> "Current values: " + this.getRemaining() + " svc: " + this.service().getStatus());
    }

    public static int getDaysRemaining(long now, long expiration) {
        long daysRemain = (expiration - now) / 86400000L;
        int days = Math.toIntExact(daysRemain);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Calculating days remaining as (" + expiration + '-' + now + ") / " + 86400000L + " = " + daysRemain + 'L' + " [i:" + days + ']');
        }
        return days;
    }

    private void scheduleNextCheck() {
        this.cancelTicket();
        if (this.isRunning()) {
            BAbsTime nextTime = BAbsTime.now().add(this.getCheckInterval());
            log.fine(() -> "Scheduling next SMA Expiration check for " + nextTime);
            this.smaSchedule = Clock.schedule((BComponent)this, (BAbsTime)nextTime, (Action)checkMaintenanceExpiration, null);
        }
    }

    private void cancelTicket() {
        if (!this.smaSchedule.isExpired()) {
            this.smaSchedule.cancel();
            this.smaSchedule = Clock.expiredTicket;
        }
    }

    public BCloudConnectionService service() {
        return (BCloudConnectionService)this.getParent();
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (checkMaintenanceExpiration.equals(action)) {
            this.executorService.execute((Runnable)new Invocation((BComponent)this, action, argument, cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BCloudConnectionService;
    }

    public boolean isChildLegal(BComponent child) {
        return false;
    }

    public boolean isNavChild() {
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }

    static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"%parent.parent.displayName%.%parent.displayName%"));
        asi.setToFaultText(BFormat.make((String)"%lexicon(cloudLink:smaExpired)%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(cloudLink:smaWarn)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(cloudLink:smaOk)%"));
        asi.setAlarmIcon(BOrd.make((String)"module://icons/x16/braces.png"));
        return asi;
    }
}

