/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport.internal;

import com.tridium.cloudLink.transport.internal.AmqpConstants;
import com.tridium.cloudLink.transport.internal.AmqpReceiverLinkHandler;
import com.tridium.cloudLink.transport.internal.IAmqpSessionHandler;
import com.tridium.cloudLink.util.StringWrapper;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.engine.Receiver;

public class AmqpTelemetryReceiverLinkHandler
extends AmqpReceiverLinkHandler {
    AmqpTelemetryReceiverLinkHandler(Receiver receiver, String linkId, IAmqpSessionHandler parent) {
        super(receiver, linkId, parent);
        String deviceId = StringWrapper.getString(parent.getClient().getConnectionInfo().get("id"));
        this.linkAddress = String.format("/devices/%s/messages/devicebound", deviceId);
        this.amqpProperties.put(Symbol.getSymbol("com.microsoft:client-version"), String.format("com.tridium.cloudLink.amqp/0.0.1 (%s; %s; %s)", AmqpConstants.JAVA_RUNTIME, AmqpConstants.OPERATING_SYSTEM, AmqpConstants.PROCESSOR_ARCHITECTURE));
        this.amqpProperties.put(Symbol.getSymbol("com.microsoft:channel-correlation-id"), Symbol.getSymbol(deviceId));
    }

    static String getTag(String deviceId, String linkId) {
        return "receiver_link_telemetry-" + deviceId + '-' + linkId;
    }
}

