/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport;

import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class HttpResponseMessage
implements IMessageResponse,
Closeable {
    private static final Logger log = Logger.getLogger("cloudLink.transport.http");
    private final Response response;

    public HttpResponseMessage(Response response) {
        Objects.requireNonNull(response, "The HTTP Response cannot be null.");
        this.response = response;
    }

    public int getStatusCode() {
        return this.response.code();
    }

    public Map<String, List<String>> getHeaders() {
        return this.response.headers().toMultimap();
    }

    public InputStream getBody() {
        return this.getResponseBody().byteStream();
    }

    public String getBodyAsString() {
        try {
            if (this.getResponseBody() == null) {
                return "";
            }
            return this.getResponseBody().string();
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Error getting message payload: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            return "";
        }
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public byte[] getPayload() {
        try {
            if (this.getResponseBody() == null) {
                return CloudLinkConstants.EMPTY_BYTES;
            }
            return this.getResponseBody().bytes();
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Error getting message payload: ", log.isLoggable(Level.FINE) ? ex : null);
            return CloudLinkConstants.EMPTY_BYTES;
        }
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.response.headers().toMultimap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.join((CharSequence)",", (Iterable)e.getValue())));
    }

    @Override
    public void close() throws IOException {
        if (this.getResponseBody() != null) {
            this.response.close();
        }
    }

    protected ResponseBody getResponseBody() {
        return this.response.body();
    }
}

