/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.transport.BAbstractConnectionlessTransport;
import com.tridium.cloudLink.transport.BTlsVersion;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.cloudLink.transport.HttpStatusException;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.MessageWrapper;
import com.tridium.cloudLink.util.BICachingCertificateConsumer;
import com.tridium.crypto.core.io.CoreClientTrustManager;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.CryptoCoreClientSocketFactory;
import com.tridium.crypto.core.io.CryptoSupport;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import java.io.File;
import java.io.IOException;
import java.net.URLPermission;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.BufferedSink;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="connectTimeout", type="int", defaultValue="15000", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")")}), @NiagaraProperty(name="readTimeout", type="int", defaultValue="30000", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")")}), @NiagaraProperty(name="writeTimeout", type="int", defaultValue="15000", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")")}), @NiagaraProperty(name="sslProtocol", type="BTlsVersion", defaultValue="BTlsVersion.TLSv1_2", flags=5, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
@NiagaraAction(name="certificateUpdate", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BBoolean", flags=4)
public class BHttpTransport
extends BAbstractConnectionlessTransport
implements BICachingCertificateConsumer {
    public static final Property connectTimeout = BHttpTransport.newProperty((int)0, (int)15000, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond"))));
    public static final Property readTimeout = BHttpTransport.newProperty((int)0, (int)30000, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond"))));
    public static final Property writeTimeout = BHttpTransport.newProperty((int)0, (int)15000, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond"))));
    public static final Property sslProtocol = BHttpTransport.newProperty((int)5, (BValue)BTlsVersion.TLSv1_2, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Action certificateUpdate = BHttpTransport.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BHttpTransport.class);
    private final Map<String, OkHttpClient> clients = new HashMap<String, OkHttpClient>();
    private Consumer<IMessage> messageLogger;
    private static final Logger log = Logger.getLogger("cloudLink.transport.http");
    protected static final String DEFAULT_CLIENT = "default";

    public int getConnectTimeout() {
        return this.getInt(connectTimeout);
    }

    public void setConnectTimeout(int v) {
        this.setInt(connectTimeout, v, null);
    }

    public int getReadTimeout() {
        return this.getInt(readTimeout);
    }

    public void setReadTimeout(int v) {
        this.setInt(readTimeout, v, null);
    }

    public int getWriteTimeout() {
        return this.getInt(writeTimeout);
    }

    public void setWriteTimeout(int v) {
        this.setInt(writeTimeout, v, null);
    }

    public BTlsVersion getSslProtocol() {
        return (BTlsVersion)this.get(sslProtocol);
    }

    public void setSslProtocol(BTlsVersion v) {
        this.set(sslProtocol, (BValue)v, null);
    }

    public BBoolean certificateUpdate(BString parameter) {
        return (BBoolean)this.invoke(certificateUpdate, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    public String getTransportType() {
        return "HTTP";
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (this.getConnectionService().map(c -> c.isFatalFault()).orElse(true).booleanValue()) {
            return;
        }
        try {
            BAbstractCloudLinkHandlerFactory factory = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service.")).getMessageHandlerFactory(this.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
            this.messageLogger = factory.getMessageLogger();
        }
        catch (IllegalStateException ex) {
            this.fatalFault = true;
            this.updateStatus();
            this.setFaultCause(lex.getText("transport.noHandlerFactory"));
            log.log(Level.WARNING, "Unable to locate message handler for HTTP transport, are you missing a module?", log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
        this.clients.clear();
    }

    public void changed(Property prop, Context context) {
        if (!this.isRunning() || this.getConnectionService().map(c -> c.isFatalFault()).orElse(true).booleanValue()) {
            return;
        }
        if (prop.equals(connectTimeout) || prop.equals(writeTimeout) || prop.equals(readTimeout) || prop.equals(sslProtocol)) {
            this.clients.clear();
        }
    }

    private OkHttpClient getClient(BCertificateAliasAndPassword certAliasAndPass) throws Exception {
        String certAlias = certAliasAndPass == null ? null : certAliasAndPass.getAlias();
        OkHttpClient client = certAlias == null ? this.clients.get(DEFAULT_CLIENT) : this.clients.get(certAlias);
        if (client == null) {
            client = this.makeClient(certAliasAndPass);
        }
        return client;
    }

    private OkHttpClient makeClient(BCertificateAliasAndPassword certAliasAndPass) throws Exception {
        try {
            return AccessController.doPrivileged(() -> {
                ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new String[]{this.getSslProtocol().getDisplayTag(null)}).cipherSuites(CryptoSupport.getRecommendedCipherSuites()).build();
                String certAlias = null;
                String password = null;
                if (certAliasAndPass != null) {
                    certAlias = certAliasAndPass.getAlias();
                    password = certAliasAndPass.getPassword().getValue();
                }
                ClientTlsParameters tlsParameters = new ClientTlsParameters(this.getSslProtocol().getDisplayTag(null), certAlias);
                if (password != null && !password.isEmpty()) {
                    tlsParameters.setKeyPassphrase(password);
                }
                CryptoCoreClientSocketFactory factory = new CryptoCoreClientSocketFactory(tlsParameters);
                CoreClientTrustManager trustManager = CoreClientTrustManager.make((CoreCryptoManager)CoreCryptoManager.get(), () -> null);
                OkHttpClient client = new OkHttpClient.Builder().connectionSpecs(Collections.singletonList(spec)).sslSocketFactory((SSLSocketFactory)factory, (X509TrustManager)trustManager).connectTimeout((long)this.getConnectTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)this.getWriteTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)this.getReadTimeout(), TimeUnit.MILLISECONDS).build();
                this.clients.put(certAlias != null ? certAlias : DEFAULT_CLIENT, client);
                return client;
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @Override
    public Action getCertificateUpdateAction() {
        return certificateUpdate;
    }

    public final BBoolean doCertificateUpdate(BString alias) {
        return BBoolean.make((this.clients.remove(alias.getString()) != null ? 1 : 0) != 0);
    }

    @Override
    public void send(MessageWrapper<? extends IMessage> payload) throws IOException {
        if (this.getStatus().isFault()) {
            payload.getTransportFuture().completeExceptionally(new IOException("Unable to send while HTTP transport is in fault."));
            return;
        }
        if (this.getStatus().isDisabled()) {
            payload.getTransportFuture().completeExceptionally(new IOException("Unable to send while HTTP transport is disabled."));
            return;
        }
        if (!this.canSend()) {
            payload.getTransportFuture().completeExceptionally(new IOException("HTTP transport is unable to send."));
            return;
        }
        try {
            if (!(payload.getMessage() instanceof HttpRequestMessage)) {
                IOException ioEx = new IOException("Invalid message type for HTTP transport " + payload.getMessage().getClass().getName());
                payload.getTransportFuture().completeExceptionally(ioEx);
                throw ioEx;
            }
            HttpRequestMessage message = (HttpRequestMessage)payload.getMessage();
            BHttpTransport.checkPermission(message);
            HttpResponseMessage responseMessage = AccessController.doPrivileged(() -> {
                OkHttpClient client = this.getClient(message.getCertificateAliasAndPassword().orElse(null));
                Request request = BHttpTransport.makeRequest(message);
                Response response = client.newCall(request).execute();
                HttpResponseMessage resultMessage = new HttpResponseMessage(response);
                this.messageLogger.accept(resultMessage);
                if (!response.isSuccessful()) {
                    String errorMessage = "";
                    JSONObject jsonErr = null;
                    if (response.body() != null) {
                        MediaType contentType = response.body().contentType();
                        String respBody = response.body().string();
                        if (contentType != null && contentType.subtype().toLowerCase().contains("json")) {
                            try {
                                jsonErr = new JSONObject(new JSONTokener(respBody));
                                errorMessage = jsonErr.optString("message", Objects.toString(jsonErr));
                            }
                            catch (JSONException e) {
                                log.fine(() -> String.format("JSON response body could not be parsed: %s", respBody));
                                errorMessage = respBody;
                            }
                        } else {
                            errorMessage = respBody;
                        }
                    }
                    if (errorMessage.isEmpty()) {
                        errorMessage = response.message();
                    }
                    throw new HttpStatusException(response.code(), errorMessage, response.headers().toMultimap(), jsonErr);
                }
                return resultMessage;
            });
            payload.getTransportFuture().complete(responseMessage);
        }
        catch (PrivilegedActionException e) {
            Exception inner = e.getException();
            payload.getTransportFuture().completeExceptionally(inner);
        }
    }

    @Override
    public boolean canSend() {
        return this.isOperational();
    }

    public static final void checkPermission(HttpRequestMessage httpRequestMessage) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            throw new SecurityException("Transport cannot send message because there is no security manager");
        }
        String methodName = httpRequestMessage.getMethod().name();
        String headers = String.join((CharSequence)",", httpRequestMessage.getRequestHeaders().keySet());
        String permissionActions = String.format("%s%s%s", methodName, headers.isEmpty() ? "" : ":", headers);
        sm.checkPermission(new URLPermission(httpRequestMessage.getUrl().toString(), permissionActions));
    }

    private static Request makeRequest(final HttpRequestMessage message) {
        Request.Builder reqBuilder = new Request.Builder();
        reqBuilder.url(message.getUrl());
        Map<String, Object> headers = message.getRequestHeaders();
        if (message.hasBody()) {
            MediaType mimeType;
            MediaType mediaType = mimeType = message.getMimeType() != null ? MediaType.get((String)message.getMimeType()) : null;
            Object body = message.isFileUpload() ? new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", message.getFileToUpload().getName(), RequestBody.create((File)message.getFileToUpload(), (MediaType)mimeType)).build() : (message.isBodyStreamed() ? new RequestBody(){

                public MediaType contentType() {
                    return mimeType;
                }

                public void writeTo(BufferedSink bufferedSink) throws IOException {
                    message.getBodyStream().accept(bufferedSink.outputStream());
                }
            } : RequestBody.create((byte[])message.getPayload(), (MediaType)mimeType, (int)0, (int)BHttpTransport.getMessageSize(message, headers)));
            if (message.getMethod() == HttpRequestMessage.HttpMethod.POST) {
                reqBuilder.post(body);
            } else if (message.getMethod() == HttpRequestMessage.HttpMethod.PUT) {
                reqBuilder.put(body);
            } else if (message.getMethod() == HttpRequestMessage.HttpMethod.PATCH) {
                reqBuilder.patch(body);
            } else if (message.getMethod() == HttpRequestMessage.HttpMethod.DELETE) {
                reqBuilder.delete(body);
            } else {
                log.warning(() -> String.format("Unsupported: HTTP Message of type %s with a body, dropping body.", new Object[]{message.getMethod()}));
            }
        } else if (message.getMethod() == HttpRequestMessage.HttpMethod.GET) {
            reqBuilder.get();
        } else if (message.getMethod() == HttpRequestMessage.HttpMethod.DELETE) {
            reqBuilder.delete();
        } else if (message.getMethod() == HttpRequestMessage.HttpMethod.POST) {
            reqBuilder.post(Util.EMPTY_REQUEST);
        } else {
            log.warning(() -> String.format("Unsupported: HTTP Message of type %s with no body, using GET.", new Object[]{message.getMethod()}));
        }
        if (headers != null) {
            headers.forEach((key, value) -> reqBuilder.addHeader(key, value.toString()));
        }
        return reqBuilder.build();
    }

    private static int getMessageSize(HttpRequestMessage message, Map<String, Object> headers) {
        if (headers.containsKey("Content-Length")) {
            Object len = headers.get("Content-Length");
            int size = len instanceof Number ? ((Number)len).intValue() : Integer.parseInt(len.toString());
            if (size < 0 || size > message.getPayload().length) {
                throw new IndexOutOfBoundsException("Content length is out of range of message payload");
            }
            return size;
        }
        return message.getPayload().length;
    }

    @Override
    protected boolean retriableError(Throwable err) {
        if (err instanceof HttpStatusException) {
            HttpStatusException httpErr = (HttpStatusException)err;
            switch (httpErr.getStatusCode()) {
                case 304: 
                case 404: 
                case 418: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }
}

