/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.tag;

import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.tag.BPropertySuppliedTag;
import com.tridium.cloudLink.tag.CloudIdException;
import com.tridium.cloudLink.tag.condition.BIsPointProxyTypeCondition;
import com.tridium.tagdictionary.condition.BIsTypeCondition;
import com.tridium.util.CompUtil;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.io.ValueDocDecoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;
import javax.baja.tagdictionary.BSmartTagDictionary;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.tagdictionary.BTagRule;
import javax.baja.tagdictionary.BTagRuleCondition;
import javax.baja.util.BTypeSpec;

public final class CloudLinkTagUtil {
    public static final Predicate<Entity> entityExcludedFromModel = e -> e.tags().contains(CloudLinkConstants.EXCLUDED);
    public static final Predicate<Entity> entityIncludedInModel = entityExcludedFromModel.negate();
    public static final Predicate<Relation> relationExcludedFromModel = r -> {
        Entity entity = r.getEndpoint();
        return entityExcludedFromModel.test(entity);
    };
    public static final Predicate<Relation> relationIncludedInModel = relationExcludedFromModel.negate();
    static final Logger log = Logger.getLogger("cloudLink.tag");

    public static BSmartTagDictionary getOrAddTagDictionary(String namespace, String dictionaryLocation) {
        BTagDictionaryService tagDictionaryService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
        return (BSmartTagDictionary)tagDictionaryService.getTagDictionary(namespace).orElseGet(() -> CloudLinkTagUtil.addTagDictionary(namespace, dictionaryLocation));
    }

    public static BSmartTagDictionary addTagDictionary(String namespace, String dictionaryLocation) {
        BTagDictionaryService tagDictionaryService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
        try {
            if (dictionaryLocation.endsWith(".bog")) {
                BComponent dictFolder;
                try (ValueDocDecoder docDecoder = new ValueDocDecoder(BOrd.make((String)dictionaryLocation));){
                    dictFolder = docDecoder.decodeDocument().asComponent();
                }
                return CloudLinkTagUtil.importTagDictionaries(dictFolder, namespace);
            }
            BSmartTagDictionary smartTagDictionary = (BSmartTagDictionary)BOrd.make((String)dictionaryLocation).resolve().get();
            Mark mark = new Mark((BObject)smartTagDictionary, smartTagDictionary.getName());
            mark.copyTo((BObject)tagDictionaryService, null);
            return (BSmartTagDictionary)tagDictionaryService.getTagDictionary(namespace).orElseThrow(() -> new Exception("Unable to access dictionary after copy"));
        }
        catch (Exception e) {
            String errorMessage = String.format("Unable to load tag dictionary from %s with namespace %s", dictionaryLocation, namespace);
            log.log(Level.SEVERE, errorMessage, log.isLoggable(Level.FINE) ? e : null);
            throw new RuntimeException(errorMessage, e);
        }
    }

    private static BSmartTagDictionary importTagDictionaries(BComponent dictFolder, String namespace) throws Exception {
        BTagDictionaryService tagDictionaryService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
        for (BTagDictionary dictionary : (BTagDictionary[])CompUtil.getDescendants((BComponent)dictFolder, BTagDictionary.class)) {
            if (!dictionary.getNamespace().equals(namespace)) continue;
            Mark mark = new Mark((BObject)dictionary, dictionary.getName());
            mark.copyTo((BObject)tagDictionaryService, null);
            return (BSmartTagDictionary)tagDictionaryService.getTagDictionary(namespace).orElseThrow(() -> new Exception("Unable to access dictionary after copy"));
        }
        throw new Exception("Tag dictionary with namespace [" + namespace + "] not found");
    }

    public static BTagRule makeProxyPointTagRule(String typeSpec) {
        BIsPointProxyTypeCondition condition = new BIsPointProxyTypeCondition();
        condition.setProxyExtType(BTypeSpec.make((String)typeSpec));
        BTagRule rule = new BTagRule();
        rule.setCondition((BTagRuleCondition)condition);
        return rule;
    }

    public static BTagRule makeTagRule(String typeSpec) {
        BIsTypeCondition condition = new BIsTypeCondition();
        condition.setObjectType(BTypeSpec.make((String)typeSpec));
        BTagRule rule = new BTagRule();
        rule.setCondition((BTagRuleCondition)condition);
        return rule;
    }

    public static BPropertySuppliedTag createTag(List<String> driverSlotNames) {
        BPropertySuppliedTag tag = new BPropertySuppliedTag();
        BVector v = new BVector();
        driverSlotNames.forEach(slotName -> v.add(slotName, (BValue)BString.make((String)slotName)));
        tag.setPropertyNames(v);
        return tag;
    }

    public static BPropertySuppliedTag createTag(String separator, List<String> driverSlotNames) {
        BPropertySuppliedTag tag = new BPropertySuppliedTag();
        tag.setSeparator(separator);
        BVector v = new BVector();
        driverSlotNames.forEach(slotName -> v.add(slotName, (BValue)BString.make((String)slotName)));
        tag.setPropertyNames(v);
        return tag;
    }

    public static Optional<BIDataValue> getTag(BIEntity entity, Id tagId) {
        if (entity == null) {
            return Optional.empty();
        }
        Tags tags = entity.tags();
        if (tags == null || !tags.contains(tagId)) {
            return Optional.empty();
        }
        return tags.get(tagId);
    }

    public static Optional<BIDataValue> getCloudId(BIEntity entity) {
        return CloudLinkTagUtil.getTag(entity, CloudLinkConstants.CLOUD_ID);
    }

    public static Optional<BIDataValue> getCloudId(BComponent component) {
        BValue value = component.get(CloudLinkConstants.ESCAPED_CLOUD_ID_TAG);
        if (value instanceof BIDataValue) {
            return Optional.of((BIDataValue)value);
        }
        return Optional.empty();
    }

    public static Optional<BIDataValue> getTelemetryId(BIEntity entity) {
        return CloudLinkTagUtil.getTag(entity, CloudLinkConstants.TELEMETRY_ID);
    }

    public static Optional<BIDataValue> getTelemetryId(BComponent component) {
        BValue value = component.get(CloudLinkConstants.ESCAPED_TELEMETRY_ID_TAG);
        if (value instanceof BIDataValue) {
            return Optional.of((BIDataValue)value);
        }
        return Optional.empty();
    }

    public static boolean hasTag(BIEntity entity, Id tagId) {
        return CloudLinkTagUtil.getTag(entity, tagId).isPresent();
    }

    public static boolean hasCloudId(BIEntity entity) {
        return CloudLinkTagUtil.getCloudId(entity).isPresent();
    }

    public static boolean addTag(BIEntity entity, Id tagId, BIDataValue tagValue, int slotFlags) {
        if (entity == null) {
            log.finest("addTag called with null entity");
            return false;
        }
        try {
            if (!CloudLinkTagUtil.hasTag(entity, tagId)) {
                if (entity instanceof BComponent) {
                    BComponent component = (BComponent)entity;
                    component.add(SlotPath.escape((String)tagId.getQName()), (BValue)tagValue.as(BValue.class), slotFlags | 0x4000);
                } else {
                    Tags tags = entity.tags();
                    Tag tag = new Tag(tagId, tagValue);
                    tags.set(tag);
                }
                log.finest(() -> String.format("addTag, added tag with id %s for %s on %s", tagId.getQName(), entity.getOrdToEntity().orElse(BOrd.DEFAULT).encodeToString(), Thread.currentThread().getName()));
                return true;
            }
            log.finest(() -> String.format("addTag hasTag found exiting tag with id %s for %s on %s", tagId.getQName(), entity.getOrdToEntity().orElse(BOrd.DEFAULT).encodeToString(), Thread.currentThread().getName()));
        }
        catch (Exception ex) {
            log.log(Level.INFO, String.format("Error adding tag %s to entity %s: %s", tagId.toString(), entity, ex.getMessage()), log.isLoggable(Level.FINE) ? ex : null);
            return false;
        }
        return false;
    }

    public static boolean addTag(BIEntity entity, Id tagId, BIDataValue tagValue) {
        return CloudLinkTagUtil.addTag(entity, tagId, tagValue, 0);
    }

    public static Optional<String> getCloudIdString(BIObject object) {
        if (object instanceof BIEntity) {
            return CloudLinkTagUtil.getCloudId((BIEntity)object).map(id -> {
                try {
                    return id.encodeToString();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return Optional.empty();
    }

    public static String getOrAddCloudId(BIEntity entity, Function<BIEntity, String> cloudIdFunction) {
        Objects.requireNonNull(entity);
        return CloudLinkTagUtil.getCloudId(entity).map(id -> {
            try {
                return id.encodeToString();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }).orElseGet(() -> {
            log.finest(() -> String.format("getOrAddCloudId no existing cloud id found, adding one for %s on %s", entity.getOrdToEntity().orElse(BOrd.DEFAULT).encodeToString(), Thread.currentThread().getName()));
            String id = (String)cloudIdFunction.apply(entity);
            CloudLinkTagUtil.addCloudId(entity, id);
            return id;
        });
    }

    public static void addCloudId(BIEntity entity, String cloudIdValue) {
        if (!CloudLinkTagUtil.addTag(entity, CloudLinkConstants.CLOUD_ID, (BIDataValue)BString.make((String)cloudIdValue), 24577)) {
            log.finest(() -> String.format("addCloudId, addTag returns false for %s on %s", entity.getOrdToEntity().orElse(BOrd.DEFAULT).encodeToString(), Thread.currentThread().getName()));
            throw CloudLinkTagUtil.makeCloudIdExceptionSupplier(entity).get();
        }
        log.finest(() -> String.format("addCloudId, addTag returns true for %s on %s", entity.getOrdToEntity().orElse(BOrd.DEFAULT).encodeToString(), Thread.currentThread().getName()));
    }

    public static Supplier<CloudIdException> makeCloudIdExceptionSupplier(BIEntity entity) {
        return () -> {
            Optional ordOpt = entity.getOrdToEntity();
            String msg = "nc:cloudId tag was not found";
            if (ordOpt.isPresent()) {
                msg = msg + " on entity: " + ((BOrd)ordOpt.get()).encodeToString();
            }
            return new CloudIdException(msg);
        };
    }

    private CloudLinkTagUtil() {
    }
}

