/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.security;

import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.security.BAbstractTrustMapping;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.jose4j.keys.resolvers.VerificationKeyResolver;

@NiagaraType
public class BCloudTrustManager
extends BComponent {
    public static final Type TYPE = Sys.loadType(BCloudTrustManager.class);
    private static final String TRUST_MAPPING_DISABLED = "Trust mapping disabled";
    private static final String NULL_MAPPING = "NULL";
    private final Map<Property, String> byProperty = new HashMap<Property, String>();
    private final Map<String, BAbstractTrustMapping> byAppId = new HashMap<String, BAbstractTrustMapping>();
    private static final Logger log = Logger.getLogger("cloudLink.security");

    public Type getType() {
        return TYPE;
    }

    public VerificationKeyResolver getKeyResolver(String appId) {
        BAbstractTrustMapping mapping = this.byAppId.get(appId);
        return mapping != null ? mapping.getKeyResolver() : null;
    }

    public String getExpectedAudience(String appId) {
        BAbstractTrustMapping mapping = this.byAppId.get(appId);
        return mapping != null ? mapping.getExpectedJwtAudience() : null;
    }

    public String getExpectedIssuer(String appId) {
        BAbstractTrustMapping mapping = this.byAppId.get(appId);
        return mapping != null ? mapping.getExpectedJwtIssuer() : null;
    }

    public void started() throws Exception {
        super.started();
        SlotCursor sc = this.getProperties();
        while (sc.next()) {
            BValue value = sc.get();
            if (!(value instanceof BAbstractTrustMapping)) continue;
            this.map(sc.property(), (BAbstractTrustMapping)value);
        }
    }

    public void changed(Property property, Context context) {
        BValue value;
        if (!this.isRunning() || context == CloudLinkUtils.fallbackContext) {
            return;
        }
        String oldAppId = this.byProperty.get(property);
        if (oldAppId != null) {
            this.unmap(property, oldAppId);
        }
        if ((value = this.get(property)) instanceof BAbstractTrustMapping) {
            this.map(property, (BAbstractTrustMapping)value);
        }
    }

    public void added(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        BValue value = this.get(property);
        if (value instanceof BAbstractTrustMapping) {
            this.map(property, (BAbstractTrustMapping)value);
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        BValue value = this.get(property);
        if (value instanceof BAbstractTrustMapping) {
            this.unmap(property, ((BAbstractTrustMapping)value).getAppId());
        }
    }

    private void map(Property property, BAbstractTrustMapping mapping) {
        if (property != null && mapping != null && !mapping.getAppId().isEmpty()) {
            String appId = mapping.getAppId();
            BAbstractTrustMapping existing = this.byAppId.get(appId);
            if (existing == null) {
                this.byProperty.put(property, mapping.getAppId());
                this.byAppId.put(mapping.getAppId(), mapping);
            } else {
                log.warning(() -> String.format("Duplicate trust mapping of appId %s from %s to %s rejected", new Object[]{appId, existing, mapping}));
                mapping.set(BAbstractTrustMapping.appId, (BValue)BString.make((String)""), CloudLinkUtils.fallbackContext);
            }
        }
    }

    private void unmap(Property property, String appId) {
        if (property != null && !appId.isEmpty()) {
            this.byProperty.remove(property);
            this.byAppId.remove(appId);
        }
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"CloudTrustManager", 2);
        out.startTable(true);
        out.trTitle((Object)"App Ids Mapped By Property", 2);
        out.w((Object)"<tr>").th((Object)"Trust Mapping Property").th((Object)"App Id").w((Object)"</tr>\n");
        this.byProperty.forEach((arg_0, arg_1) -> ((SpyWriter)out).tr(arg_0, arg_1));
        out.endTable();
        out.startTable(true);
        out.trTitle((Object)"App Id Mappings", 2);
        out.w((Object)"<tr>").th((Object)"App Id").th((Object)"Trust Mapping").w((Object)"</tr>\n");
        this.byAppId.forEach((key, value) -> out.tr(key, (Object)BCloudTrustManager.spyString(value)));
        out.endTable();
        out.endProps();
    }

    private static String spyString(BAbstractTrustMapping mapping) {
        if (mapping == null) {
            return NULL_MAPPING;
        }
        if (mapping.getKeyResolver() == null) {
            return TRUST_MAPPING_DISABLED;
        }
        return "expectedJwtAudience:" + mapping.getExpectedJwtAudience() + "; expectedJwtIssuer:" + mapping.getExpectedJwtIssuer() + "; keyResolver:" + mapping.getKeyResolver();
    }
}

