/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.points;

import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.channel.BPointsChannel;
import com.tridium.cloudLink.points.BPointCovExportPolicy;
import com.tridium.cloudLink.points.BPointExportPolicy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.Lexicon;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="defaultExportPolicy", type="BPointExportPolicy", defaultValue="BPointExportPolicy.make(\"station:|slot:/|neql:n:point and not \" + EXCLUDED.getQName())", flags=256), @NiagaraProperty(name="covExportPolicy", type="BPointCovExportPolicy", defaultValue="new BPointCovExportPolicy()", flags=256), @NiagaraProperty(name="maxConcurrentExportExecutions", type="int", defaultValue="10", facets={@Facet(name="BFacets.MIN", value="MIN_THREAD_POOL_SIZE")})})
@NiagaraActions(value={@NiagaraAction(name="executeAll", flags=256), @NiagaraAction(name="retryFailedExports", flags=256), @NiagaraAction(name="addPolicy")})
public class BPointExportPolicyContainer
extends BComponent {
    private static final int MIN_THREAD_POOL_SIZE = 1;
    public static final Property defaultExportPolicy = BPointExportPolicyContainer.newProperty((int)256, (BValue)BPointExportPolicy.make("station:|slot:/|neql:n:point and not " + CloudLinkConstants.EXCLUDED.getQName()), null);
    public static final Property covExportPolicy = BPointExportPolicyContainer.newProperty((int)256, (BValue)new BPointCovExportPolicy(), null);
    public static final Property maxConcurrentExportExecutions = BPointExportPolicyContainer.newProperty((int)0, (int)10, (BFacets)BFacets.make((String)"min", (int)1));
    public static final Action executeAll = BPointExportPolicyContainer.newAction((int)256, null);
    public static final Action retryFailedExports = BPointExportPolicyContainer.newAction((int)256, null);
    public static final Action addPolicy = BPointExportPolicyContainer.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BPointExportPolicyContainer.class);
    static final Logger LOGGER = Logger.getLogger("cloudLink.channel.point");
    private static final int DEFAULT_QUEUE_SIZE = 500;
    private static final int QUEUE_SIZE;
    Queue asyncWorkQueue;
    private ThreadPoolWorker worker;
    private static final Lexicon LEX;

    public BPointExportPolicy getDefaultExportPolicy() {
        return (BPointExportPolicy)this.get(defaultExportPolicy);
    }

    public void setDefaultExportPolicy(BPointExportPolicy v) {
        this.set(defaultExportPolicy, (BValue)v, null);
    }

    public BPointCovExportPolicy getCovExportPolicy() {
        return (BPointCovExportPolicy)this.get(covExportPolicy);
    }

    public void setCovExportPolicy(BPointCovExportPolicy v) {
        this.set(covExportPolicy, (BValue)v, null);
    }

    public int getMaxConcurrentExportExecutions() {
        return this.getInt(maxConcurrentExportExecutions);
    }

    public void setMaxConcurrentExportExecutions(int v) {
        this.setInt(maxConcurrentExportExecutions, v, null);
    }

    public void executeAll() {
        this.invoke(executeAll, null, null);
    }

    public void retryFailedExports() {
        this.invoke(retryFailedExports, null, null);
    }

    public void addPolicy() {
        this.invoke(addPolicy, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BPointsChannel;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BPointExportPolicy;
    }

    public void started() throws Exception {
        super.started();
        int maxPoolSize = this.getMaxConcurrentExportExecutions();
        if (maxPoolSize < 1) {
            maxPoolSize = 1;
        }
        if (this.asyncWorkQueue == null) {
            this.asyncWorkQueue = new CoalesceQueue(QUEUE_SIZE);
        }
        if (this.worker == null) {
            this.worker = new ThreadPoolWorker((Worker.ITodo)this.asyncWorkQueue);
        }
        if (!this.worker.isRunning()) {
            this.worker.setMaxThreads(maxPoolSize);
            this.worker.start("CloudHistoryExportWorker");
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        Property retryLink = this.getProperty("retryLink");
        if (retryLink != null) {
            this.remove(retryLink);
        }
        if (this.worker != null && this.worker.isRunning()) {
            try {
                this.worker.stop();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e, () -> "Unable to stop the Cloud History Export ThreadPoolWorker");
            }
        }
    }

    public void changed(Property property, Context cx) {
        if (this.isRunning() && maxConcurrentExportExecutions.equals(property) && this.worker != null) {
            int maxPoolSize = this.getMaxConcurrentExportExecutions();
            if (maxPoolSize < 1) {
                maxPoolSize = 1;
            }
            this.worker.setMaxThreads(maxPoolSize);
        }
        super.changed(property, cx);
    }

    public void doExecuteAll() {
        BPointExportPolicy[] configs;
        if (!this.isRunning()) {
            return;
        }
        for (BPointExportPolicy config : configs = (BPointExportPolicy[])this.getChildren(BPointExportPolicy.class)) {
            if (!config.getEnabled()) continue;
            config.execute();
        }
    }

    public void doRetryFailedExports() {
        BPointExportPolicy[] configs;
        if (!this.isRunning()) {
            return;
        }
        for (BPointExportPolicy config : configs = (BPointExportPolicy[])this.getChildren(BPointExportPolicy.class)) {
            if (config.isUnoperational() || !config.isFault()) continue;
            config.execute();
        }
    }

    public final BPointsChannel getChannel() {
        return (BPointsChannel)this.getParent();
    }

    public void doAddPolicy() {
        this.add(LEX.getText("points.export.name") + '?', (BValue)BPointExportPolicy.make(new String[0]));
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning() && this.worker != null) {
            this.worker.spy(out);
        }
        super.spy(out);
    }

    static {
        int size = Integer.getInteger("cloudLink.historyExport.workerQueueSize", 500);
        if (size < 1) {
            size = 500;
        }
        QUEUE_SIZE = size;
        LEX = Lexicon.make(BPointExportPolicyContainer.class);
    }
}

