/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.model;

import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.channel.BAbstractModelChannelConfig;
import com.tridium.cloudLink.channel.BModelChannel;
import com.tridium.cloudLink.model.BModelExportPolicyContainer;
import com.tridium.cloudLink.model.BModelIngestionStatus;
import com.tridium.cloudLink.msg.IGetModelIngestionStatusHandler;
import com.tridium.cloudLink.msg.IModelIngestStatusResult;
import com.tridium.cloudLink.util.BRunnableNamedJob;
import com.tridium.util.ThrowableUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Relation;
import javax.baja.util.BFormat;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BManualTriggerMode.make())", flags=5, override=true), @NiagaraProperty(name="modelStatus", type="BModelIngestionStatus", defaultValue="new BModelIngestionStatus()"), @NiagaraProperty(name="alarmOnFailure", type="boolean", defaultValue="true"), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="singleJob", type="BBoolean", defaultValue="BBoolean.TRUE", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4), @NiagaraAction(name="checkModelStatus", flags=4)})
public abstract class BModelExportPolicy
extends BAbstractDescriptor
implements BIAlarmSource,
Iterator<Object>,
BIRestrictedComponent {
    public static final Property executionTime = BModelExportPolicy.newProperty((int)5, (BValue)new BTimeTrigger((BTriggerMode)BManualTriggerMode.make()), null);
    public static final Property modelStatus = BModelExportPolicy.newProperty((int)0, (BValue)new BModelIngestionStatus(), null);
    public static final Property alarmOnFailure = BModelExportPolicy.newProperty((int)0, (boolean)true, null);
    public static final Property alarmSourceInfo = BModelExportPolicy.newProperty((int)0, (BValue)BModelExportPolicy.initAlarmSourceInfo(), null);
    public static final Property singleJob = BModelExportPolicy.newProperty((int)5, (boolean)((BBoolean)BBoolean.TRUE.as(BBoolean.class)).getBoolean(), null);
    public static final Action ackAlarm = BModelExportPolicy.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action checkModelStatus = BModelExportPolicy.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BModelExportPolicy.class);
    protected static final Logger log = Logger.getLogger("cloudLink.channel.model.exportPolicy");
    protected static final AtomicBoolean jobRunning = new AtomicBoolean();
    private static final Lexicon lex = Lexicon.make((String)"cloudLink");
    private AlarmSupport alarmSupport;
    protected BJob job;
    protected Context context;
    private Clock.Ticket modelCheckTicket;
    private BAbsTime modelSendTime = BAbsTime.DEFAULT;
    private boolean modelStatusCheckFailed = false;
    private static final BRelTime MODEL_CHECK_DELAY = BRelTime.makeSeconds((int)5);
    private static final BRelTime MODEL_CHECK_INTERVAL = BRelTime.makeMinutes((int)1);

    public BModelIngestionStatus getModelStatus() {
        return (BModelIngestionStatus)this.get(modelStatus);
    }

    public void setModelStatus(BModelIngestionStatus v) {
        this.set(modelStatus, (BValue)v, null);
    }

    public boolean getAlarmOnFailure() {
        return this.getBoolean(alarmOnFailure);
    }

    public void setAlarmOnFailure(boolean v) {
        this.setBoolean(alarmOnFailure, v, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    public boolean getSingleJob() {
        return this.getBoolean(singleJob);
    }

    public void setSingleJob(boolean v) {
        this.setBoolean(singleJob, v, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public void checkModelStatus() {
        this.invoke(checkModelStatus, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BModelExportPolicy() {
    }

    public void started() throws Exception {
        super.started();
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
    }

    public void changed(Property p, Context cx) {
        BJob job;
        if (!this.isRunning()) {
            return;
        }
        super.changed(p, cx);
        if (p.equals(status) && this.getStatus().isDisabled() && jobRunning.get() && (job = this.getJob()) != null && job.isAlive()) {
            job.log().message("cloudLink", "model.modelExportJob.canceledByDisabled");
            job.cancel();
        }
    }

    public abstract Predicate<BComponent> getComponentTypeIncludedInModel();

    public abstract Predicate<Relation> getRelationTypeIncludeInModel();

    public void doExecute() {
        try {
            if (!this.isRunning()) {
                return;
            }
            BModelChannel channel = this.getChannel();
            if (channel == null) {
                log.info("Model export policy execution failed; model channel not found.");
                return;
            }
            this.job.log().message("cloudLink", "model.export.start");
            this.job.setJobState(BJobState.running);
            this.executeInProgress();
            this.initialize();
            ((CompletableFuture)channel.sendModel(this).handle((result, exception) -> {
                if (exception != null) {
                    if (exception instanceof InterruptedException) {
                        this.handleInterruptedException((InterruptedException)exception);
                    } else {
                        this.handleException((Throwable)exception);
                    }
                } else {
                    this.handleSuccess((Map<String, Object>)result);
                }
                return null;
            })).join();
        }
        finally {
            if (this.getSingleJob()) {
                jobRunning.getAndSet(false);
            }
            this.job = null;
            this.context = null;
            this.cleanup();
        }
    }

    public void doCheckModelStatus() {
        log.fine("Checking Model Ingestion status");
        try {
            BModelChannel channel = this.getChannel();
            if (channel == null) {
                this.modelStatusCheckFailed = true;
                throw new IllegalStateException(String.format("Unable to locate channel: %s", "model"));
            }
            BAbstractModelChannelConfig config = (BAbstractModelChannelConfig)channel.getChannelConfig().as(BAbstractModelChannelConfig.class);
            IModelIngestStatusResult result = config.checkModelIngestionStatus(channel.getConnectionService().orElseThrow(() -> {
                this.modelStatusCheckFailed = true;
                return new IllegalStateException("Unable to locate Cloud Connection Service.");
            })).get(15L, TimeUnit.SECONDS);
            switch (result.getState().getOrdinal()) {
                case 0: {
                    this.getModelStatus().ok();
                    if (this.modelCheckTicket != null) {
                        this.modelCheckTicket.cancel();
                    }
                    this.modelCheckTicket = null;
                    break;
                }
                case 1: {
                    this.getModelStatus().fail();
                    if (this.modelCheckTicket != null) {
                        this.modelCheckTicket.cancel();
                    }
                    this.modelCheckTicket = null;
                    break;
                }
                case 2: {
                    this.getModelStatus().setStatusMessage(lex.getText("modelStatus.ingesting", new Object[]{BRelTime.make((long)(BAbsTime.now().getMillis() - this.modelSendTime.getMillis()))}));
                }
            }
        }
        catch (Exception checkFailed) {
            if (this.modelStatusCheckFailed) {
                log.log(Level.FINE, String.format("Cannot check model ingestion status:%s", checkFailed.getMessage()), checkFailed);
                if (this.modelCheckTicket != null) {
                    this.modelCheckTicket.cancel();
                }
                this.modelCheckTicket = null;
                this.getModelStatus().setStatusMessage(lex.getText("modelStatus.checkFailed"));
            }
            log.log(Level.FINE, String.format("Model ingestion status check failed:%s", checkFailed.getMessage()), checkFailed);
            this.modelStatusCheckFailed = true;
        }
    }

    protected void handleInterruptedException(InterruptedException interExcept) {
        this.executeFail(lex.get("model.export.canceled"));
        this.job.canceled();
    }

    protected void handleException(Throwable except) {
        log.log(Level.WARNING, "Unable to process the model: " + except.getMessage(), log.isLoggable(Level.FINE) ? except : null);
        this.executeFail(ThrowableUtil.dumpToString((Throwable)except, (int)1));
        this.job.failed(except);
    }

    protected void handleSuccess(Map<String, Object> resultMap) {
        this.executeOk();
        this.modelExported(resultMap);
        this.job.log().message("cloudLink", "model.export.finish");
        this.job.success();
    }

    public final BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        BBoolean alarmAck = BBoolean.make((boolean)BModelExportPolicy.processAlarmAck(this.alarmSupport, ackRequest));
        if (alarmAck.getBoolean()) {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
        }
        return alarmAck;
    }

    public void updateStatus() {
        int newStatus = this.getStatus().getBits();
        BModelChannel channel = this.getChannel();
        newStatus = !this.getEnabled() || channel != null && channel.getStatus().isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = !this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess()) ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.getStatus().getBits()) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    public void executeOk() {
        if (this.getStatus().isAlarm()) {
            BModelExportPolicy.processAlarmNormal(this.alarmSupport);
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
        }
        super.executeOk();
    }

    private void modelExported(Map<String, Object> resultMap) {
        boolean modelUploaded = (Boolean)resultMap.getOrDefault("uploadModelFile", true);
        if (modelUploaded) {
            this.getModelStatus().modelSent();
            BModelChannel channel = this.getChannel();
            if (channel != null && channel.getChannelConfig().isOperationSupported(IGetModelIngestionStatusHandler.getOperationId())) {
                this.modelStatusCheckFailed = false;
                this.modelSendTime = BAbsTime.now();
                this.modelCheckTicket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)this.modelSendTime.add(MODEL_CHECK_DELAY), (BRelTime)MODEL_CHECK_INTERVAL, (Action)checkModelStatus, null);
            } else {
                this.modelStatusCheckFailed = false;
                this.modelSendTime = BAbsTime.now();
                this.modelCheckTicket = null;
                this.getModelStatus().setStatusMessage(lex.getText("modelStatus.notSupported"));
            }
        } else {
            this.getModelStatus().skipped();
        }
    }

    public final void executeFail(String reason) {
        if (this.getAlarmOnFailure() && !this.getStatus().isAlarm()) {
            if (reason == null) {
                reason = "";
            }
            boolean ackRequired = BModelExportPolicy.processAlarmOffnormal(this.alarmSupport, this.getAlarmSourceInfo(), reason);
            int newStatus = this.getStatus().getBits();
            newStatus |= 8;
            if (ackRequired) {
                newStatus |= 0x80;
            }
            this.setStatus(BStatus.make((int)newStatus));
        }
        this.getModelStatus().notSent();
        super.executeFail(reason);
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        if (this.getSingleJob() && jobRunning.getAndSet(true)) {
            String msg = "Unable to start model processing. A model job is already in progress.";
            log.warning(msg);
            this.executeFail(msg);
            return null;
        }
        try {
            this.context = cx;
            this.job = this.makeJob(new Invocation((BComponent)this, action, arg, cx));
            this.job.submit(cx);
            log.fine("Model export job started");
        }
        catch (Exception ex) {
            String msg = "Unable to start model processing. An error occurred while submitting the job.";
            log.log(Level.WARNING, msg, log.isLoggable(Level.FINE) ? ex : null);
            if (this.getSingleJob()) {
                jobRunning.getAndSet(false);
            }
            this.job = null;
            this.context = null;
            this.executeFail(msg);
        }
        return null;
    }

    protected BJob makeJob(Invocation invocation) {
        BRunnableNamedJob namedJob = new BRunnableNamedJob((Runnable)invocation, 1);
        namedJob.setJobName(lex.get("model.modelExportJob.name"));
        return namedJob;
    }

    static void processAlarmNormal(AlarmSupport support) {
        try {
            support.toNormal(null);
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Cannot process Normal alarm: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    public static boolean processAlarmOffnormal(AlarmSupport support, BAlarmSourceInfo info, String reason) {
        boolean ackRequired = false;
        try {
            ackRequired = support.isAckRequired(BSourceState.offnormal);
            BFacets alarmData = info.makeAlarmData(BSourceState.offnormal);
            String msgText = alarmData.gets("msgText", "");
            alarmData = BFacets.make((BFacets)alarmData, (String)"msgText", (BIDataValue)BString.make((String)(msgText + '\n' + reason)));
            support.newOffnormalAlarm(alarmData);
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Cannot process off normal alarm: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
        }
        return ackRequired;
    }

    static boolean processAlarmAck(AlarmSupport support, BAlarmRecord ackRequest) {
        try {
            return support.ackAlarm(ackRequest);
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Cannot process alarm ack: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            return false;
        }
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"CloudLink %parent.parent.parent.displayName% %parent.displayName%"));
        return asi;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BModelExportPolicyContainer;
    }

    public final BModelExportPolicyContainer getPolicyContainer() {
        return (BModelExportPolicyContainer)this.getParent();
    }

    protected abstract void initialize();

    protected abstract void cleanup();

    protected BModelChannel getChannel() {
        BComplex parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof BModelChannel); parent = parent.getParent()) {
        }
        return (BModelChannel)parent;
    }

    public BJob getJob() {
        return this.job;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        CloudLinkUtils.checkParentForDuplicates(parent, (BComponent)this, BModelExportPolicyContainer.TYPE, false, cx);
    }
}

