/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.history;

import com.tridium.cloudLink.channel.BHistoriesChannel;
import com.tridium.cloudLink.history.BCloudHistoryAutoExportConfig;
import com.tridium.cloudLink.history.BCloudHistoryExportConfig;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="maxConcurrentExportExecutions", type="int", defaultValue="10", facets={@Facet(name="BFacets.MIN", value="MIN_THREAD_POOL_SIZE")}), @NiagaraProperty(name="retryTrigger", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeMinutes(15)))"), @NiagaraProperty(name="autoExport", type="BCloudHistoryAutoExportConfig", defaultValue="new BCloudHistoryAutoExportConfig()")})
@NiagaraActions(value={@NiagaraAction(name="executeAll"), @NiagaraAction(name="retryFailedExports")})
public final class BCloudHistoryExportConfigContainer
extends BComponent {
    private static final int MIN_THREAD_POOL_SIZE = 2;
    public static final Property maxConcurrentExportExecutions = BCloudHistoryExportConfigContainer.newProperty((int)0, (int)10, (BFacets)BFacets.make((String)"min", (int)2));
    public static final Property retryTrigger = BCloudHistoryExportConfigContainer.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)15))), null);
    public static final Property autoExport = BCloudHistoryExportConfigContainer.newProperty((int)0, (BValue)new BCloudHistoryAutoExportConfig(), null);
    public static final Action executeAll = BCloudHistoryExportConfigContainer.newAction((int)0, null);
    public static final Action retryFailedExports = BCloudHistoryExportConfigContainer.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BCloudHistoryExportConfigContainer.class);
    static final Logger LOGGER = Logger.getLogger("cloudLink.channel.history");
    private static final int DEFAULT_QUEUE_SIZE = 500;
    private static final int QUEUE_SIZE;
    Queue asyncWorkQueue;
    private ThreadPoolWorker worker;

    public int getMaxConcurrentExportExecutions() {
        return this.getInt(maxConcurrentExportExecutions);
    }

    public void setMaxConcurrentExportExecutions(int v) {
        this.setInt(maxConcurrentExportExecutions, v, null);
    }

    public BTimeTrigger getRetryTrigger() {
        return (BTimeTrigger)this.get(retryTrigger);
    }

    public void setRetryTrigger(BTimeTrigger v) {
        this.set(retryTrigger, (BValue)v, null);
    }

    public BCloudHistoryAutoExportConfig getAutoExport() {
        return (BCloudHistoryAutoExportConfig)this.get(autoExport);
    }

    public void setAutoExport(BCloudHistoryAutoExportConfig v) {
        this.set(autoExport, (BValue)v, null);
    }

    public void executeAll() {
        this.invoke(executeAll, null, null);
    }

    public void retryFailedExports() {
        this.invoke(retryFailedExports, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BHistoriesChannel;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BCloudHistoryExportConfig;
    }

    public void started() throws Exception {
        super.started();
        BTimeTrigger t = this.getRetryTrigger();
        this.linkTo("retryLink", (BComponent)t, (Slot)BTimeTrigger.fireTrigger, (Slot)retryFailedExports);
        int maxPoolSize = this.getMaxConcurrentExportExecutions();
        if (maxPoolSize < 2) {
            maxPoolSize = 2;
        }
        if (this.asyncWorkQueue == null) {
            this.asyncWorkQueue = new CoalesceQueue(QUEUE_SIZE);
        }
        if (this.worker == null) {
            this.worker = new ThreadPoolWorker((Worker.ITodo)this.asyncWorkQueue);
        }
        if (!this.worker.isRunning()) {
            this.worker.setMaxThreads(maxPoolSize);
            this.worker.start("CloudHistoryExportWorker");
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        Property retryLink = this.getProperty("retryLink");
        if (retryLink != null) {
            this.remove(retryLink);
        }
        if (this.worker != null && this.worker.isRunning()) {
            try {
                this.worker.stop();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e, () -> "Unable to stop the Cloud History Export ThreadPoolWorker");
            }
        }
    }

    public void changed(Property property, Context cx) {
        if (this.isRunning() && maxConcurrentExportExecutions.equals(property) && this.worker != null) {
            int maxPoolSize = this.getMaxConcurrentExportExecutions();
            if (maxPoolSize < 2) {
                maxPoolSize = 2;
            }
            this.worker.setMaxThreads(maxPoolSize);
        }
        super.changed(property, cx);
    }

    public void doExecuteAll() {
        BCloudHistoryExportConfig[] configs;
        if (!this.isRunning()) {
            return;
        }
        for (BCloudHistoryExportConfig config : configs = (BCloudHistoryExportConfig[])this.getChildren(BCloudHistoryExportConfig.class)) {
            if (!config.getEnabled()) continue;
            config.execute();
        }
    }

    public void doRetryFailedExports() {
        BCloudHistoryExportConfig[] configs;
        if (!this.isRunning()) {
            return;
        }
        for (BCloudHistoryExportConfig config : configs = (BCloudHistoryExportConfig[])this.getChildren(BCloudHistoryExportConfig.class)) {
            if (config.isUnoperational() || !config.isFault() || !config.retryReady()) continue;
            config.execute();
        }
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning() && this.worker != null) {
            this.worker.spy(out);
        }
        super.spy(out);
    }

    static {
        int size = Integer.getInteger("cloudLink.historyExport.workerQueueSize", 500);
        if (size < 1) {
            size = 500;
        }
        QUEUE_SIZE = size;
    }
}

