/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import com.tridium.cloudLink.command.BCommand;
import com.tridium.cloudLink.msg.WriteAlarmResult;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BUuid;

@NiagaraType
public abstract class BWriteAlarmCommand
extends BCommand {
    public static final Type TYPE = Sys.loadType(BWriteAlarmCommand.class);
    protected AlarmDbConnection alarmDbConn;
    private BAlarmService alarmService;
    public static final String SUCCESS = "Success";

    @Override
    public Type getType() {
        return TYPE;
    }

    protected void openSession(Context cx) {
        if (this.alarmDbConn == null) {
            this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            this.alarmDbConn = this.alarmService.getAlarmDb().getDbConnection(cx);
        }
    }

    protected void closeSession() {
        if (this.alarmDbConn != null) {
            this.alarmDbConn.close();
            this.alarmDbConn = null;
            this.alarmService = null;
        }
    }

    protected Map<String, WriteAlarmResult> writeAlarmData(String messageId, String alarmId, String appId, String appName, JSONObject alarmDataItems, Context cx) throws AlarmWriteException {
        BAlarmRecord alarmRecord;
        BUuid uuid;
        if (this.alarmDbConn == null) {
            log.info("A session must be started, to open an alarm database connection, prior to writing alarm data. Message Id: " + messageId);
            throw new IllegalStateException("OpenSession() must be called prior to writeAlarmData().");
        }
        if (cx == null || cx.getUser() == null) {
            log.info("A context containing user information must be provided to write alarm data. Message Id: " + messageId);
            throw new IllegalStateException("A non-null context with a user must be provided.");
        }
        if (alarmId == null || alarmId.isEmpty()) {
            log.info("Alarm data was not updated because the alarm id was not provided. Message Id: " + messageId);
            throw new AlarmWriteException("The alarm id was not provided.");
        }
        try {
            uuid = BUuid.make((String)alarmId);
        }
        catch (BajaRuntimeException except) {
            log.log(Level.INFO, "Alarm data was not updated because the alarm id " + alarmId + " has invalid format. Message Id: " + messageId, log.isLoggable(Level.FINE) ? except : null);
            throw new AlarmWriteException("The alarm id has invalid format.");
        }
        HashMap<String, WriteAlarmResult> resultsMap = new HashMap<String, WriteAlarmResult>();
        if (alarmDataItems == null || alarmDataItems.isEmpty()) {
            log.info("Alarm data was not updated because the data items for alarm id " + alarmId + " were not provided. Message Id:" + messageId);
            throw new AlarmWriteException("Alarm data items were not provided.");
        }
        try {
            alarmRecord = this.alarmDbConn.getRecord(uuid);
            if (alarmRecord == null) {
                log.info(() -> "Alarm data was not updated because the alarm with id " + alarmId + "was not found. Message Id: " + messageId);
                throw new AlarmWriteException("The alarm was not found.");
            }
            BUser user = cx.getUser();
            if (!BWriteAlarmCommand.hasAlarmWritePermissions(this.alarmService, alarmRecord, user)) {
                log.warning(() -> String.format("Alarm data was not updated for alarm with id %s due to insufficient permission for user %s, message id %s", alarmId, user.getUsername(), messageId));
                throw new AlarmWriteException("Insufficient permission to write alarm data.");
            }
        }
        catch (IOException ioExcept) {
            log.log(Level.INFO, "Alarm data for alarm id " + alarmId + " was could not updated because an error occurred while retrieving the alarm record. Message Id: " + messageId, log.isLoggable(Level.FINE) ? ioExcept : null);
            throw new AlarmWriteException("An error occurred while retrieving the alarm.");
        }
        try {
            Iterator it = alarmDataItems.keys();
            while (it.hasNext()) {
                WriteAlarmResult result;
                String key = (String)it.next();
                if (key.equals("notes")) {
                    result = this.updateNotes(alarmRecord, alarmDataItems.opt(key), appName, appId, cx);
                    resultsMap.put(key, result);
                    this.alarmDbConn.update(alarmRecord);
                    this.alarmService.routeAlarm(alarmRecord);
                    continue;
                }
                result = new WriteAlarmResult(false, "Unsupported alarm data key.");
                resultsMap.put(key, result);
            }
        }
        catch (IOException ioExcept) {
            log.log(Level.INFO, "Alarm data for alarm id " + alarmId + " was could not updated because an error occurred while updating the alarm data. Message Id: " + messageId, log.isLoggable(Level.FINE) ? ioExcept : null);
            throw new AlarmWriteException("An error occurred while updating the alarm.");
        }
        return resultsMap;
    }

    WriteAlarmResult updateNotes(BAlarmRecord alarmRecord, Object notes, String appId, String appName, Context cx) throws IOException {
        if (!(notes instanceof String)) {
            return new WriteAlarmResult(false, "Alarm notes must be of type String.");
        }
        String newNotes = (String)notes;
        BFacets alarmData = alarmRecord.getAlarmData();
        String oldNotes = "";
        if (alarmData.get("notes") != null) {
            oldNotes = alarmData.get("notes").toString(cx);
        }
        BAbsTime notesTime = BAbsTime.now();
        String notesFacetValue = "## " + notesTime + " - " + appId + ' ' + appName + " ##\n" + newNotes + "\n\n" + oldNotes;
        BFacets facets = BFacets.make((BFacets)alarmData, (BFacets)BFacets.make((String)"notes", (BIDataValue)BString.make((String)notesFacetValue)));
        alarmRecord.setAlarmData(facets);
        alarmRecord.setLastUpdate(notesTime);
        return new WriteAlarmResult(true, SUCCESS);
    }

    private static boolean hasAlarmWritePermissions(BAlarmService alarmService, BAlarmRecord alarmRec, BUser user) {
        BAlarmClass alarmClass = alarmService.lookupAlarmClass(alarmRec.getAlarmClass());
        BPermissions permissions = user.getPermissionsFor((BIProtected)alarmClass);
        return permissions.hasOperatorWrite() || permissions.hasAdminWrite();
    }

    public static class AlarmWriteException
    extends Exception {
        private static final long serialVersionUID = 1598027978563263462L;

        public AlarmWriteException(String message) {
            super(message);
        }
    }
}

