/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.transport.HttpResponseMessage;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public final class FederatedIdentityOcspResponse {
    private final int statusCode;
    private final SingleResp[] responses;
    private static final SingleResp[] EMPTY_RESPONSES = new SingleResp[0];

    public FederatedIdentityOcspResponse(HttpResponseMessage message, X509Certificate issuer) throws Exception {
        this.statusCode = message.getStatusCode();
        if (this.statusCode != 200) {
            this.responses = EMPTY_RESPONSES;
            return;
        }
        OCSPResp response = new OCSPResp(message.getPayload());
        Object responseObj = response.getResponseObject();
        if (response.getStatus() == 0 && responseObj instanceof BasicOCSPResp) {
            BasicOCSPResp ocspResponseData = (BasicOCSPResp)responseObj;
            FederatedIdentityOcspResponse.validateOcspSignature(ocspResponseData, issuer);
            this.responses = ocspResponseData.getResponses();
        } else {
            this.responses = EMPTY_RESPONSES;
        }
    }

    public CertificateStatus getCertStatus(CertificateID certificateID) {
        for (SingleResp resp : this.responses) {
            if (!resp.getCertID().equals((Object)certificateID)) continue;
            return resp.getCertStatus();
        }
        return new UnknownStatus();
    }

    private static void validateOcspSignature(BasicOCSPResp basicResp, X509Certificate issuer) throws Exception {
        X509CertificateHolder signerHolder = basicResp.getCerts()[0];
        if (!basicResp.isSignatureValid(new JcaContentVerifierProviderBuilder().build(signerHolder))) {
            throw new Exception("Invalid signature in OCSP response");
        }
        X509Certificate signer = new JcaX509CertificateConverter().getCertificate(signerHolder);
        List<String> extendedKeyUsage = signer.getExtendedKeyUsage();
        if (extendedKeyUsage == null || !extendedKeyUsage.contains(KeyPurposeId.id_kp_OCSPSigning.getId())) {
            throw new Exception("OCSP signer does not include OCSP signing extended key usage");
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
        for (X509CertificateHolder holder : basicResp.getCerts()) {
            certList.add(converter.getCertificate(holder));
        }
        Set<TrustAnchor> trustAnchors = Collections.singleton(new TrustAnchor(issuer, null));
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        CertPath path = fact.generateCertPath(certList);
        CertPathValidator validator = CertPathValidator.getInstance("PKIX");
        PKIXParameters params = new PKIXParameters(trustAnchors);
        params.setRevocationEnabled(false);
        validator.validate(path, params);
    }
}

