/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class FederatedIdentityOcspRequest
implements IMessageBuilder {
    private CertificateID certificateID;
    private final X509Certificate cert;
    private final X509Certificate issuer;
    private static final Logger log = Logger.getLogger("cloudLink.auth.federated");

    public FederatedIdentityOcspRequest(X509Certificate cert, X509Certificate issuer) {
        this.cert = cert;
        this.issuer = issuer;
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        try {
            URL ocspUrl;
            byte[] extensionBytes = this.cert.getExtensionValue(Extension.authorityInfoAccess.getId());
            AuthorityInformationAccess infoAccess = AuthorityInformationAccess.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])extensionBytes));
            AccessDescription[] descriptions = infoAccess.getAccessDescriptions();
            if (descriptions == null || descriptions.length == 0) {
                log.info("Unable to get access description with OCSP server.");
                return null;
            }
            try {
                ocspUrl = new URL(descriptions[0].getAccessLocation().getName().toString());
            }
            catch (MalformedURLException ex) {
                log.log(Level.INFO, "Unable to build URL for OCSP server", log.isLoggable(Level.FINE) ? ex : null);
                return null;
            }
            DigestCalculatorProvider calculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder().setProvider("BC").build();
            this.certificateID = new CertificateID(calculatorProviderBuilder.get(CertificateID.HASH_SHA1), (X509CertificateHolder)new JcaX509CertificateHolder(this.issuer), this.cert.getSerialNumber());
            OCSPReqBuilder requestGenerator = new OCSPReqBuilder();
            requestGenerator.addRequest(this.certificateID);
            BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
            Extension ext = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, true, (ASN1OctetString)new DEROctetString(nonce.toByteArray()));
            requestGenerator.setRequestExtensions(new Extensions(new Extension[]{ext}));
            OCSPReq ocspRequest = requestGenerator.build();
            String correlationId = UUID.randomUUID().toString();
            log.config(() -> "Sending OCSP request with correlation " + correlationId);
            return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, ocspUrl, Collections.singletonMap("x-activity-id", correlationId)).mimeType("application/ocsp-request").body(ocspRequest.getEncoded()).build();
        }
        catch (IOException | CertificateEncodingException | OCSPException | OperatorCreationException ex) {
            log.log(Level.INFO, "Error building OCSP request", log.isLoggable(Level.FINE) ? ex : null);
            return null;
        }
    }

    public CertificateID getCertificateID() {
        return this.certificateID;
    }
}

