/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.json.JSONObject;
import java.util.List;
import java.util.logging.Logger;

public class FederatedIdentityDeviceUuidResponse {
    protected static final Logger log = Logger.getLogger("cloudLink.auth.federated");
    private final int statusCode;
    private String deviceUuid;
    private static final String DEVICE_UUID = "deviceUuid";
    public static final String DEVICE_UUID_ERROR_MSG_TEMPLATE = "Federated Identity Device UUID response body is not in %s format, response body is %s";

    public FederatedIdentityDeviceUuidResponse(HttpResponseMessage message) {
        this.statusCode = message.getStatusCode();
        List<String> headers = message.getHeaders().get("content-type");
        if (headers == null || !headers.contains("application/json")) {
            log.config(() -> String.format(DEVICE_UUID_ERROR_MSG_TEMPLATE, "application/json", message.getBodyAsString()));
            return;
        }
        JSONObject data = new JSONObject(message.getBodyAsString());
        Object tmp = data.opt(DEVICE_UUID);
        this.deviceUuid = tmp == null || tmp == JSONObject.NULL ? null : tmp.toString();
        log.finest(() -> String.format("Federated Identity Device UUID response status = %d, Device UUID = %s", this.statusCode, this.deviceUuid));
    }

    public boolean isSuccessful() {
        return this.statusCode == 200 && this.deviceUuid != null && !this.deviceUuid.isEmpty();
    }

    public String getDeviceUuid() {
        return this.deviceUuid;
    }
}

