/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FederatedIdentityBootstrapRequest
implements IMessageBuilder {
    private final String stationName;
    private final String hostId;
    private final String federatedIdentityHost;
    private static final Logger log = Logger.getLogger("cloudLink.auth.federated");
    private static final String HOST_ID = "niagaraHostId";
    private static final String EXISTS = "niagaraStationExists";
    private static final String STATION_NAME = "niagaraStationName";
    private static final String API_PATH = "/api/v1/deviceregistration/init";

    public FederatedIdentityBootstrapRequest(String server, String name, String hostId) {
        this.stationName = name;
        this.hostId = hostId;
        this.federatedIdentityHost = server;
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        StringWriter stringWriter = new StringWriter();
        JSONWriter jsonSerializer = QuickJSONWriter.make((Appendable)stringWriter);
        jsonSerializer.object();
        jsonSerializer.key(HOST_ID).value((Object)this.hostId);
        jsonSerializer.key(EXISTS).value(this.stationName != null && !this.stationName.isEmpty());
        jsonSerializer.key(STATION_NAME).value((Object)this.stationName);
        jsonSerializer.endObject();
        stringWriter.flush();
        URL url = null;
        try {
            url = new URL("https://" + this.federatedIdentityHost + API_PATH);
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for federated identity init bootstrap", log.isLoggable(Level.FINE) ? ex : null);
        }
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending init bootstrap message with correlation " + correlationId);
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, url, Collections.singletonMap("x-activity-id", correlationId)).mimeType("application/json").body(stringWriter.getBuffer().toString()).build();
    }
}

