/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.auth.BClientAuthenticatorsFolder;
import com.tridium.cloudLink.auth.BFedIdAuthenticationState;
import com.tridium.cloudLink.auth.BFedIdRegistrationState;
import com.tridium.cloudLink.auth.FederatedIdentityBootstrapRequest;
import com.tridium.cloudLink.auth.FederatedIdentityBootstrapResponse;
import com.tridium.cloudLink.auth.FederatedIdentityCsrRequest;
import com.tridium.cloudLink.auth.FederatedIdentityCsrResponse;
import com.tridium.cloudLink.auth.FederatedIdentityDeviceProvisioningInfoRequest;
import com.tridium.cloudLink.auth.FederatedIdentityDeviceProvisioningInfoResponse;
import com.tridium.cloudLink.auth.FederatedIdentityDeviceUuidRequest;
import com.tridium.cloudLink.auth.FederatedIdentityDeviceUuidResponse;
import com.tridium.cloudLink.auth.FederatedIdentityOcspRequest;
import com.tridium.cloudLink.auth.FederatedIdentityOcspResponse;
import com.tridium.cloudLink.auth.RsaKeyPairGeneratorSupplier;
import com.tridium.cloudLink.channel.BMessagingChannel;
import com.tridium.cloudLink.channel.BTransportConfig;
import com.tridium.cloudLink.provisioning.BCloudLinkProvisioning;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.cloudLink.transport.HttpStatusException;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.util.BICachingCertificateConsumer;
import com.tridium.cloudLink.util.BIDevConfigurer;
import com.tridium.cloudLink.util.CertificateAliasAndPasswordWrapper;
import com.tridium.cloudLink.util.IValueWrapper;
import com.tridium.cloudLink.util.StringWrapper;
import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NCertificateParameters;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.security.SecretChars;
import com.tridium.util.CompUtil;
import java.io.IOException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.security.crypto.ITrustStore;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.Lexicon;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.jetbrains.annotations.NotNull;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="registrationState", type="BFedIdRegistrationState", defaultValue="BFedIdRegistrationState.DEFAULT", flags=257), @NiagaraProperty(name="authenticationState", type="BFedIdAuthenticationState", defaultValue="BFedIdAuthenticationState.DEFAULT", flags=259), @NiagaraProperty(name="authenticatorId", type="BString", defaultValue="BString.make(AUTH_PLATFORM_TYPE_FEDERATED)", flags=1, override=true), @NiagaraProperty(name="userCode", type="String", defaultValue="", flags=3), @NiagaraProperty(name="deviceCode", type="String", defaultValue="", flags=7), @NiagaraProperty(name="userRegistrationUrl", type="BOrd", defaultValue="BOrd.NULL", flags=3), @NiagaraProperty(name="codeExpiration", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=3), @NiagaraProperty(name="registrationHost", type="BString", defaultValue="BString.DEFAULT", flags=5), @NiagaraProperty(name="deviceUuidDelay", type="BRelTime", defaultValue="BRelTime.make(10000)", flags=5), @NiagaraProperty(name="hostId", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="provisioning", type="BCloudLinkProvisioning", defaultValue="BCloudLinkProvisioning.DEFAULT", flags=5), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="statusMessage", type="String", defaultValue="", flags=259), @NiagaraProperty(name="certificatePassword", type="BPassword", defaultValue="BPassword.make(\"\")", flags=64, facets={@Facet(name="BPassword.PLACEHOLDER_TEXT", value="\"%lexicon(workbench:default.password.placeholder.label)%\""), @Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
@NiagaraActions(value={@NiagaraAction(name="startRegistration", flags=257), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
@NiagaraTopic(name="certificateUpdate", eventType="BString", flags=4)
public class BFederatedIdentityAuthenticator
extends BAbstractClientAuthenticator
implements BIAlarmSource {
    public static final Property registrationState = BFederatedIdentityAuthenticator.newProperty((int)257, (BValue)BFedIdRegistrationState.DEFAULT, null);
    public static final Property authenticationState = BFederatedIdentityAuthenticator.newProperty((int)259, (BValue)BFedIdAuthenticationState.DEFAULT, null);
    public static final Property authenticatorId = BFederatedIdentityAuthenticator.newProperty((int)1, (BValue)BString.make((String)"FederatedIdentity"), null);
    public static final Property userCode = BFederatedIdentityAuthenticator.newProperty((int)3, (String)"", null);
    public static final Property deviceCode = BFederatedIdentityAuthenticator.newProperty((int)7, (String)"", null);
    public static final Property userRegistrationUrl = BFederatedIdentityAuthenticator.newProperty((int)3, (BValue)BOrd.NULL, null);
    public static final Property codeExpiration = BFederatedIdentityAuthenticator.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    public static final Property registrationHost = BFederatedIdentityAuthenticator.newProperty((int)5, (BValue)BString.DEFAULT, null);
    public static final Property deviceUuidDelay = BFederatedIdentityAuthenticator.newProperty((int)5, (BValue)BRelTime.make((long)10000L), null);
    public static final Property hostId = BFederatedIdentityAuthenticator.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Property provisioning = BFederatedIdentityAuthenticator.newProperty((int)5, (BValue)BCloudLinkProvisioning.DEFAULT, null);
    public static final Property alarmSourceInfo = BFederatedIdentityAuthenticator.newProperty((int)0, (BValue)BFederatedIdentityAuthenticator.initAlarmSourceInfo(), null);
    public static final Property statusMessage = BFederatedIdentityAuthenticator.newProperty((int)259, (String)"", null);
    public static final Property certificatePassword = BFederatedIdentityAuthenticator.newProperty((int)64, (BValue)BPassword.make((String)""), (BFacets)BFacets.make((BFacets)BFacets.make((String)"placeholderText", (String)"%lexicon(workbench:default.password.placeholder.label)%"), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)));
    public static final Action startRegistration = BFederatedIdentityAuthenticator.newAction((int)257, null);
    public static final Action ackAlarm = BFederatedIdentityAuthenticator.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Topic certificateUpdate = BFederatedIdentityAuthenticator.newTopic((int)4, null);
    public static final Type TYPE = Sys.loadType(BFederatedIdentityAuthenticator.class);
    private BMessagingChannel messagingChannel;
    private ScheduledExecutorService executor;
    private boolean startProvisioning = true;
    private boolean registering;
    private final Object syncObj = new Object();
    private final Object syncKeyStoreObj = new Object();
    private AlarmSupport alarmSupport;
    private BPassword currentCertPassword;
    private static final int CERT_EXPIRATION_CHECK_DAYS = 7;
    private static final String FDI_CA_ALIAS = "NCSFederatedIdentityCA";
    public static final String P_MIGRATED_FROM = "migratedFrom";
    private static final Logger log = Logger.getLogger("cloudLink.auth.federated");
    private static final Lexicon lex = Lexicon.make(BFederatedIdentityAuthenticator.class);
    private static final String AUTH_DEV_CONFIGURER = "cloudLinkInternal:AuthDevConfigurer";
    private static final String MAKE_HOST_ID = "makeHostId";

    public BFedIdRegistrationState getRegistrationState() {
        return (BFedIdRegistrationState)this.get(registrationState);
    }

    public void setRegistrationState(BFedIdRegistrationState v) {
        this.set(registrationState, (BValue)v, null);
    }

    public BFedIdAuthenticationState getAuthenticationState() {
        return (BFedIdAuthenticationState)this.get(authenticationState);
    }

    public void setAuthenticationState(BFedIdAuthenticationState v) {
        this.set(authenticationState, (BValue)v, null);
    }

    public String getUserCode() {
        return this.getString(userCode);
    }

    public void setUserCode(String v) {
        this.setString(userCode, v, null);
    }

    public String getDeviceCode() {
        return this.getString(deviceCode);
    }

    public void setDeviceCode(String v) {
        this.setString(deviceCode, v, null);
    }

    public BOrd getUserRegistrationUrl() {
        return (BOrd)this.get(userRegistrationUrl);
    }

    public void setUserRegistrationUrl(BOrd v) {
        this.set(userRegistrationUrl, (BValue)v, null);
    }

    public BAbsTime getCodeExpiration() {
        return (BAbsTime)this.get(codeExpiration);
    }

    public void setCodeExpiration(BAbsTime v) {
        this.set(codeExpiration, (BValue)v, null);
    }

    public String getRegistrationHost() {
        return this.getString(registrationHost);
    }

    public void setRegistrationHost(String v) {
        this.setString(registrationHost, v, null);
    }

    public BRelTime getDeviceUuidDelay() {
        return (BRelTime)this.get(deviceUuidDelay);
    }

    public void setDeviceUuidDelay(BRelTime v) {
        this.set(deviceUuidDelay, (BValue)v, null);
    }

    public String getHostId() {
        return this.getString(hostId);
    }

    public void setHostId(String v) {
        this.setString(hostId, v, null);
    }

    public BCloudLinkProvisioning getProvisioning() {
        return (BCloudLinkProvisioning)this.get(provisioning);
    }

    public void setProvisioning(BCloudLinkProvisioning v) {
        this.set(provisioning, (BValue)v, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    public String getStatusMessage() {
        return this.getString(statusMessage);
    }

    public void setStatusMessage(String v) {
        this.setString(statusMessage, v, null);
    }

    public BPassword getCertificatePassword() {
        return (BPassword)this.get(certificatePassword);
    }

    public void setCertificatePassword(BPassword v) {
        this.set(certificatePassword, (BValue)v, null);
    }

    public void startRegistration() {
        this.invoke(startRegistration, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public void fireCertificateUpdate(BString event) {
        this.fire(certificateUpdate, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        if (this.getConnectionService().map(c -> c.isFatalFault()).orElse(true).booleanValue()) {
            return;
        }
        super.serviceStarted();
        this.currentCertPassword = this.getCertificatePassword();
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.executor = ExecutorUtil.newSingleThreadBackgroundScheduledExecutor((String)"federatedIdentityAuth", (long)2L, (TimeUnit)TimeUnit.MINUTES);
        this.getConnectionService().ifPresent(ccs -> ccs.registerForConnectionServiceReady(() -> {
            this.executor.schedule(this::checkOcsp, 30L, TimeUnit.SECONDS);
            this.executor.schedule(this::checkCertExpiration, 1L, TimeUnit.MINUTES);
            for (BICachingCertificateConsumer consumer : (BICachingCertificateConsumer[])CompUtil.getDescendants((BComponent)ccs, BICachingCertificateConsumer.class)) {
                if (!(consumer instanceof BComponent)) continue;
                ((BComponent)consumer).linkTo((BComponent)this, (Slot)certificateUpdate, (Slot)consumer.getCertificateUpdateAction());
            }
        }));
        this.registerTransport();
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        if (this.getProperty(P_MIGRATED_FROM) != null) {
            this.executor.schedule(this::finishMigration, 100L, TimeUnit.MILLISECONDS);
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(certificatePassword)) {
            if (this.currentCertPassword == null) {
                return;
            }
            this.executor.execute(this::changeCertificatePassword);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeCertificatePassword() {
        Object object = this.syncKeyStoreObj;
        synchronized (object) {
            BPassword newCertPassword = this.getCertificatePassword();
            if (this.currentCertPassword.validate(newCertPassword)) {
                log.finest("The new certificate password matched the current certificate password. The certificate's password was not changed.");
                return;
            }
            log.info("Changing the certificate password...");
            String systemId = this.getSystemId();
            if (systemId.isEmpty()) {
                this.currentCertPassword = newCertPassword;
                log.info("Completed certificate password change.");
                return;
            }
            try {
                IKeyStore userKeyStore = this.getUserKeyStore();
                String bootstrapAlias = this.getBootstrapKeyStorePrefix() + this.getSystemId();
                String rollingAlias = this.getRollingKeyStorePrefix() + this.getSystemId();
                boolean hasBootstrapCert = userKeyStore.containsAlias(bootstrapAlias);
                boolean hasRollingCert = userKeyStore.containsAlias(rollingAlias);
                boolean bootstrapCertChanged = false;
                boolean rollingCertChanged = false;
                if (hasBootstrapCert) {
                    try {
                        this.changeKeyEntryPassword(userKeyStore, bootstrapAlias, this.currentCertPassword, newCertPassword);
                        bootstrapCertChanged = true;
                    }
                    catch (Exception bootstrapChangeExcept) {
                        throw new Exception("Bootstrap certificate password change failed.", bootstrapChangeExcept);
                    }
                }
                if (hasRollingCert) {
                    try {
                        this.changeKeyEntryPassword(userKeyStore, rollingAlias, this.currentCertPassword, newCertPassword);
                        rollingCertChanged = true;
                    }
                    catch (Exception rollingChangeExcept) {
                        if (bootstrapCertChanged) {
                            log.fine("Reverting bootstrap certificate password change.");
                            this.changeKeyEntryPassword(userKeyStore, bootstrapAlias, newCertPassword, this.currentCertPassword);
                        }
                        throw new Exception("Rolling certificate password change failed.", rollingChangeExcept);
                    }
                }
                try {
                    if (bootstrapCertChanged || rollingCertChanged) {
                        log.fine("Saving the user keystore.");
                        userKeyStore.save();
                    }
                    this.currentCertPassword = newCertPassword;
                    log.info("Completed certificate password change.");
                }
                catch (Exception saveExcept) {
                    if (bootstrapCertChanged) {
                        log.fine("Reverting bootstrap certificate password change.");
                        this.changeKeyEntryPassword(userKeyStore, bootstrapAlias, newCertPassword, this.currentCertPassword);
                    }
                    if (rollingCertChanged) {
                        log.fine("Reverting rolling certificate password change.");
                        this.changeKeyEntryPassword(userKeyStore, rollingAlias, newCertPassword, this.currentCertPassword);
                    }
                    throw new Exception("Keystore save failed.", saveExcept);
                }
            }
            catch (Exception except) {
                log.fine("Reverting the certificatePassword property change.");
                this.setCertificatePassword(this.currentCertPassword);
                log.log(Level.WARNING, "The certificate password was not changed.", log.isLoggable(Level.FINE) ? except : null);
            }
        }
    }

    private void finishMigration() {
        Property p_migrated = this.getProperty(P_MIGRATED_FROM);
        if (p_migrated != null && p_migrated.getType().is(BOrd.TYPE)) {
            log.info("Finishing migration of Federated Identity Authenticator...");
            try {
                BOrd migratedFrom = (BOrd)this.get(p_migrated).as(BOrd.class);
                BComponent c = migratedFrom.get().asComponent();
                String name = c.getName();
                c.getParent().asComponent().remove((BComplex)c);
                this.remove(p_migrated);
                this.getParent().asComponent().rename(this.getPropertyInParent(), name);
                this.getConnectionService().ifPresent(ccs -> {
                    BICachingCertificateConsumer[] certConsumers;
                    log.finest("Reinitializing authenticator references");
                    Arrays.stream(CompUtil.getDescendants((BComponent)ccs, BTransportConfig.class)).forEach(BTransportConfig::initializeAuthenticator);
                    Arrays.stream(CompUtil.getDescendants((BComponent)ccs, BAbstractConnectedTransport.class)).forEach(BAbstractConnectedTransport::initializeAuthenticator);
                    log.finest("Removing links to caching certificate consumers");
                    for (BICachingCertificateConsumer consumer : certConsumers = (BICachingCertificateConsumer[])CompUtil.getDescendants((BComponent)ccs, BICachingCertificateConsumer.class)) {
                        BLink[] links;
                        for (BLink link : links = ((BComponent)consumer.as(BComponent.class)).getLinks()) {
                            if (link.getSourceComponent().isMounted()) continue;
                            ((BComponent)consumer.as(BComponent.class)).remove((BComplex)link);
                        }
                    }
                });
                log.info("Migration successfully completed");
            }
            catch (Exception except) {
                log.log(Level.WARNING, "Could not complete migration to cloudLink:FederatedIdentityAuthenticator: " + except, log.isLoggable(Level.FINE) ? except : null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addMessageHandlerProperties(BAbstractTransport transport, String audience, Map<String, Object> encoderProps) {
        if (!this.isOperational()) {
            log.info("Cannot supply certificate to message handler because authenticator is disabled");
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            log.finest("addMessageHandlerProperties called with no security manager");
            return;
        }
        sm.checkPermission((Permission)new NiagaraBasicPermission("CLOUD_GET_CONNECTION_INFORMATION"));
        Object object = this.syncKeyStoreObj;
        synchronized (object) {
            AccessController.doPrivileged(() -> {
                BCertificateAliasAndPassword certAliasAndPass = new BCertificateAliasAndPassword(this.getCertAlias(), BPassword.make((String)this.currentCertPassword.getValue()));
                encoderProps.put("certAliasAndPassword", certAliasAndPass);
                return null;
            });
        }
    }

    @Override
    public Map<String, Object> getPlatformProperties() {
        return new HashMap<String, Object>();
    }

    @Override
    public boolean canAuthenticate() {
        return this.isOperational() && this.getCertAlias() != null;
    }

    @Override
    public boolean isRegistered() {
        return this.getRegistrationState().isRegistered();
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, IValueWrapper<?>> getConnectionInfo(String id) {
        BCertificateAliasAndPassword certAliasAndPass;
        if (!this.isOperational()) {
            log.finest("getConnectionInfo called while authenticator is not operational");
            return Collections.emptyMap();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            log.finest("getConnectionInfo called with no security manager");
            return Collections.emptyMap();
        }
        sm.checkPermission((Permission)new NiagaraBasicPermission("CLOUD_GET_CONNECTION_INFORMATION"));
        HashMap connectionMap = new HashMap();
        connectionMap.put("hostName", new StringWrapper(this.getRegistrationHost()));
        Object object = this.syncKeyStoreObj;
        synchronized (object) {
            certAliasAndPass = AccessController.doPrivileged(() -> new BCertificateAliasAndPassword(this.getCertAlias(), BPassword.make((String)this.currentCertPassword.getValue())));
        }
        connectionMap.put("certAliasAndPassword", new CertificateAliasAndPasswordWrapper(certAliasAndPass));
        return connectionMap;
    }

    public BBoolean doAckAlarm(BAlarmRecord alarmRecord) {
        try {
            boolean ack = this.alarmSupport.ackAlarm(alarmRecord);
            if (ack) {
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
            }
            return BBoolean.make((boolean)ack);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Cannot process alarm ack:" + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            return BBoolean.FALSE;
        }
    }

    public final void doStartRegistration() {
        if (!this.isOperational()) {
            log.warning("Start registration called when Authenticator is not operational");
            this.setStatusMessage(lex.get("fdi.notOperational"));
            return;
        }
        if (this.getCertAlias() != null) {
            log.info("Start registration called when already registered");
            return;
        }
        this.setStatusMessage("");
        String stationName = Sys.isStation() ? Sys.getStation().getStationName() : "";
        String hostId = this.getHostId();
        if (hostId.isEmpty()) {
            hostId = Arrays.stream(((BClientAuthenticatorsFolder)this.getParent().as(BClientAuthenticatorsFolder.class)).getChildren(BIDevConfigurer.class)).filter(biDevConfigurer -> AUTH_DEV_CONFIGURER.equals(biDevConfigurer.getType().toString())).findFirst().map(biDevConfigurer -> String.valueOf(biDevConfigurer.configure(this, MAKE_HOST_ID))).orElse(Sys.getHostId());
            this.setHostId(hostId);
        }
        FederatedIdentityBootstrapRequest request = new FederatedIdentityBootstrapRequest(this.getRegistrationHost(), stationName, hostId);
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", request.toMessage(true)));
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.SEVERE, "Error in Federated Identity init bootstrap: " + err.getMessage(), log.isLoggable(Level.FINE) ? err : null);
                this.setStatusMessage(this.getInitError((Throwable)err));
            } else {
                FederatedIdentityBootstrapResponse response = new FederatedIdentityBootstrapResponse((HttpResponseMessage)resp);
                if (response.isSuccessful()) {
                    log.config("received successful bootstrap registration response");
                    this.setDeviceCode(response.getDeviceCode());
                    this.setUserCode(response.getUserCode());
                    this.setUserRegistrationUrl(BOrd.make((String)response.getRegistrationUrl()));
                    this.setCodeExpiration(response.getExpirationTime());
                    this.executor.schedule(this::checkRegistered, this.getDeviceUuidDelay().getMillis(), TimeUnit.MILLISECONDS);
                } else {
                    log.severe("bootstrap registration response missing device code");
                }
            }
        });
    }

    protected void checkRegistered() {
        if (!this.getSystemId().isEmpty()) {
            log.config("system id already set, aborting");
            return;
        }
        FederatedIdentityDeviceUuidRequest request = new FederatedIdentityDeviceUuidRequest(this.getRegistrationHost(), this.getDeviceCode());
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", request.toMessage(true)));
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                if (BAbsTime.now().isAfter(this.getCodeExpiration())) {
                    log.log(Level.INFO, "User code expired before device registered", log.isLoggable(Level.FINE) ? err : null);
                    this.setStatusMessage(lex.get("fdi.expired"));
                } else if (err instanceof HttpStatusException) {
                    HttpStatusException httpErr = (HttpStatusException)err;
                    List<String> values = httpErr.getHeaders().get("retry-after");
                    if (values == null || values.isEmpty()) {
                        log.log(Level.WARNING, "Device not registered and no server retry", log.isLoggable(Level.FINE) ? err : null);
                        this.setStatusMessage(this.getInitError((Throwable)err));
                        return;
                    }
                    try {
                        int delay = Integer.parseInt(values.get(0));
                        this.executor.schedule(this::checkRegistered, (long)delay, TimeUnit.SECONDS);
                    }
                    catch (Exception ex) {
                        log.log(Level.SEVERE, "Error getting device registration retry interval", log.isLoggable(Level.FINE) ? ex : null);
                        log.log(Level.SEVERE, "Device not registered", log.isLoggable(Level.FINE) ? err : null);
                    }
                } else {
                    log.log(Level.SEVERE, "Error in Federated Identity get device uuid", log.isLoggable(Level.FINE) ? err : null);
                }
            } else {
                FederatedIdentityDeviceUuidResponse response = new FederatedIdentityDeviceUuidResponse((HttpResponseMessage)resp);
                if (response.isSuccessful()) {
                    log.config("received device UUID");
                    Object values = this.syncObj;
                    synchronized (values) {
                        if (!this.getSystemId().isEmpty() && this.getSystemId().equals(response.getDeviceUuid())) {
                            log.info("system id already set, aborting");
                            return;
                        }
                        this.setSystemId(response.getDeviceUuid());
                    }
                    this.setRegistrationState(BFedIdRegistrationState.registered);
                    this.registering = true;
                    this.makeBootstrapCSR();
                } else {
                    List<String> values = ((HttpResponseMessage)resp).getHeaders().get("retry-after");
                    if (values == null || values.isEmpty()) {
                        log.log(Level.SEVERE, "Device not registered and no server retry", log.isLoggable(Level.FINE) ? err : null);
                        this.setStatusMessage(this.getInitError((Throwable)err));
                        return;
                    }
                    try {
                        int delay = Integer.parseInt(values.get(0));
                        this.executor.schedule(this::checkRegistered, (long)delay, TimeUnit.SECONDS);
                    }
                    catch (Exception ex) {
                        log.log(Level.SEVERE, "Error getting device registration retry interval", log.isLoggable(Level.FINE) ? ex : null);
                    }
                }
            }
        });
    }

    protected void makeBootstrapCSR() {
        FederatedIdentityCsrRequest request;
        this.setAuthenticationState(BFedIdAuthenticationState.authenticationPending);
        KeyPairGenerator keyPairGen = new RsaKeyPairGeneratorSupplier().get();
        KeyPair keyPair = keyPairGen.generateKeyPair();
        String alias = this.getBootstrapKeyStorePrefix() + this.getSystemId();
        try {
            IX509CertificateEntry cert = this.makeX509Certificate(keyPair, alias, 120);
            request = new FederatedIdentityCsrRequest.FederatedIdentityCsrRequestBuilder(this.getRegistrationHost(), CertUtils.generateCSR((IX509CertificateEntry)cert)).deviceCode(this.getDeviceCode()).build();
        }
        catch (Exception ex) {
            this.setStatusMessage(lex.get("fdi.makeCsrError"));
            log.log(Level.SEVERE, "unable to generate certificate", log.isLoggable(Level.FINE) ? ex : null);
            this.setAuthenticationState(BFedIdAuthenticationState.authenticationFailed);
            this.registering = false;
            return;
        }
        IMessage msg = request.toMessage(true);
        if (msg == null) {
            this.setStatusMessage(lex.get("fdi.sendCsrError"));
            log.severe("unable to generate bootstrap CSR message");
            this.setAuthenticationState(BFedIdAuthenticationState.authenticationFailed);
            this.registering = false;
            return;
        }
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", msg));
        reqFuture.whenComplete((resp, err) -> {
            block10: {
                if (err != null) {
                    if (this.getCodeExpiration().subtract(BRelTime.MINUTE).isAfter(BAbsTime.now())) {
                        log.log(Level.INFO, "Error requesting Federated Identity bootstrap CSR, retrying", log.isLoggable(Level.FINE) ? err : null);
                        this.setStatusMessage(lex.get("fdi.makeCsrErrorRetry"));
                        this.executor.schedule(this::makeBootstrapCSR, 1L, TimeUnit.MINUTES);
                    } else {
                        log.log(Level.SEVERE, "Error in Federated Identity bootstrap CSR, station will need to be re-registered", log.isLoggable(Level.FINE) ? err : null);
                        this.setStatusMessage(this.getInitError((Throwable)err));
                        this.setRegistrationState(BFedIdRegistrationState.unregistered);
                        this.setAuthenticationState(BFedIdAuthenticationState.authenticationFailed);
                        this.setSystemId("");
                        this.registering = false;
                    }
                } else {
                    try {
                        FederatedIdentityCsrResponse response = new FederatedIdentityCsrResponse((HttpResponseMessage)resp);
                        if (!response.isSuccessful()) break block10;
                        log.config(response.getMessage());
                        ICryptoManager certMgrFact = CertManagerFactory.getInstance();
                        ITrustStore userTrustStore = certMgrFact.getUserTrustStore();
                        X509Certificate[] certChain = response.getCertificates();
                        userTrustStore.setCertificateEntry(FDI_CA_ALIAS, certChain[certChain.length - 1]);
                        userTrustStore.save();
                        Object object = this.syncKeyStoreObj;
                        synchronized (object) {
                            this.saveKeyEntry(certMgrFact.getKeyStore(), alias, keyPair, this.currentCertPassword, certChain);
                        }
                        this.makeRollingCsr();
                    }
                    catch (Exception ex) {
                        if (this.getCodeExpiration().subtract(BRelTime.MINUTE).isAfter(BAbsTime.now())) {
                            log.log(Level.INFO, "Error requesting Federated Identity bootstrap CSR, retrying", log.isLoggable(Level.FINE) ? ex : null);
                            this.setStatusMessage(lex.get("fdi.makeCsrErrorRetry"));
                            this.executor.schedule(this::makeBootstrapCSR, 1L, TimeUnit.MINUTES);
                        }
                        this.setStatusMessage(lex.get("fdi.CsrResponseError"));
                        log.log(Level.SEVERE, "Error processing bootstrap certificate signing request response", log.isLoggable(Level.FINE) ? ex : null);
                        this.setRegistrationState(BFedIdRegistrationState.unregistered);
                        this.setAuthenticationState(BFedIdAuthenticationState.authenticationFailed);
                        this.setSystemId("");
                        this.registering = false;
                    }
                }
            }
        });
    }

    protected CompletableFuture<IMessageResponse> makeRollingCsr() {
        FederatedIdentityCsrRequest request;
        String certAlias = this.getCertAlias();
        if (certAlias == null) {
            log.warning("Unable to get certificate alias to use for rolling CSR request");
            CompletableFuture<IMessageResponse> errFuture = new CompletableFuture<IMessageResponse>();
            errFuture.completeExceptionally(new Exception("no valid certificate alias available."));
            return errFuture;
        }
        KeyPairGenerator keyPairGen = new RsaKeyPairGeneratorSupplier().get();
        KeyPair keyPair = keyPairGen.generateKeyPair();
        String alias = this.getRollingKeyStorePrefix() + this.getSystemId();
        try {
            BCertificateAliasAndPassword certAliasAndPass = new BCertificateAliasAndPassword(certAlias, BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.currentCertPassword).getValue())));
            IX509CertificateEntry cert = this.makeX509Certificate(keyPair, alias, 3);
            request = new FederatedIdentityCsrRequest.FederatedIdentityCsrRequestBuilder(this.getRegistrationHost(), CertUtils.generateCSR((IX509CertificateEntry)cert)).certificateAliasAndPassword(certAliasAndPass).isRolling(true).build();
        }
        catch (Exception ex) {
            this.setStatusMessage(lex.get("fdi.makeCsrError"));
            log.log(Level.SEVERE, "unable to generate certificate", log.isLoggable(Level.FINE) ? ex : null);
            this.setAuthenticationState(BFedIdAuthenticationState.authenticationFailed);
            this.registering = false;
            CompletableFuture<IMessageResponse> errFuture = new CompletableFuture<IMessageResponse>();
            errFuture.completeExceptionally(ex);
            return errFuture;
        }
        IMessage msg = request.toMessage(true);
        if (msg == null) {
            this.setStatusMessage(lex.get("fdi.sendCsrError"));
            log.severe("unable to generate rolling CSR message");
            this.setAuthenticationState(BFedIdAuthenticationState.authenticationFailed);
            this.registering = false;
            CompletableFuture<IMessageResponse> errFuture = new CompletableFuture<IMessageResponse>();
            errFuture.completeExceptionally(new IOException("Unable to generate rolling CSR message"));
            return errFuture;
        }
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", msg));
        reqFuture.whenComplete((resp, err) -> {
            block10: {
                if (err != null) {
                    log.log(Level.SEVERE, "Error in Federated Identity rolling CSR", log.isLoggable(Level.FINE) ? err : null);
                    this.setStatusMessage(this.getInitError((Throwable)err));
                    this.setAuthenticationState(BFedIdAuthenticationState.authenticationFailed);
                    this.executor.schedule(this::makeRollingCsr, this.getDeviceUuidDelay().getMillis(), TimeUnit.MILLISECONDS);
                } else {
                    try {
                        FederatedIdentityCsrResponse response = new FederatedIdentityCsrResponse((HttpResponseMessage)resp);
                        if (response.isSuccessful()) {
                            log.config(response.getMessage());
                            IKeyStore userKeyStore = this.getUserKeyStore();
                            Object object = this.syncKeyStoreObj;
                            synchronized (object) {
                                this.saveKeyEntry(userKeyStore, alias, keyPair, this.currentCertPassword, response.getCertificates());
                            }
                            this.fireCertificateUpdate(BString.make((String)alias));
                            this.setAuthenticationState(BFedIdAuthenticationState.authenticated);
                            this.registering = false;
                            if (this.startProvisioning) {
                                this.startProvisioning = false;
                                this.deviceProvisioning();
                            }
                            break block10;
                        }
                        log.info(() -> "Rolling CSR response: " + response.getMessage());
                        if (response.getCertificates() == null || response.getCertificates().length < 1) {
                            log.info("Rolling CSR response did not contain any certificates");
                        }
                        this.executor.schedule(this::makeRollingCsr, this.getDeviceUuidDelay().getMillis(), TimeUnit.MILLISECONDS);
                    }
                    catch (Exception ex) {
                        this.setStatusMessage(lex.get("fdi.CsrResponseError"));
                        log.log(Level.INFO, "Error processing rolling certificate signing request response", log.isLoggable(Level.FINE) ? ex : null);
                        this.setAuthenticationState(BFedIdAuthenticationState.authenticationFailed);
                        this.executor.schedule(this::makeRollingCsr, this.getDeviceUuidDelay().getMillis(), TimeUnit.MILLISECONDS);
                    }
                }
            }
        });
        return reqFuture;
    }

    protected CompletableFuture<IMessageResponse> makeBootstrapRenewalCsr() {
        FederatedIdentityCsrRequest request;
        String certAlias = this.getCertAlias();
        if (certAlias == null) {
            log.warning("Unable to get certificate alias to use for bootstrap renewal CSR request");
            CompletableFuture<IMessageResponse> errFuture = new CompletableFuture<IMessageResponse>();
            errFuture.completeExceptionally(new Exception("no valid certificate alias available."));
            return errFuture;
        }
        KeyPairGenerator keyPairGen = new RsaKeyPairGeneratorSupplier().get();
        KeyPair keyPair = keyPairGen.generateKeyPair();
        String alias = this.getBootstrapKeyStorePrefix() + this.getSystemId();
        try {
            BCertificateAliasAndPassword certAliasAndPass = new BCertificateAliasAndPassword(certAlias, BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.currentCertPassword).getValue())));
            IX509CertificateEntry cert = this.makeX509Certificate(keyPair, alias, 120);
            request = new FederatedIdentityCsrRequest.FederatedIdentityCsrRequestBuilder(this.getRegistrationHost(), CertUtils.generateCSR((IX509CertificateEntry)cert)).certificateAliasAndPassword(certAliasAndPass).isRolling(false).build();
        }
        catch (Exception ex) {
            this.setStatusMessage(lex.get("fdi.makeCsrError"));
            log.log(Level.SEVERE, "unable to generate certificate", log.isLoggable(Level.FINE) ? ex : null);
            CompletableFuture<IMessageResponse> errFuture = new CompletableFuture<IMessageResponse>();
            errFuture.completeExceptionally(ex);
            return errFuture;
        }
        IMessage msg = request.toMessage(true);
        if (msg == null) {
            this.setStatusMessage(lex.get("fdi.sendCsrError"));
            log.severe("unable to generate bootstrap CSR renewal message");
            CompletableFuture<IMessageResponse> errFuture = new CompletableFuture<IMessageResponse>();
            errFuture.completeExceptionally(new IOException("Unable to generate bootstrap CSR renewal message"));
            return errFuture;
        }
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", msg));
        reqFuture.whenComplete((resp, err) -> {
            block7: {
                if (err != null) {
                    log.log(Level.SEVERE, "Error in Federated Identity bootstrap CSR renewal", log.isLoggable(Level.FINE) ? err : null);
                    this.setStatusMessage(this.getInitError((Throwable)err));
                } else {
                    try {
                        FederatedIdentityCsrResponse response = new FederatedIdentityCsrResponse((HttpResponseMessage)resp);
                        if (!response.isSuccessful()) break block7;
                        log.config(response.getMessage());
                        IKeyStore userKeyStore = this.getUserKeyStore();
                        Object object = this.syncKeyStoreObj;
                        synchronized (object) {
                            this.saveKeyEntry(userKeyStore, alias, keyPair, this.currentCertPassword, response.getCertificates());
                        }
                        this.fireCertificateUpdate(BString.make((String)alias));
                    }
                    catch (Exception ex) {
                        this.setStatusMessage(lex.get("fdi.CsrResponseError"));
                        log.log(Level.SEVERE, "Error processing rolling certificate signing request response", log.isLoggable(Level.FINE) ? ex : null);
                    }
                }
            }
        });
        return reqFuture;
    }

    protected void deviceProvisioning() {
        BCertificateAliasAndPassword certAliasAndPass = new BCertificateAliasAndPassword(this.getCertAlias(), BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.currentCertPassword).getValue())));
        FederatedIdentityDeviceProvisioningInfoRequest request = new FederatedIdentityDeviceProvisioningInfoRequest(this.getRegistrationHost(), this.getProvisioning().getConfigurationIdentifier(), certAliasAndPass);
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", request.toMessage(true)));
        reqFuture.whenComplete((resp, err) -> {
            int retry = 900;
            if (err != null) {
                if (err instanceof HttpStatusException) {
                    List<String> headers;
                    HttpStatusException httpErr = (HttpStatusException)err;
                    if (httpErr.getStatusCode() == 304) {
                        log.config("device provisioning information unchanged");
                    }
                    if ((headers = httpErr.getHeaders().get("retry-after")) != null && !headers.isEmpty()) {
                        retry = Integer.parseInt(headers.get(0));
                    }
                } else {
                    log.log(Level.SEVERE, "Error receiving device provisioning info response", log.isLoggable(Level.FINE) ? err : null);
                    this.setStatusMessage(this.getInitError((Throwable)err));
                }
            } else {
                try {
                    FederatedIdentityDeviceProvisioningInfoResponse response = new FederatedIdentityDeviceProvisioningInfoResponse((HttpResponseMessage)resp);
                    log.config("received updated device provisioning information");
                    this.getProvisioning().configureCCS(response.getConfig());
                    this.getProvisioning().setConfigurationIdentifier(response.getETag());
                    retry = response.getRetry();
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Error processing device provisioning info response", log.isLoggable(Level.FINE) ? ex : null);
                }
            }
            this.executor.schedule(this::deviceProvisioning, (long)retry, TimeUnit.SECONDS);
        });
    }

    @NotNull
    protected IX509CertificateEntry makeX509Certificate(KeyPair keyPair, String alias, int months) throws Exception {
        String dn = String.format("CN=%s", this.getSystemId());
        Calendar cal = Calendar.getInstance();
        Date notBefore = cal.getTime();
        cal.add(2, months);
        Date notAfter = cal.getTime();
        NCertificateParameters parameters = new NCertificateParameters(alias, dn, dn, notBefore, notAfter, 0, KeyPurpose.CLIENT_CERT, null, null, null);
        IX509CertificateEntry cert = CertUtils.generateSelfSignedCert((KeyPair)keyPair, (NCertificateParameters)parameters);
        return cert;
    }

    public String getInitError(Throwable err) {
        return lex.get("fdi.generalError");
    }

    public String getCertAlias() {
        try {
            IKeyStore userKeyStore = this.getUserKeyStore();
            String alias = this.getRollingKeyStorePrefix() + this.getSystemId();
            X509Certificate cert = userKeyStore.getCertificate(alias);
            Date now = Date.from(Instant.now());
            if (cert != null && cert.getNotAfter().after(now)) {
                return alias;
            }
            alias = this.getBootstrapKeyStorePrefix() + this.getSystemId();
            cert = userKeyStore.getCertificate(alias);
            if (cert != null && cert.getNotAfter().after(now)) {
                return alias;
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "error getting FDI cert", log.isLoggable(Level.FINE) ? ex : null);
        }
        return null;
    }

    protected void saveKeyEntry(IKeyStore keyStore, String alias, KeyPair keyPair, BPassword password, X509Certificate[] certChain) throws Exception {
        log.finer(() -> String.format("Saving key entry for alias %s", alias));
        try (SecretChars secret = AccessController.doPrivileged(() -> ((BPassword)password).getSecretChars());){
            keyStore.setKeyEntry(alias, (Key)keyPair.getPrivate(), secret.get(), certChain);
            keyStore.save();
        }
    }

    protected void changeKeyEntryPassword(IKeyStore keyStore, String alias, BPassword currentPassword, BPassword newPassword) throws Exception {
        log.finer(() -> String.format("Changing password for key entry with alias %s", alias));
        try (SecretChars currentSecret = AccessController.doPrivileged(() -> ((BPassword)currentPassword).getSecretChars());
             SecretChars newSecret = AccessController.doPrivileged(() -> ((BPassword)newPassword).getSecretChars());){
            Key privateKey = keyStore.getKey(alias, currentSecret.get());
            X509Certificate[] certChain = keyStore.getCertificateChain(alias);
            keyStore.setKeyEntry(alias, privateKey, newSecret.get(), certChain);
        }
    }

    protected IKeyStore getUserKeyStore() throws Exception {
        return CertManagerFactory.getInstance().getKeyStore();
    }

    protected String getBootstrapKeyStorePrefix() {
        return "FedIdBootstrap_";
    }

    protected String getRollingKeyStorePrefix() {
        return "FedId_";
    }

    private void registerTransport() {
        this.getConnectionService().ifPresent(ccs -> {
            this.messagingChannel = (BMessagingChannel)ccs.getChannel("Messaging");
        });
        if (this.messagingChannel == null) {
            log.warning("Could not find messaging channel for use by the Federated Identity Authenticator; will not be able to authenticate!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkOcsp() {
        try {
            IKeyStore userKeyStore = CertManagerFactory.getInstance().getKeyStore();
            String alias = this.getRollingKeyStorePrefix() + this.getSystemId();
            X509Certificate[] certChain = userKeyStore.getCertificateChain(alias);
            if (certChain != null && certChain.length > 1) {
                FederatedIdentityOcspRequest request = new FederatedIdentityOcspRequest(certChain[0], certChain[1]);
                IMessage msg = request.toMessage(true);
                if (msg == null) {
                    this.setStatusMessage(lex.get("fdi.sendOcspError"));
                    log.info("unable to generate OCSP message");
                    return;
                }
                CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", msg));
                reqFuture.whenComplete((resp, err) -> {
                    if (err != null) {
                        log.info("error from OCSP server");
                    } else {
                        try {
                            RevokedStatus revokedStatus;
                            FederatedIdentityOcspResponse response = new FederatedIdentityOcspResponse((HttpResponseMessage)resp, certChain[certChain.length - 1]);
                            CertificateStatus certStatus = response.getCertStatus(request.getCertificateID());
                            if (certStatus instanceof RevokedStatus && (revokedStatus = (RevokedStatus)certStatus).hasRevocationReason() && revokedStatus.getRevocationReason() == 5) {
                                this.getConnectionService().ifPresent(ccs -> {
                                    ccs.setEnabled(false);
                                    ccs.configFail(lex.get("fdi.cert.revoked"));
                                });
                            }
                        }
                        catch (Exception ex) {
                            log.log(Level.INFO, "error processing OCSP response", log.isLoggable(Level.FINE) ? ex : null);
                            throw new RuntimeException(ex);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            log.log(Level.INFO, "error preforming OCSP check", log.isLoggable(Level.FINE) ? ex : null);
        }
        finally {
            this.executor.schedule(this::checkOcsp, 1L, TimeUnit.DAYS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCertExpiration() {
        try {
            X509Certificate bootCert;
            IKeyStore userKeyStore = this.getUserKeyStore();
            String alias = this.getRollingKeyStorePrefix() + this.getSystemId();
            X509Certificate cert = userKeyStore.getCertificate(alias);
            if (cert != null) {
                BAbsTime expiration = BAbsTime.make((long)cert.getNotAfter().getTime());
                if (expiration.isBefore(BAbsTime.now().nextMonth())) {
                    this.makeRollingCsr().whenComplete((resp, err) -> this.processCertRenewalResult((Throwable)err, expiration, "fdi.cert.expiration.rolling"));
                } else if (this.startProvisioning) {
                    this.startProvisioning = false;
                    this.deviceProvisioning();
                    this.setAuthenticationState(BFedIdAuthenticationState.authenticated);
                }
            }
            if ((bootCert = userKeyStore.getCertificate(alias = this.getBootstrapKeyStorePrefix() + this.getSystemId())) != null) {
                BAbsTime expiration;
                if (cert == null && !this.registering) {
                    this.makeRollingCsr();
                }
                if ((expiration = BAbsTime.make((long)bootCert.getNotAfter().getTime())).isBefore(BAbsTime.now().nextMonth())) {
                    this.makeBootstrapRenewalCsr().whenComplete((resp, err) -> this.processCertRenewalResult((Throwable)err, expiration, "fdi.cert.expiration.bootstrap"));
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "error checking certificate expiration", log.isLoggable(Level.FINE) ? ex : null);
        }
        finally {
            this.executor.schedule(this::checkCertExpiration, 7L, TimeUnit.DAYS);
        }
    }

    private void processCertRenewalResult(Throwable err, BAbsTime expiration, String reasonKey) {
        if (err == null) {
            if (this.getStatus().isAlarm()) {
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
                try {
                    this.alarmSupport.toNormal(null);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Cannot clear off normal alarm for certificate expiration:" + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
                }
            }
            return;
        }
        if (expiration.isBefore(BAbsTime.now().add(BRelTime.makeDays((int)7)))) {
            this.raiseCertAlarm(reasonKey, expiration);
        }
    }

    private void raiseCertAlarm(String reasonKey, BAbsTime expiration) {
        if (!this.getStatus().isAlarm()) {
            BFacets alarmData = this.getAlarmSourceInfo().makeAlarmData(BSourceState.offnormal);
            String msgText = alarmData.gets("msgText", "");
            alarmData = BFacets.make((BFacets)alarmData, (String)"msgText", (BIDataValue)BString.make((String)(msgText + " \n" + lex.get(reasonKey) + ' ' + expiration.encodeToString())));
            try {
                this.alarmSupport.newOffnormalAlarm(alarmData);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Cannot generate off normal alarm for certificate expiration:" + ex.getLocalizedMessage(), log.isLoggable(Level.FINE) ? ex : null);
            }
            int newStatus = this.getStatus().getBits();
            this.setStatus(BStatus.make((int)(newStatus |= 0x88)));
        }
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"CloudLink %parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(cloudLinkForge:fdi.cert.failure)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(cloudLinkForge:fdi.cert.success)%"));
        return asi;
    }
}

