/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import com.tridium.sys.Nre;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.query.BQueryResult;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class CloudLinkUtils {
    public static final Context fallbackContext = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return "cloudLink:fallbackContext";
        }
    };
    private static final Logger log = Logger.getLogger("cloudLink.util");

    private CloudLinkUtils() {
    }

    public static boolean isModuleLoaded(String moduleName) {
        try {
            return Nre.getModuleManager().loadModule(moduleName, RuntimeProfile.rt) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Map<String, Object> makeSasTokenAuthHeaderMap(String sasToken) {
        return Collections.singletonMap("Authorization", sasToken);
    }

    public static Map<String, Object> makeBearerTokenAuthHeaderMap(String token) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Authorization", "Bearer " + token);
        return headers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject fromInputStreamToJsonObject(InputStream in) {
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            JSONObject jSONObject = new JSONObject(new JSONTokener((Reader)reader));
            return jSONObject;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONArray fromInputStreamToJsonArray(InputStream in) {
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            JSONArray jSONArray = new JSONArray(new JSONTokener((Reader)reader));
            return jSONArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Consumer<OutputStream> fromStringToOutputStreamFunc(Object obj) {
        return out -> {
            try {
                out.write(Objects.toString(obj, "").getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static boolean jsonEquivalent(String s1, String s2) {
        Objects.requireNonNull(s1, "jsonEquivalent(): JSON String 1 must not be null");
        Objects.requireNonNull(s2, "jsonEquivalent(): JSON String 2 must not be null");
        return CloudLinkUtils.jsonEquivalent(new JSONObject(s1), new JSONObject(s2));
    }

    public static boolean jsonEquivalent(JSONArray a1, JSONArray a2) {
        Objects.requireNonNull(a1, "jsonEquivalent(): JSONArray 1 must not be null");
        Objects.requireNonNull(a2, "jsonEquivalent(): JSONArray 2 must not be null");
        if (a1.length() != a2.length()) {
            return false;
        }
        for (int i = 0; i < a1.length(); ++i) {
            Object o1 = a1.get(i);
            Object o2 = a2.get(i);
            if (o1 instanceof JSONObject) {
                if (!(o2 instanceof JSONObject)) {
                    return false;
                }
                if (CloudLinkUtils.jsonEquivalent((JSONObject)o1, (JSONObject)o2)) continue;
                return false;
            }
            if (o1 instanceof JSONArray) {
                if (!(o2 instanceof JSONArray)) {
                    return false;
                }
                if (CloudLinkUtils.jsonEquivalent((JSONArray)o1, (JSONArray)o2)) continue;
                return false;
            }
            if (Objects.toString(o1).equals(Objects.toString(o2))) continue;
            return false;
        }
        return true;
    }

    public static boolean jsonEquivalent(JSONObject o1, JSONObject o2) {
        Objects.requireNonNull(o1, "jsonEquivalent(): JSONObject 1 must not be null");
        Objects.requireNonNull(o2, "jsonEquivalent(): JSONObject 2 must not be null");
        if (o1.length() != o2.length()) {
            return false;
        }
        Iterator i1 = JSONUtil.sortedKeys((JSONObject)o1);
        Iterator i2 = JSONUtil.sortedKeys((JSONObject)o2);
        while (i1.hasNext()) {
            if (i2.hasNext()) {
                String k2;
                String k1 = Objects.toString(i1.next());
                if (!k1.equals(k2 = Objects.toString(i2.next()))) {
                    return false;
                }
                Object v1 = o1.get(k1);
                Object v2 = o2.get(k1);
                if (v1 instanceof JSONObject) {
                    if (!(v2 instanceof JSONObject)) {
                        return false;
                    }
                    if (CloudLinkUtils.jsonEquivalent((JSONObject)v1, (JSONObject)v2)) continue;
                    return false;
                }
                if (v1 instanceof JSONArray) {
                    if (!(v2 instanceof JSONArray)) {
                        return false;
                    }
                    if (CloudLinkUtils.jsonEquivalent((JSONArray)v1, (JSONArray)v2)) continue;
                    return false;
                }
                if (Objects.toString(v1).equals(Objects.toString(v2))) continue;
                return false;
            }
            return false;
        }
        return !i2.hasNext();
    }

    public static void checkParentForDuplicates(BComponent parent, BComponent child, Type expectedParentType, boolean onlyFrozen, Context cx) {
        if (!parent.getType().is(expectedParentType)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), child.getType()});
        }
        SlotCursor slots = parent.getProperties();
        while (slots.next(child.getClass())) {
            BValue val = slots.get();
            if (val == child || !child.getType().equals(val.getType()) || onlyFrozen && child.getPropertyInParent() != null && !child.getPropertyInParent().isDynamic()) continue;
            throw new IllegalChildException("cloudLink", "illegalDuplicate.parentType.childType", new Object[]{parent.getType(), child.getType()});
        }
    }

    public static BControlPoint findPoint(String messageId, String pointId) {
        BControlPoint point = null;
        try {
            BFacets facets = BFacets.make((String)"cloudId", (String)pointId);
            BOrd ord = BOrd.make((String)"station:|slot:/|neql:nc:cloudId = {cloudId}");
            BQueryResult result = (BQueryResult)ord.get((BObject)Sys.getStation(), (Context)facets);
            try (TableCursor cursor = result.cursor();){
                Iterator resultIterator = cursor.iterator();
                if (resultIterator.hasNext()) {
                    point = (BControlPoint)((BIObject)resultIterator.next()).as(BControlPoint.class);
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.CONFIG, "Error getting point by CloudId " + messageId, log.isLoggable(Level.FINE) ? ex : null);
        }
        if (point == null) {
            try {
                BOrd ord = BOrd.make((String)("station:|" + pointId));
                point = (BControlPoint)ord.get().as(BControlPoint.class);
            }
            catch (Exception ignore) {
                log.info(() -> String.format("unable to find point corresponding to id %s %s", pointId, messageId));
            }
        }
        return point;
    }

    public static boolean isPointReadAllowed(BControlPoint point, Context cx) {
        if (Flags.isOperator((BComplex)point.getParent(), (Slot)point.getPropertyInParent())) {
            return point.getPermissions(cx).hasOperatorRead();
        }
        return point.getPermissions(cx).hasAdminRead();
    }

    public static boolean isPointWriteAllowed(BControlPoint point, Context cx) {
        if (Flags.isOperator((BComplex)point.getParent(), (Slot)point.getPropertyInParent())) {
            return point.getPermissions(cx).hasOperatorWrite();
        }
        return point.getPermissions(cx).hasAdminWrite();
    }

    public static List<BOrd> findCloudConnectionServiceOrds() {
        try {
            BComponent[] services = Sys.getServices((Type)BCloudConnectionService.TYPE);
            if (services.length == 0) {
                log.info(() -> "No Cloud Connection Services defined.");
            } else if (services.length > 1) {
                log.info(() -> "Multiple Cloud Connection Services defined.");
            }
            return Arrays.stream(services).map(s -> s.getNavOrd()).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.warning(() -> String.format("Failed to retrieve Cloud Connection Service: %s", e.getMessage()));
            return Collections.emptyList();
        }
    }

    public static String makeMultiMapString(Map<String, List<String>> multiMap) {
        return multiMap.keySet().stream().map(key -> key + '=' + ((List)multiMap.get(key)).toString()).collect(Collectors.joining(", ", "{", "}"));
    }
}

