/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.history.HistoryItemWrapper;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.history.BHistoryRecord;
import javax.baja.io.BIEncodable;
import javax.baja.status.BIStatus;
import javax.baja.sys.BBitString;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BSimple;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;

public class ForgeHistorySerializer {
    public static final String HISTORY_SAMPLES = "HistorySamples";
    private static final String ITEM_NAME = "ItemName";
    public static final String GOOD = "good";
    public static final String PROPERTIES = "Properties";
    public static final String QUALITY = "Quality";
    public static final String TIME = "Time";
    public static final String TIMESTAMP = "timestamp";
    public static final String VAL = "value";
    protected JSONWriter jsonSerializer;
    private static final Logger log = Logger.getLogger("cloudLink.channel.history");

    public ForgeHistorySerializer(JSONWriter jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }

    public void serializeStart() {
        this.jsonSerializer.object();
        this.jsonSerializer.key(HISTORY_SAMPLES);
        this.jsonSerializer.array();
    }

    public void serializeRecord(HistoryItemWrapper value) {
        BHistoryRecord record = value.getHistoryItem().getRecord();
        String id = value.getCloudId();
        String time = record.getTimestamp().encodeToString();
        JSONObject flatValue = new JSONObject();
        ForgeHistorySerializer.flattenRecord((BComplex)record, "", flatValue);
        Object val = flatValue.opt(VAL);
        if (val != null) {
            flatValue.remove(VAL);
        } else {
            val = "";
        }
        this.jsonSerializer.object();
        this.jsonSerializer.key(ITEM_NAME).value((Object)id);
        this.jsonSerializer.key(QUALITY).value((Object)GOOD);
        this.jsonSerializer.key(TIME).value((Object)time);
        this.jsonSerializer.key("Value").value(val);
        this.jsonSerializer.key(PROPERTIES).value((Object)flatValue);
        this.jsonSerializer.endObject();
    }

    public void serializeEnd() {
        this.jsonSerializer.endArray();
        this.jsonSerializer.endObject();
    }

    private static void flattenRecord(BComplex record, String prefix, JSONObject value) {
        SlotCursor properties = record.getProperties();
        while (properties.next()) {
            Property property = properties.property();
            if (prefix != null && prefix.isEmpty() && property.getName().equals(TIMESTAMP)) continue;
            if (property.getType().is(BComplex.TYPE)) {
                ForgeHistorySerializer.flattenRecord((BComplex)record.get(property), prefix + property.getName() + '.', value);
                continue;
            }
            try {
                BSimple dataItem = (BSimple)record.get(property);
                if (dataItem instanceof BINumeric) {
                    double val = ((BINumeric)dataItem).getNumeric();
                    if (Double.POSITIVE_INFINITY == val) {
                        value.put(prefix + property.getName(), (Object)"Infinity");
                        continue;
                    }
                    if (Double.NEGATIVE_INFINITY == val) {
                        value.put(prefix + property.getName(), (Object)"-Infinity");
                        continue;
                    }
                    if (Double.isNaN(val)) {
                        value.put(prefix + property.getName(), (Object)"NaN");
                        continue;
                    }
                    value.put(prefix + property.getName(), val);
                    continue;
                }
                if (dataItem instanceof BIBoolean) {
                    value.put(prefix + property.getName(), ((BIBoolean)dataItem).getBoolean());
                    continue;
                }
                if (dataItem instanceof BBitString) {
                    BBitString bitString = (BBitString)dataItem;
                    String bitPrefix = prefix + property.getName();
                    value.put(bitPrefix, (Object)bitString.encodeToString());
                    for (int ordinal : bitString.getOrdinals()) {
                        value.put(bitPrefix + '.' + bitString.getTag(ordinal), bitString.getBit(ordinal));
                    }
                    if (!(dataItem instanceof BIStatus)) continue;
                    int status = ((BIStatus)dataItem).getStatus().getBits();
                    value.put(bitPrefix + ".ok", status == 0);
                    continue;
                }
                if (dataItem instanceof BIEnum) {
                    value.put(prefix + property.getName(), ((BIEnum)dataItem).getEnum().getOrdinal());
                    continue;
                }
                value.put(prefix + property.getName(), (Object)((BIEncodable)record.get(property)).encodeToString());
            }
            catch (IOException ex) {
                log.log(Level.INFO, "error encoding history record field " + prefix + property.getName(), log.isLoggable(Level.FINE) ? ex : null);
            }
        }
    }
}

