/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.forge.channel.BForgeHistoryChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeAmqpHandler;
import com.tridium.cloudLink.forge.msg.ForgeAmqpSendHistoriesResult;
import com.tridium.cloudLink.forge.msg.ForgeHistorySerializer;
import com.tridium.cloudLink.history.HistoryItemWrapper;
import com.tridium.cloudLink.msg.ISendHistoriesHandler;
import com.tridium.cloudLink.msg.SendHistoriesResult;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ForgeAmqpSendHistoriesHandler
extends ForgeAmqpHandler
implements ISendHistoriesHandler {
    private ForgeHistorySerializer serializer;
    private boolean _hasData;
    private int itemCount;
    private final BForgeHistoryChannelConfig config;
    public static final String COMMAND = "HistoryUpdateMessage";
    public static final String VERSION = "2";
    private static final int MSG_END_SIZE = 2;
    private static final Logger log = Logger.getLogger("cloudLink.channel.history");

    public ForgeAmqpSendHistoriesHandler(BChannelConfig channelConfig) {
        this.config = (BForgeHistoryChannelConfig)channelConfig;
        this.makeMessageHeaders(COMMAND, VERSION, this.config);
        this.initializeMessage();
    }

    public boolean hasData() {
        return this._hasData;
    }

    public int add(HistoryItemWrapper value) {
        this.serializer.serializeRecord(value);
        this._hasData = true;
        return this.stringWriter.getBuffer().length() + 2;
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        this.serializer.serializeEnd();
        return super.toMessage(isFinal);
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<SendHistoriesResult> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        int count = this.itemCount;
        future.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.WARNING, "Send history values message got error", log.isLoggable(Level.FINE) ? err : null);
                channelFuture.completeExceptionally((Throwable)err);
            } else {
                log.fine("Send history values message sent successfully");
                channelFuture.complete(new ForgeAmqpSendHistoriesResult(count));
            }
        });
        return future;
    }

    @Override
    protected void initializeMessage() {
        super.initializeMessage();
        this.serializer = new ForgeHistorySerializer(this.jsonSerializer);
        this.serializer.serializeStart();
        this._hasData = false;
        this.itemCount = 0;
    }

    @Override
    protected BAbstractTransport getTransport() {
        return this.config.getTransport(ISendHistoriesHandler.getOperationId());
    }
}

