/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.forge.channel.BForgeAmqpAlarmChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeAmqpAlarmHandler;
import com.tridium.cloudLink.msg.ISendBatchAlarmHandler;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;

public class ForgeAmqpSendBatchAlarmHandler
extends ForgeAmqpAlarmHandler
implements ISendBatchAlarmHandler {
    public static final String COMMAND = "AlarmRecoveryAfterDisconnectMessage";
    public static final String VERSION = "3";
    private static final int MSG_END_SIZE = 2;
    private static final Logger log = Logger.getLogger("cloudLink.channel.alarm");

    public ForgeAmqpSendBatchAlarmHandler(BChannelConfig channelConfig) {
        super((BForgeAmqpAlarmChannelConfig)channelConfig);
        this.makeMessageHeaders(COMMAND, VERSION, this.config);
        this.initializeMessage();
    }

    public int add(BAlarmRecord alarm) {
        this.serializeAlarm(alarm);
        return this.stringWriter.getBuffer().length() + 2;
    }

    public boolean hasData() {
        return this._hasData;
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        if (!this._hasData) {
            return null;
        }
        this.jsonSerializer.endArray();
        this.jsonSerializer.endObject();
        return super.toMessage(isFinal);
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<Boolean> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        future.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.WARNING, "Batch alarm message send error: " + err.getMessage(), log.isLoggable(Level.FINE) ? err : null);
                channelFuture.complete(false);
            } else {
                log.finer("Batch alarm message sent successfully");
                channelFuture.complete(true);
            }
        });
        return future;
    }

    @Override
    protected void initializeMessage() {
        super.initializeMessage();
        this.jsonSerializer.object();
        this.jsonSerializer.key("Alarms");
        this.jsonSerializer.array();
        this._hasData = false;
    }

    @Override
    protected BAbstractTransport getTransport() {
        return this.config.getTransport(ISendBatchAlarmHandler.getOperationId());
    }
}

