/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.forge.channel.BForgeAmqpEventChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeMsgConstants;
import com.tridium.cloudLink.msg.IEventSerializer;
import com.tridium.cloudLink.tag.CloudLinkTagUtil;
import com.tridium.json.JSONWriter;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.event.BEvent;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.tag.BIEntity;

public class ForgeAmqpEventSerializer
implements IEventSerializer<BEvent> {
    public static final String DOT = ".";
    private String createdTime;
    private String creatorId = "NiagaraFramework";
    private String creatorType = "Niagara4";
    private String eventType = "BEvent";
    private String id;
    private String targetContext;
    private String targetId;
    private String targetType = "BEvent";
    protected static final Logger log = Logger.getLogger("cloudLink.channel.event");

    public void serialize(BEvent event, BChannelConfig config, JSONWriter jw) {
        BForgeAmqpEventChannelConfig forgeAmqpEventChannelConfig = (BForgeAmqpEventChannelConfig)config;
        this.createdTime = event.getTimestamp().encodeToString();
        this.id = event.getUuid().toString();
        this.targetContext = "BOrdList";
        this.targetId = event.getSource().toString();
        this.targetType = "BEvent";
        this.checkForExternalValues(event);
        jw.key("Id").value((Object)this.id);
        jw.key("CreatedTime").value((Object)this.createdTime);
        jw.key("CreatorId").value((Object)this.creatorId);
        jw.key("CreatorType").value((Object)this.creatorType);
        jw.key("TargetId").value((Object)this.targetId);
        jw.key("TargetType").value((Object)this.targetType);
        jw.key("TargetContext").value((Object)this.targetContext);
        jw.key("Body").value(null);
        this.writeBodyProperties(event, forgeAmqpEventChannelConfig, jw);
        jw.key("EventType").value((Object)this.eventType);
    }

    protected void checkForExternalValues(BEvent event) {
        BValue value = event.getValue();
        if (value.isComplex()) {
            BComplex valCpx = value.asComplex();
            Optional.ofNullable(valCpx.get("createdTime")).ifPresent(v -> {
                this.createdTime = ((BAbsTime)v).encodeToString();
            });
            Optional.ofNullable(valCpx.get("creatorId")).ifPresent(v -> {
                this.creatorId = Objects.toString(v);
            });
            Optional.ofNullable(valCpx.get("creatorType")).ifPresent(v -> {
                this.creatorType = Objects.toString(v);
            });
            Optional.ofNullable(valCpx.get("eventType")).ifPresent(v -> {
                this.eventType = Objects.toString(v);
            });
            Optional.ofNullable(valCpx.get("id")).ifPresent(v -> {
                this.id = Objects.toString(v);
            });
            Optional.ofNullable(valCpx.get("targetContext")).ifPresent(v -> {
                this.targetContext = Objects.toString(v);
            });
            Optional.ofNullable(valCpx.get("targetId")).ifPresent(v -> {
                this.targetId = Objects.toString(v);
            });
            Optional.ofNullable(valCpx.get("targetType")).ifPresent(v -> {
                this.targetType = Objects.toString(v);
            });
        }
    }

    protected void writeBodyProperties(BEvent event, BForgeAmqpEventChannelConfig cfg, JSONWriter jw) {
        jw.key("BodyProperties").array();
        if (event.getSource().size() < 1) {
            log.config(String.format("Event %s has an empty source ord list.", event.getUuid().toString()));
        } else {
            try {
                BOrd sourceOrd = event.getSource().get(event.getSource().size() - 1);
                OrdTarget sourceObjTarget = sourceOrd.resolve((BObject)Sys.getStation());
                BObject sourceObj = sourceObjTarget.get();
                if (CloudLinkTagUtil.hasCloudId((BIEntity)((BIEntity)sourceObj))) {
                    ForgeAmqpEventSerializer.writeBodyProperty("CloudId", ((BIDataValue)CloudLinkTagUtil.getCloudId((BIEntity)((BIEntity)sourceObj)).get()).toString(), jw);
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, String.format("Error in resolving the source of event (%s): %s", event.getUuid().toString(), ex.getMessage()), log.isLoggable(Level.FINE) ? ex : null);
            }
        }
        ForgeAmqpEventSerializer.writeBodyProperty("EventUuid", event.getUuid().toString(), jw);
        ForgeAmqpEventSerializer.writeBodyProperty("EventTimestamp", event.getTimestamp().encodeToString(), jw);
        ForgeAmqpEventSerializer.writeBodyProperty("EventSource", event.getSource().toString(), jw);
        ForgeAmqpEventSerializer.writeBodyProperty("SystemType", cfg.getSystemType(), jw);
        BValue eventValue = event.getValue();
        ForgeAmqpEventSerializer.writeBodyProperty("EventValue", Objects.toString(eventValue), jw);
        if (eventValue.isComplex()) {
            SlotCursor props = eventValue.asComplex().getProperties();
            while (props.next()) {
                if (ForgeMsgConstants.OVERRIDE_PROPS.contains(props.property().getName())) continue;
                BValue v = props.get();
                if (v.isComplex()) {
                    ForgeAmqpEventSerializer.writeComplexBodyProperty(props.property().getName(), v.asComplex(), jw);
                    continue;
                }
                ForgeAmqpEventSerializer.writeBodyProperty(props.property().getName(), Objects.toString(v), jw);
            }
        }
        jw.endArray();
    }

    protected static void writeBodyProperty(String name, String value, JSONWriter jw) {
        Objects.requireNonNull(name, "BodyProperty key must not be null");
        jw.object().key("Key").value((Object)name).key("Value").value((Object)value).endObject();
    }

    protected static void writeComplexBodyProperty(String name, BComplex c, JSONWriter jw) {
        c.getProperties().stream().forEach(p -> {
            BValue v = c.get(p);
            if (v.isComplex()) {
                ForgeAmqpEventSerializer.writeComplexBodyProperty(name + DOT + p.getName(), v.asComplex(), jw);
            } else {
                ForgeAmqpEventSerializer.writeBodyProperty(name + DOT + p.getName(), Objects.toString(v), jw);
            }
        });
    }
}

