/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.forge.channel.BForgeAmqpEventChannelConfig;
import com.tridium.cloudLink.msg.IEventSerializer;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import java.util.Objects;
import java.util.UUID;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponentEvent;

public class ForgeAmqpComponentEventSerializer
implements IEventSerializer<BComponentEvent> {
    private static final String creatorId = "NiagaraFramework";
    private static final String creatorType = "Niagara4";

    public void serialize(BComponentEvent componentEvent, BChannelConfig config, JSONWriter jw) {
        BForgeAmqpEventChannelConfig faecc = (BForgeAmqpEventChannelConfig)config;
        jw.key("Id").value((Object)UUID.randomUUID());
        jw.key("CreatedTime").value((Object)BAbsTime.now().encodeToString());
        jw.key("CreatorId").value((Object)creatorId);
        jw.key("CreatorType").value((Object)creatorType);
        ForgeAmqpComponentEventSerializer.addTargetProperties(componentEvent, jw);
        jw.key("Body").object();
        jw.key("Type").value((Object)"TextualBody");
        JSONObject bodyValue = new JSONObject();
        ForgeAmqpComponentEventSerializer.buildBody(bodyValue, componentEvent);
        jw.key("Value").value((Object)bodyValue.toString());
        jw.key("Format").value((Object)"application/json");
        jw.endObject();
        jw.key("BodyProperties").array();
        jw.object().key("Key").value((Object)"SystemType").key("Value").value((Object)faecc.getSystemType()).endObject();
        jw.object().key("Key").value((Object)"SystemGuid").key("Value").value((Object)faecc.getSystemGuid()).endObject();
        jw.endArray();
        jw.key("EventType").value((Object)Objects.toString(componentEvent.getId()));
    }

    private static void addTargetProperties(BComponentEvent componentEvent, JSONWriter jw) {
        jw.key("TargetId").value((Object)componentEvent.getSourceComponent().getSlotPathOrd());
        jw.key("TargetContext").value((Object)componentEvent.getSlotName());
        jw.key("TargetType").value((Object)"BComponentEvent");
    }

    private static void buildBody(JSONObject body, BComponentEvent componentEvent) {
        body.put("EventValue", (Object)Objects.toString(componentEvent.getValue()));
        if (componentEvent.getKnob() != null) {
            body.put("EventKnob", (Object)Objects.toString(componentEvent.getKnob()));
        }
        if (componentEvent.getRelationKnob() != null) {
            body.put("EventRelationKnob", (Object)Objects.toString(componentEvent.getRelationKnob()));
        }
    }
}

