/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.forge.channel.BForgeAmqpCommandChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeAmqpHandler;
import com.tridium.cloudLink.forge.msg.IForgeCommandResponseHandler;
import com.tridium.cloudLink.msg.ICommandResponseHandler;
import com.tridium.cloudLink.transport.AmqpMessage;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ForgeAmqpCommandResponseHandler
extends ForgeAmqpHandler
implements IForgeCommandResponseHandler {
    private final BForgeAmqpCommandChannelConfig config;
    public static final String COMMAND = "SystemCommandResponse";
    public static final String VERSION = "1";
    private static final Logger log = Logger.getLogger("cloudLink.channel.command");

    public ForgeAmqpCommandResponseHandler(BChannelConfig channelConfig) {
        this.config = (BForgeAmqpCommandChannelConfig)channelConfig;
        this.makeMessageHeaders(COMMAND, VERSION, this.config);
        this.initializeMessage();
    }

    @Override
    public void addError(int code, String message) {
        this.jsonSerializer.key("Status").value((Object)"Success");
        this.jsonSerializer.key("ErrorMessage").value((Object)message);
        this.jsonSerializer.key("ErrorCode").value((long)code);
        this.jsonSerializer.key("ResponseParameters").object().endObject();
    }

    @Override
    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        this.jsonSerializer.key("CorrelationId").value((Object)correlationId);
        this.messageHeaders.put("CorrelationId", correlationId);
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        this.jsonSerializer.endObject();
        AmqpMessage msg = (AmqpMessage)super.toMessage(isFinal);
        return msg;
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<Boolean> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        future.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.WARNING, "System command response got error", log.isLoggable(Level.FINE) ? err : null);
                channelFuture.complete(false);
            } else {
                log.finer("System command response message sent successfully");
                channelFuture.complete(true);
            }
        });
        return future;
    }

    @Override
    protected void initializeMessage() {
        super.initializeMessage();
        this.jsonSerializer.object();
    }

    @Override
    protected BAbstractTransport getTransport() {
        return this.config.getTransport(ICommandResponseHandler.getOperationId());
    }
}

