/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.forge.alarm.AckStates;
import com.tridium.cloudLink.forge.alarm.NiagaraAlarmPriorities;
import com.tridium.cloudLink.forge.alarm.NiagaraAlarmStates;
import com.tridium.cloudLink.forge.channel.BForgeAmqpAlarmChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeAmqpHandler;
import com.tridium.cloudLink.forge.util.ForgeUtils;
import com.tridium.cloudLink.tag.CloudLinkTagUtil;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.util.BFormat;

public abstract class ForgeAmqpAlarmHandler
extends ForgeAmqpHandler {
    protected boolean _hasData;
    protected final BForgeAmqpAlarmChannelConfig config;
    private static final Logger log = Logger.getLogger("cloudLink.channel.alarm");

    protected ForgeAmqpAlarmHandler(BForgeAmqpAlarmChannelConfig config) {
        this.config = config;
    }

    protected void serializeAlarm(BAlarmRecord alarm) {
        this.jsonSerializer.object();
        this.jsonSerializer.key("Id").value((Object)alarm.getUuid());
        this.jsonSerializer.key("CreatedTime").value((Object)alarm.getTimestamp().encodeToString());
        this.jsonSerializer.key("CreatorId").value((Object)"NiagaraFramework");
        this.jsonSerializer.key("CreatorType").value((Object)"Niagara4");
        this.jsonSerializer.key("GeneratorId").value((Object)this.config.getSystemGuid());
        this.jsonSerializer.key("GeneratorType").value((Object)"CloudLink");
        ForgeAmqpAlarmHandler.addTargetProperties(alarm, this.jsonSerializer);
        this.jsonSerializer.key("Body");
        this.jsonSerializer.object();
        this.jsonSerializer.key("Type").value((Object)"TextualBody");
        JSONObject bodyValue = new JSONObject();
        ForgeAmqpAlarmHandler.buildBody(bodyValue, alarm);
        this.jsonSerializer.key("Value").value((Object)bodyValue.toString());
        this.jsonSerializer.key("Format").value((Object)"application/json");
        this.jsonSerializer.endObject();
        this.jsonSerializer.key("TriggeringEvents");
        this.jsonSerializer.array();
        this.jsonSerializer.object();
        this.jsonSerializer.key("EventType").value((Object)alarm.getAlarmTransition().toString());
        this.jsonSerializer.key("EventId").value((long)alarm.getAlarmTransition().getOrdinal());
        this.jsonSerializer.endObject();
        this.jsonSerializer.endArray();
        this.jsonSerializer.key("BodyProperties");
        this.jsonSerializer.array();
        this.jsonSerializer.object();
        this.jsonSerializer.key("Key").value((Object)"SystemType");
        this.jsonSerializer.key("Value").value((Object)this.config.getSystemType());
        this.jsonSerializer.endObject();
        this.jsonSerializer.object();
        this.jsonSerializer.key("Key").value((Object)"SystemGuid");
        this.jsonSerializer.key("Value").value((Object)this.config.getSystemGuid());
        this.jsonSerializer.endObject();
        this.jsonSerializer.object();
        this.jsonSerializer.key("Key").value((Object)"ordList");
        this.jsonSerializer.key("Value").value((Object)alarm.getSource().encodeToString());
        this.jsonSerializer.endObject();
        this.jsonSerializer.endArray();
        this.jsonSerializer.key("AlarmState").value((Object)ForgeAmqpAlarmHandler.getAlarmState(alarm).toString());
        this.jsonSerializer.key("Priority").value((Object)ForgeAmqpAlarmHandler.getAlarmPriority(alarm).toString());
        this.jsonSerializer.key("AckState").value((Object)ForgeAmqpAlarmHandler.getAlarmAckState(alarm).toString());
        this.jsonSerializer.key("AckTime").value((Object)alarm.getAckTime().encodeToString());
        this.jsonSerializer.key("AckUser").value((Object)alarm.getUser());
        this.jsonSerializer.endObject();
        this._hasData = true;
    }

    private static void addTargetProperties(BAlarmRecord alarm, JSONWriter jsonSerializer) {
        StringBuilder targetIdList = new StringBuilder();
        StringBuilder targetTypeList = new StringBuilder();
        try {
            BOrdList source = alarm.getSource();
            log.finer(() -> String.format("ForgeAlarmMessage: getSource() alarm:%s; alarm source ordList=%s", alarm, source));
            BOrd sourceOrd = BOrd.DEFAULT;
            if (source.size() > 0) {
                sourceOrd = source.get(source.size() - 1);
            }
            BObject sourceObj = BOrd.make((BOrd)BOrd.make((String)"local:|station:|slot:/"), (BOrd)sourceOrd).resolve().get();
            BControlPoint sourcePoint = null;
            if (sourceObj instanceof BAlarmSourceExt) {
                log.finest(() -> String.format("Alarm source is BAlarmSourceExt:%s", sourceObj.asComponent().getSlotPath()));
                sourcePoint = ((BAlarmSourceExt)sourceObj.as(BAlarmSourceExt.class)).getParentPoint();
            } else if (sourceObj instanceof BIAlarmSource) {
                log.finest(() -> String.format("Alarm source is BIAlarmSource:%s", sourceObj.asComponent().getSlotPath()));
                BComponent parent = sourceObj.asComplex().getParent().asComponent();
                if (parent instanceof BControlPoint) {
                    log.finest(() -> String.format("Found control point parent for alarm source:%s [%s]", parent.getSlotPath(), parent.getType()));
                    sourcePoint = (BControlPoint)parent.as(BControlPoint.class);
                } else {
                    log.finest(() -> String.format("BIAlarmSource parent is not a control point:%s [%s]", parent.getSlotPath(), parent.getType()));
                }
            }
            if (sourcePoint != null) {
                targetIdList.append(CloudLinkTagUtil.getCloudIdString(sourcePoint).orElse(alarm.getSource().encodeToString()));
                targetTypeList.append("Point");
            } else {
                targetIdList.append(CloudLinkTagUtil.getCloudIdString((BIObject)sourceObj).orElse(alarm.getSource().encodeToString()));
                targetTypeList.append("Device");
            }
        }
        catch (Exception ex) {
            log.log(Level.CONFIG, "Cannot resolve alarm to cloud point: " + ex, log.isLoggable(Level.FINE) ? ex : null);
            targetIdList.append(alarm.getSource().encodeToString());
            targetTypeList.append("Device");
        }
        jsonSerializer.key("TargetId").value((Object)targetIdList.toString());
        jsonSerializer.key("TargetType").value((Object)targetTypeList.toString());
        jsonSerializer.key("TargetContext").value((Object)"Alarm");
    }

    private static void buildBody(JSONObject bodyValue, BAlarmRecord record) {
        BFacets alarmData = record.getAlarmData();
        for (String key : alarmData.list()) {
            if (key.equalsIgnoreCase("msgText")) {
                bodyValue.put(key, (Object)BFormat.make((String)alarmData.get(key).toString()).format((Object)record));
                continue;
            }
            bodyValue.put(key, (Object)alarmData.get(key));
        }
        bodyValue.put("AlarmClass", (Object)record.getAlarmClass());
        bodyValue.put("NormalTime", (Object)record.getNormalTime().encodeToString());
        bodyValue.put("LastUpdateTime", (Object)record.getLastUpdate().encodeToString());
        bodyValue.put("AckRequired", record.getAckRequired());
        bodyValue.put("Priority", record.getPriority());
        bodyValue.put("AlarmState", (Object)record.getSourceState().toString());
        bodyValue.put("AlarmTransition", (Object)record.getAlarmTransition().toString());
    }

    private static NiagaraAlarmStates getAlarmState(BAlarmRecord record) {
        switch (record.getSourceState().getOrdinal()) {
            case 0: {
                return NiagaraAlarmStates.Normal;
            }
            case 1: {
                return NiagaraAlarmStates.Offnormal;
            }
            case 2: {
                return NiagaraAlarmStates.Fault;
            }
            case 3: {
                return NiagaraAlarmStates.Alert;
            }
        }
        return NiagaraAlarmStates.Undefined;
    }

    private static AckStates getAlarmAckState(BAlarmRecord record) {
        switch (record.getAckState().getOrdinal()) {
            case 0: {
                return AckStates.Acked;
            }
            case 1: {
                return AckStates.Unacked;
            }
            case 2: {
                return AckStates.Pending;
            }
        }
        return AckStates.Undefined;
    }

    private static NiagaraAlarmPriorities getAlarmPriority(BAlarmRecord record) {
        int priority = record.getPriority();
        if (ForgeUtils.isBetween(priority, 0, 31)) {
            return NiagaraAlarmPriorities.Emergency;
        }
        if (ForgeUtils.isBetween(priority, 32, 64)) {
            return NiagaraAlarmPriorities.Alert;
        }
        if (ForgeUtils.isBetween(priority, 65, 97)) {
            return NiagaraAlarmPriorities.Critical;
        }
        if (ForgeUtils.isBetween(priority, 98, 130)) {
            return NiagaraAlarmPriorities.Error;
        }
        if (ForgeUtils.isBetween(priority, 131, 163)) {
            return NiagaraAlarmPriorities.Warning;
        }
        if (ForgeUtils.isBetween(priority, 164, 196)) {
            return NiagaraAlarmPriorities.Notice;
        }
        if (ForgeUtils.isBetween(priority, 197, 229)) {
            return NiagaraAlarmPriorities.Information;
        }
        if (ForgeUtils.isBetween(priority, 230, 254)) {
            return NiagaraAlarmPriorities.Diagnostic;
        }
        return NiagaraAlarmPriorities.Undefined;
    }
}

