/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.command.BWritePointCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.util.concurrent.CompletableFuture;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeWritePointSystemCommand
extends BWritePointCommand
implements BIForgeCommand {
    public static final Type TYPE = Sys.loadType(BForgeWritePointSystemCommand.class);
    public static final String COMMAND = "SystemCommand";
    public static final String COMMAND_NAME = "CloudPointWriteCommand";
    public static final String VERSION = "1";

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "SystemCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        int code;
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)data.getJSONObject("CommandParameters"), (String)"CommandPayload"));
        String pointId = JSONUtil.getString((JSONObject)payload, (String)"PointId");
        Object value = payload.get("Value");
        int priority = 0;
        BRelTime duration = null;
        if (payload.has("Priority")) {
            priority = payload.getInt("Priority");
        }
        if (payload.has("Duration")) {
            duration = BRelTime.makeMinutes((int)payload.getInt("Duration"));
        }
        String source = payload.has("Source") ? JSONUtil.getString((JSONObject)payload, (String)"Source") : JSONUtil.getString((JSONObject)data, (String)"CallingIdentity");
        boolean result = this.writePoint(messageId, pointId, value, priority, duration, source, cx);
        JSONObject body = new JSONObject();
        JSONObject pointData = new JSONObject();
        if (result) {
            pointData.put("WriteTime", (Object)BAbsTime.now().encodeToString());
            pointData.put("Status", (Object)"Success");
            body.put(pointId, (Object)pointData);
            body.put("ResponseCode", 200);
            body.put("ErrorMessage", (Object)"Status: OK");
            code = 200;
        } else {
            pointData.put("Status", (Object)"Error: Invalid point write");
            body.put(pointId, (Object)pointData);
            body.put("ResponseCode", 403);
            body.put("ErrorMessage", (Object)"Error: Access Not Allowed");
            code = 403;
        }
        BForgeCommandContainer container = (BForgeCommandContainer)this.getParent().as(BForgeCommandContainer.class);
        return container.sendDataEvent(new ForgeCommandDataEvent(messageId, code, body));
    }
}

