/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.ICloudLinkMessageHandler;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.channel.BCommandsChannel;
import com.tridium.cloudLink.command.BWritePointCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.msg.IForgeMultiPointWriteCommandHandler;
import com.tridium.cloudLink.msg.IMultiPointWriteCommandHandler;
import com.tridium.cloudLink.msg.IPointWriteCommandHandler;
import com.tridium.cloudLink.msg.PointWriteResult;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.MessageWrapper;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.io.IOException;
import java.security.AccessController;
import java.util.concurrent.CompletableFuture;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeWriteMultiPointCommand
extends BWritePointCommand
implements BIForgeCommand {
    public static final Type TYPE = Sys.loadType(BForgeWriteMultiPointCommand.class);
    public static final String COMMAND = "MultiPointWriteCommand";
    public static final String VERSION = "1";

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "MultiPointWriteCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public ICloudLinkMessageHandler<Boolean> getErrorResponse(BAbstractCloudLinkHandlerFactory msgFactory, BChannelConfig channelConfig, String commandId, int code, String message) {
        IForgeMultiPointWriteCommandHandler handler = (IForgeMultiPointWriteCommandHandler)msgFactory.getMessageHandler(IForgeMultiPointWriteCommandHandler.class, channelConfig);
        handler.addError(code, message);
        handler.setCorrelationId(commandId);
        return handler;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        JSONArray points = data.getJSONArray("PointWrites");
        String callingIdentity = JSONUtil.getString((JSONObject)data, (String)"CallingIdentity");
        BCommandsChannel channel = this.getChannel();
        BChannelConfig config = channel.getChannelConfig();
        BAbstractTransport transport = config.getTransport(IPointWriteCommandHandler.getOperationId());
        if (!transport.canSend()) {
            log.warning("unable to send command response transport down " + messageId);
            future.completeExceptionally(new IOException("transport down"));
            return future;
        }
        BAbstractCloudLinkHandlerFactory msgFactory = (BAbstractCloudLinkHandlerFactory)((BCloudConnectionService)channel.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service."))).getMessageHandlerFactory(channel.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        IForgeMultiPointWriteCommandHandler handler = (IForgeMultiPointWriteCommandHandler)msgFactory.getMessageHandler(IForgeMultiPointWriteCommandHandler.class, config);
        handler.setCorrelationId(messageId);
        for (int lcv = 0; lcv < points.length(); ++lcv) {
            JSONObject point = points.getJSONObject(lcv);
            String pointId = JSONUtil.getString((JSONObject)point, (String)"PointId");
            Object value = point.get("Value");
            boolean result = this.writePoint(messageId, pointId, value, 0, null, callingIdentity, cx);
            handler.add(new PointWriteResult(pointId, result));
        }
        MessageWrapper wrapper = new MessageWrapper(handler.toMessage(), handler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            config.enqueueMessage(IMultiPointWriteCommandHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return future;
    }
}

