/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.channel;

import com.tridium.cloudLink.channel.BIHistoryChannelConfig;
import com.tridium.cloudLink.channel.BMultiTransportChannelConfig;
import com.tridium.cloudLink.channel.BTransportConfig;
import com.tridium.cloudLink.file.IUploadChannelConfig;
import com.tridium.cloudLink.forge.auth.BAbstractForgeAuthenticator;
import com.tridium.cloudLink.forge.channel.IForgeChannelConfig;
import com.tridium.cloudLink.history.BHistoryUpdateMode;
import com.tridium.cloudLink.msg.IEndFileUploadHandler;
import com.tridium.cloudLink.msg.IGetHistoriesHandler;
import com.tridium.cloudLink.msg.IGetLastTimestampsHandler;
import com.tridium.cloudLink.msg.ISendBulkHistoriesHandler;
import com.tridium.cloudLink.msg.ISendHistoriesHandler;
import com.tridium.cloudLink.msg.IStartFileUploadHandler;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="amqpTransport", type="BTransportConfig", defaultValue="new BTransportConfig(CLOUD_LINK_TRANSPORT_AMQP, AUTH_PLATFORM_TYPE_RPK)", flags=1), @NiagaraProperty(name="httpTransport", type="BTransportConfig", defaultValue="new BTransportConfig(CLOUD_LINK_TRANSPORT_HTTP, AUTH_PLATFORM_TYPE_FEDERATED)", flags=1), @NiagaraProperty(name="fileTransport", type="BTransportConfig", defaultValue="new BTransportConfig(CLOUD_LINK_TRANSPORT_HTTP, AUTH_PLATFORM_TYPE_RPK, FILE_UPLOAD_DEFAULT_MESSAGE_SIZE)", flags=1), @NiagaraProperty(name="backfillRecordThreshold", type="int", defaultValue="500000", facets={@Facet(name="BFacets.MIN", value="100000")}), @NiagaraProperty(name="backfillReconnectMinTime", type="BRelTime", defaultValue="BRelTime.make(21600000)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(7200000)")}), @NiagaraProperty(name="backfillFileUploadTimeout", type="BRelTime", defaultValue="BRelTime.makeMinutes(15)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeMinutes(15)"), @Facet(name="BFacets.MAX", value="BRelTime.makeHours(1)")}), @NiagaraProperty(name="backfillStatus", type="BString", defaultValue="BString.DEFAULT", flags=3, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="updateMode", type="BHistoryUpdateMode", defaultValue="BHistoryUpdateMode.PubSub", flags=5), @NiagaraProperty(name="cloudIdRequired", type="BBoolean", defaultValue="BBoolean.TRUE", flags=5), @NiagaraProperty(name="onboarding", type="boolean", defaultValue="false", flags=5, facets={@Facet(name="BFacets.TRUE_TEXT", value="BString.make(\"%lexicon(cloudLinkForge:historyChannelConfig.onboarding.true)%\")"), @Facet(name="BFacets.FALSE_TEXT", value="BString.make(\"%lexicon(cloudLinkForge:historyChannelConfig.onboarding.false)%\")")}), @NiagaraProperty(name="lastTimestampIdLimit", type="int", defaultValue="2000", flags=5, facets={@Facet(name="BFacets.MIN", value="500"), @Facet(name="BFacets.MAX", value="13000")}), @NiagaraProperty(name="exportId", type="BInteger", defaultValue="BInteger.DEFAULT", flags=4), @NiagaraProperty(name="connectionInfoName", type="BString", defaultValue="BString.make(IOT_HUB_2_SERVICE)", flags=5)})
public class BForgeHistoryChannelConfig
extends BMultiTransportChannelConfig
implements BIHistoryChannelConfig,
IForgeChannelConfig,
IUploadChannelConfig {
    public static final Property amqpTransport = BForgeHistoryChannelConfig.newProperty((int)1, (BValue)new BTransportConfig("AMQP", "RpkAuthenticator"), null);
    public static final Property httpTransport = BForgeHistoryChannelConfig.newProperty((int)1, (BValue)new BTransportConfig("HTTP", "FederatedIdentity"), null);
    public static final Property fileTransport = BForgeHistoryChannelConfig.newProperty((int)1, (BValue)new BTransportConfig("HTTP", "RpkAuthenticator", 5000000), null);
    public static final Property backfillRecordThreshold = BForgeHistoryChannelConfig.newProperty((int)0, (int)500000, (BFacets)BFacets.make((String)"min", (int)100000));
    public static final Property backfillReconnectMinTime = BForgeHistoryChannelConfig.newProperty((int)0, (BValue)BRelTime.make((long)21600000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0x6DDD00L)));
    public static final Property backfillFileUploadTimeout = BForgeHistoryChannelConfig.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)15), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)15)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeHours((int)1))));
    public static final Property backfillStatus = BForgeHistoryChannelConfig.newProperty((int)3, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property updateMode = BForgeHistoryChannelConfig.newProperty((int)5, (BValue)BHistoryUpdateMode.PubSub, null);
    public static final Property cloudIdRequired = BForgeHistoryChannelConfig.newProperty((int)5, (boolean)((BBoolean)BBoolean.TRUE.as(BBoolean.class)).getBoolean(), null);
    public static final Property onboarding = BForgeHistoryChannelConfig.newProperty((int)5, (boolean)false, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"%lexicon(cloudLinkForge:historyChannelConfig.onboarding.true)%")), (BFacets)BFacets.make((String)"falseText", (BIDataValue)BString.make((String)"%lexicon(cloudLinkForge:historyChannelConfig.onboarding.false)%"))));
    public static final Property lastTimestampIdLimit = BForgeHistoryChannelConfig.newProperty((int)5, (int)2000, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)500), (BFacets)BFacets.make((String)"max", (int)13000)));
    public static final Property exportId = BForgeHistoryChannelConfig.newProperty((int)4, (int)((BInteger)BInteger.DEFAULT.as(BInteger.class)).getInt(), null);
    public static final Property connectionInfoName = BForgeHistoryChannelConfig.newProperty((int)5, (BValue)BString.make((String)"IoTHub2"), null);
    public static final Type TYPE = Sys.loadType(BForgeHistoryChannelConfig.class);
    private static final String CHANNEL_CONFIG_STRING = "History Channel Config: AMQP/HTTP";
    private static final Logger log = Logger.getLogger("cloudLink.channel.history");

    public BTransportConfig getAmqpTransport() {
        return (BTransportConfig)this.get(amqpTransport);
    }

    public void setAmqpTransport(BTransportConfig v) {
        this.set(amqpTransport, (BValue)v, null);
    }

    public BTransportConfig getHttpTransport() {
        return (BTransportConfig)this.get(httpTransport);
    }

    public void setHttpTransport(BTransportConfig v) {
        this.set(httpTransport, (BValue)v, null);
    }

    public BTransportConfig getFileTransport() {
        return (BTransportConfig)this.get(fileTransport);
    }

    public void setFileTransport(BTransportConfig v) {
        this.set(fileTransport, (BValue)v, null);
    }

    public int getBackfillRecordThreshold() {
        return this.getInt(backfillRecordThreshold);
    }

    public void setBackfillRecordThreshold(int v) {
        this.setInt(backfillRecordThreshold, v, null);
    }

    public BRelTime getBackfillReconnectMinTime() {
        return (BRelTime)this.get(backfillReconnectMinTime);
    }

    public void setBackfillReconnectMinTime(BRelTime v) {
        this.set(backfillReconnectMinTime, (BValue)v, null);
    }

    public BRelTime getBackfillFileUploadTimeout() {
        return (BRelTime)this.get(backfillFileUploadTimeout);
    }

    public void setBackfillFileUploadTimeout(BRelTime v) {
        this.set(backfillFileUploadTimeout, (BValue)v, null);
    }

    public String getBackfillStatus() {
        return this.getString(backfillStatus);
    }

    public void setBackfillStatus(String v) {
        this.setString(backfillStatus, v, null);
    }

    public BHistoryUpdateMode getUpdateMode() {
        return (BHistoryUpdateMode)this.get(updateMode);
    }

    public void setUpdateMode(BHistoryUpdateMode v) {
        this.set(updateMode, (BValue)v, null);
    }

    public boolean getCloudIdRequired() {
        return this.getBoolean(cloudIdRequired);
    }

    public void setCloudIdRequired(boolean v) {
        this.setBoolean(cloudIdRequired, v, null);
    }

    public boolean getOnboarding() {
        return this.getBoolean(onboarding);
    }

    public void setOnboarding(boolean v) {
        this.setBoolean(onboarding, v, null);
    }

    public int getLastTimestampIdLimit() {
        return this.getInt(lastTimestampIdLimit);
    }

    public void setLastTimestampIdLimit(int v) {
        this.setInt(lastTimestampIdLimit, v, null);
    }

    public int getExportId() {
        return this.getInt(exportId);
    }

    public void setExportId(int v) {
        this.setInt(exportId, v, null);
    }

    public String getConnectionInfoName() {
        return this.getString(connectionInfoName);
    }

    public void setConnectionInfoName(String v) {
        this.setString(connectionInfoName, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        BTransportConfig amqpTransportConfig = this.getAmqpTransport();
        BFacets amqpMaxMsgSizeFacets = amqpTransportConfig.getSlotFacets((Slot)BTransportConfig.maxMessageSize);
        amqpTransportConfig.setFacets((Slot)BTransportConfig.maxMessageSize, BFacets.make((BFacets)amqpMaxMsgSizeFacets, (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)2000000))));
        BTransportConfig fileTransport = this.getFileTransport();
        BFacets fileMaxMsgSizeFacets = fileTransport.getSlotFacets((Slot)BTransportConfig.maxMessageSize);
        fileTransport.setFacets((Slot)BTransportConfig.maxMessageSize, BFacets.make((BFacets)fileMaxMsgSizeFacets, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1000000))));
    }

    public String getPlatformType() {
        return "Forge";
    }

    public void validateConfiguration(String prefix, StringBuilder err) {
        super.validateConfiguration(prefix, err);
        if (!(this.getAuthenticator(this.getAmqpTransport()) instanceof BAbstractForgeAuthenticator)) {
            log.info(() -> String.format("%s: History channel %s", prefix, "Invalid authenticator configured"));
            err.append("Invalid authenticator configured").append(';');
        }
    }

    @Override
    public String getSystemGuid() {
        BAbstractForgeAuthenticator auth = (BAbstractForgeAuthenticator)this.getAuthenticator(this.getAmqpTransport()).as(BAbstractForgeAuthenticator.class);
        return auth.getSystemGuid();
    }

    public String getSystemId() {
        return this.getAuthenticator(this.getAmqpTransport()).getSystemId();
    }

    protected void registerOps() {
        this.operationMap.clear();
        this.operationMap.put(IEndFileUploadHandler.getOperationId(), this.getFileTransport());
        this.operationMap.put(IGetLastTimestampsHandler.getOperationId(), this.getAmqpTransport());
        this.operationMap.put(IGetHistoriesHandler.getOperationId(), this.getHttpTransport());
        this.operationMap.put(ISendHistoriesHandler.getOperationId(), this.getAmqpTransport());
        this.operationMap.put(ISendBulkHistoriesHandler.getOperationId(), this.getFileTransport());
        this.operationMap.put(IStartFileUploadHandler.getOperationId(), this.getFileTransport());
    }

    public Map<String, Object> getRequestProps(String operation) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        AccessController.doPrivileged(() -> {
            this.getAuthenticator(operation).addMessageHandlerProperties(this.getTransport(operation), null, (Map)props);
            return null;
        });
        String correlationId = UUID.randomUUID().toString();
        log.fine(() -> "CorrelationId: " + correlationId);
        props.put("X-Correlation-Id", correlationId);
        return props;
    }

    public String toString(Context cx) {
        return CHANNEL_CONFIG_STRING;
    }
}

