/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.forge.auth.BRpkAuthenticator;
import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.security.BCertificateAliasAndPassword;

public class ForgeRegistrationRequest
implements IMessageBuilder {
    private final BRpkAuthenticator authenticator;
    private final BCertificateAliasAndPassword certAliasAndPass;
    private final String registrationHost;
    private static final Logger log = Logger.getLogger("cloudLink.auth.federated");
    private static final String SYSTEM_OWNERSHIP_CODE = "systemOwnershipCode";
    private static final String SYSTEM_ID = "systemId";
    private static final String SYSTEM_PUBLIC_KEY = "systemPublicKey";
    private static final String SYSTEM_TYPE = "systemType";
    private static final String API_PATH = "/api/v1/forge-adapter/device/register";

    public ForgeRegistrationRequest(String server, BRpkAuthenticator authenticator, BCertificateAliasAndPassword certAliasAndPass) {
        this.registrationHost = server;
        this.authenticator = authenticator;
        this.certAliasAndPass = certAliasAndPass;
    }

    public IMessage toMessage(boolean isFinal) {
        StringWriter stringWriter = new StringWriter();
        JSONWriter jsonSerializer = QuickJSONWriter.make((Appendable)stringWriter);
        jsonSerializer.object();
        jsonSerializer.key(SYSTEM_OWNERSHIP_CODE).value((Object)this.authenticator.getSystemOwnershipCode());
        jsonSerializer.key(SYSTEM_ID).value((Object)this.authenticator.getSystemId());
        jsonSerializer.key(SYSTEM_PUBLIC_KEY).value((Object)this.authenticator.getSystemPublicKey());
        jsonSerializer.key(SYSTEM_TYPE).value((Object)this.authenticator.getSystemType());
        jsonSerializer.endObject();
        stringWriter.flush();
        URL url = null;
        try {
            url = new URL("https://" + this.registrationHost + API_PATH);
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for IoTHub registration request", log.isLoggable(Level.FINE) ? ex : null);
        }
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending IoTHub registration request with correlation " + correlationId);
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, url, Collections.singletonMap("x-activity-id", correlationId)).mimeType("application/json").certificateAliasAndPassword(this.certAliasAndPass).body(stringWriter.getBuffer().toString()).build();
    }
}

